﻿using System;
using System.IO;
using System.Linq;
using System.Text.RegularExpressions;
using System.Drawing;
using System.Web.UI.WebControls;

namespace ynhtm.Admin
{
    using Common;

    public partial class PostEdit : Upfile
    {
        void ControlBind()
        {
            var setting = new BLL.Setting();
            var settingItem = setting.Get();
            var dir = new DirectoryInfo(this.MapPath("~/Theme/" + settingItem.Theme.IifNullOrWhiteSpace("Default")));
            if (dir.Exists)
            {
                var files = dir.GetFiles();
                foreach (var i in files.Where(i => i.Name.StartsWith("Post", StringComparison.OrdinalIgnoreCase) && Regex.IsMatch(i.Extension, @"\.(cshtml|vbhtml)$", RegexOptions.Compiled | RegexOptions.IgnoreCase))) this.dropTheme.Items.Add(i.Name);
            }

            var category = new BLL.Category();
            this.dropCategoryID.DataValueField = DAL.Category.CATEGORYID;
            this.dropCategoryID.DataTextField = DAL.Category.NAME;
            this.dropCategoryID.DataSource = category.GetList();
            this.dropCategoryID.DataBind();
        }

        void ControlReset()
        {
            this.txtTitle.Text = "";
        }

        void SetValue(Model.Post item)
        {
            item.Title = this.txtTitle.Text;
            item.Rewrite = this.txtRewrite.Text;
            item.Theme = this.dropTheme.Text;
            item.Content = this.txtContent.Text;
            item.Summary = this.txtSummary.Text;
            item.Tags = this.txtTags.Text;
            item.CategoryID = this.dropCategoryID.TryGet(int.Parse);
            item.Enabled = this.chkEnabled.Checked;
            item.CommentEnabled = this.chkCommentEnabled.Checked;
            item.IsTop = this.chkIsTop.Checked;
            item.IsHide = this.chkIsHide.Checked;
            item.Face = this.txtFace.Text;
            item.Source = this.txtSource.Text;
            item.Author = this.txtAuthor.Text;
            var titleStyle = 0;
            foreach(ListItem i in this.chklTitleStyle.Items){
                if (i.Selected) titleStyle |= int.Parse(i.Value);
            }
            item.TitleStyle = titleStyle;
            item.TitleColor = this.txtTitleColor.Text;
        }

        void AddBegin()
        {
            this.ViewState["KeyID"] = null;
            this.Title = "发表文章 - 管理中心";
            this.lblTitle.Text = "发表文章";
            this.btnEdit.Text = "发表";
        }

        Model.Post AddEnd()
        {
            var item = new Model.Post();
            this.SetValue(item);
            var user = ((Model.IPrincipal)this.User).User;
            item.UserID = user.UserID;
            var post = new BLL.Post();
            post.Insert(item);
            return item;
        }

        void EditBegin(int keyID)
        {
            this.ViewState["KeyID"] = keyID;
            this.Title = "编辑文章 - 管理中心";
            this.lblTitle.Text = "编辑文章";
            this.btnEdit.Text = "编辑";

            var post = new BLL.Post();
            var item = post.GetByPostID(keyID);

            this.txtTitle.Text = item.Title;
            this.txtFace.Text = item.Face;
            this.txtRewrite.Text = item.Rewrite;
            this.dropTheme.SelectValue(item.Theme);
            this.txtContent.Text = item.Content;
            this.txtSummary.Text = item.Summary;
            this.txtTags.Text = item.Tags;
            this.dropCategoryID.SelectValue(item.CategoryID.ToString());

            this.chkEnabled.Checked = item.Enabled;
            this.chkCommentEnabled.Checked = item.CommentEnabled;
            this.chkIsTop.Checked = item.IsTop;
            this.chkIsHide.Checked = item.IsHide;

            this.txtSource.Text = item.Source;
            this.txtAuthor.Text = item.Author;

            var titleStyle = item.TitleStyle;
            foreach (ListItem i in this.chklTitleStyle.Items)
            {
                var val = int.Parse(i.Value);
                i.Selected = (titleStyle & val) == val;
            }
            this.txtTitleColor.Text = item.TitleColor;
        }

        Model.Post EditEnd()
        {
            var post = new BLL.Post();
            var item = post.GetByPostID(Convert.ToInt32(this.ViewState["KeyID"]));
            this.SetValue(item);
            post.Update(item);
            return item;
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            this.Form.DefaultButton = this.btnEdit.UniqueID;
            this.ClientScript.RegisterClientScriptVar(this.GetType(), "Page", "Page", new { ContentID = this.txtContent.ClientID, SummaryID = this.txtSummary.ClientID });
            if (!this.IsPostBack)
            {
                this.ControlBind();
                var s = this.Request["PostID"];
                if (s.IsNullOrWhiteSpace())
                {
                    this.AddBegin();
                    var user = ((Model.IPrincipal)this.User).User;
                    this.txtAuthor.Text = user.RealName;
                }
                else
                    this.EditBegin(int.Parse(s));
            }
            base.Page_Load(sender, e);
        }

        protected void btnEdit_Click(object sender, EventArgs e)
        {
            if (this.IsValid)
            {
                var s = "";
                Model.Post item;
                if (this.ViewState["KeyID"] == null)
                {
                    item = this.AddEnd();
                    this.ControlReset();
                    s = "发表文章成功";
                }
                else
                {
                    item = this.EditEnd();
                    s = "编辑文章成功";
                }
                if (this.chkEnabled.Checked) s += " <a href=\"" + item.Url + "\" target=\"_blank\">查看 &gt; &gt;</a>";
                this.ShowInfo(s);
            }
        }
    }
}