﻿<%@ Page Title="文章管理 - 管理中心" Language="C#" MasterPageFile="Frame.master" AutoEventWireup="true"
    CodeBehind="PostList.aspx.cs" Inherits="ynhtm.Admin.PostList" %>

<%@ Register Assembly="ynhtm.WebControls" Namespace="ynhtm.WebControls" TagPrefix="YNHTM" %>
<asp:Content ID="contentTitle" ContentPlaceHolderID="contentTitlePlaceHolder" runat="server">
    <h1>
        文章管理</h1>
</asp:Content>
<asp:Content ID="contentRight" ContentPlaceHolderID="contentRightPlaceHolder" runat="server">
    <h2>
        搜索</h2>
    <asp:Panel runat="server" DefaultButton="btnSearch" CssClass="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtTitle">标题:</asp:Label><br />
                    <asp:TextBox ID="txtTitle" runat="server" Width="243px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="dropEnabled">状态:</asp:Label><br />
                    <asp:DropDownList ID="dropEnabled" runat="server" AppendDataBoundItems="true" Width="250px">
                        <asp:ListItem Value="">(不限)</asp:ListItem>
                        <asp:ListItem Value="true">发表的</asp:ListItem>
                        <asp:ListItem Value="false">未发表</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="dropCategoryID">栏目:</asp:Label><br />
                    <asp:DropDownList ID="dropCategoryID" runat="server" AppendDataBoundItems="true"
                        Width="250px">
                        <asp:ListItem Value="">(不限)</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" CausesValidation="false"
                        UseSubmitBehavior="false" Text="搜索" />
                </td>
            </tr>
        </table>
    </asp:Panel>
</asp:Content>
<asp:Content ID="contentLeft" ContentPlaceHolderID="contentLeftPlaceHolder" runat="server">
    <table class="list" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th>
                    标题
                </th>
                <th style="width: 60px;" class="center">
                    状态
                </th>
                <th style="width: 80px;" class="center">
                    浏览/评论
                </th>
                <th style="width: 130px;" class="center">
                    发表日期
                </th>
                <th style="width: 80px;" class="center">
                    操作
                </th>
            </tr>
        </thead>
        <tbody>
            <YNHTM:Repeater ID="rptList" runat="server" OnItemCommand="rptList_ItemCommand">
                <EmptyTemplate>
                    <tr class="list-empty">
                        <td colspan="5">
                            没有任何文章
                        </td>
                    </tr>
                </EmptyTemplate>
                <ItemTemplate>
                    <tr>
                        <td>
                            <a href="<%#this.Eval("Url")%>" target="_blank">
                                <%#this.EvalTitle%></a>
                        </td>
                        <td class="center">
                            <asp:LinkButton runat="server" CausesValidation="false" CommandName="EnabledToggle"
                                CommandArgument='<%#this.Eval("PostID")%>' ToolTip="点击切换状态" CssClass='<%#this.Eval<bool>("Enabled") ? "green" : "orange"%>'><%#this.Eval<bool>("Enabled") ? "发表的" : "未发表"%></asp:LinkButton>
                        </td>
                        <td class="center">
                            <%#this.Eval("ViewCount")%>/<%#this.Eval("CommentCount")%>
                        </td>
                        <td class="center">
                            <%#this.Eval("PostDate","{0:f}")%>
                        </td>
                        <td class="center gray">
                            <a href="<%#this.Eval("PostID", "PostEdit.aspx?PostID={0}")%>" class="b">编辑</a>
                            |
                            <asp:LinkButton runat="server" CssClass="b" CausesValidation="false" CommandName="Del"
                                CommandArgument='<%#this.Eval("PostID")%>' OnClientClick="javascript:if(!confirm('确认删除该文章吗？')) return false;">删除</asp:LinkButton>
                        </td>
                    </tr>
                </ItemTemplate>
            </YNHTM:Repeater>
        </tbody>
    </table>
    <div class="command">
        <YNHTM:Pager ID="pager" runat="server" OnPageIndexChanged="pager_PageIndexChanged">
        </YNHTM:Pager>
    </div>
</asp:Content>
