﻿using System;
using System.Web.UI.WebControls;

namespace ynhtm.Admin
{
    using Common;
    using DBUtility;

    public partial class PostList : System.Web.UI.Page
    {
        void ControlBind()
        {
            var category = new BLL.Category();
            this.dropCategoryID.DataValueField = DAL.Category.CATEGORYID;
            this.dropCategoryID.DataTextField = DAL.Category.NAME;
            this.dropCategoryID.DataSource = category.GetList();
            this.dropCategoryID.DataBind();
        }

        void PageBind()
        {
            var recordCount = 0;
            var post = new BLL.Post();
            var query = DbBase.GetQuery();
            var key = this.txtTitle.Text;
            if (!key.IsNullOrWhiteSpace()) query.And().Like(DAL.Post.TITLE, key);
            var categoryID = this.dropCategoryID.TryGet(int.Parse);
            if (categoryID != null) query.And().Equal(DAL.Post.CATEGORYID, categoryID);
            var enabled = this.dropEnabled.TryGet(bool.Parse);
            if (enabled != null) query.And().Equal(DAL.Post.ENABLED, enabled);
            this.rptList.DataSource = post.GetList(ref recordCount, this.pager.PageSize, this.pager.PageIndex, query);
            this.rptList.DataBind();
            this.pager.RecordCount = recordCount;
        }

        protected string EvalTitle
        {
            get
            {
                var key = this.txtTitle.Text;
                var title = this.Eval<string>(DAL.Post.TITLE).HtmlEncode();
                var post = new BLL.Post();
                var css = post.GetCssStyle(this.Eval<string>(DAL.Post.TITLECOLOR), this.Eval<int>(DAL.Post.TITLESTYLE));
                if (key.IsNullOrWhiteSpace())
                {
                    if (css.IsNullOrWhiteSpace()) return title;
                    return "<span style=\"" + css + "\">" + title + "</span>";
                }
                if (css.IsNullOrWhiteSpace()) return title.Highlight(key.HtmlEncode());
                return "<span style=\"" + css + "\">" + title.Highlight(key.HtmlEncode()) + "</span>";
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!this.IsPostBack)
            {
                this.ControlBind();
                this.PageBind();
            }
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            this.PageBind();
        }

        protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            var post = new BLL.Post();
            if (e.CommandName == "Del")
            {
                post.Delete(Convert.ToInt32(e.CommandArgument));
                this.PageBind();
                this.ShowInfo("删除文章成功");
            }
            else if (e.CommandName == "EnabledToggle")
            {
                post.EnabledToggle(Convert.ToInt32(e.CommandArgument));
                this.PageBind();
                this.ShowInfo("切换文章状态成功");
            }
        }

        protected void pager_PageIndexChanged(object sender, EventArgs e)
        {
            this.PageBind();
        }
    }
}