﻿<%@ Page Title="主题管理 - 管理中心" Language="C#" MasterPageFile="Page.Master" AutoEventWireup="true"
    CodeBehind="ThemeList.aspx.cs" Inherits="ynhtm.Admin.ThemeList" %>

<%@ Register Assembly="ynhtm.WebControls" Namespace="ynhtm.WebControls" TagPrefix="YNHTM" %>
<asp:Content ID="contentTitle" ContentPlaceHolderID="contentTitlePlaceHolder" runat="server">
    <h1>
        主题管理</h1>
</asp:Content>
<asp:Content ID="content" ContentPlaceHolderID="contentPlaceHolder" runat="server">
    <div class="theme clearfix">
        <YNHTM:Repeater ID="rptList" runat="server" OnItemCommand="rptList_ItemCommand">
            <ItemTemplate>
                <ul class="<%#this.Eval<bool>("Use") ? "theme-accept" : ""%>">
                    <li class="gray">/Theme/<%#this.Eval("Path")%></li>
                    <li class="<%#this.Eval<bool>("Wap") ? "theme-wap" : ""%>"><strong>
                        <%#this.Eval("Name")%></strong></li>
                    <li><span class="gray">版本</span><%#this.Eval("Version")%></li><li><span class="gray">
                        作者</span><%#this.Eval("Author")%></li>
                    <li><span class="gray">主页</span><a href="<%#this.Eval("Url")%>" target="_blank"><%#this.Eval("Url")%></a></li>
                    <li class="theme-cmd">
                        <asp:LinkButton runat="server" CausesValidation="False" CommandName='<%#this.Eval<bool>("Wap")?"UseWap":"Use"%>'
                            CommandArgument='<%#this.Eval("Path")%>'>使用</asp:LinkButton>
                        | <a href="<%#this.Eval("Path", "ThemeEdit.aspx?Path={0}")%>">编辑</a> |
                        <asp:LinkButton runat="server" CausesValidation="False" CommandName="Copy" CommandArgument='<%#this.Eval("Path")%>'>复制</asp:LinkButton>
                        |
                        <asp:LinkButton runat="server" CausesValidation="False" CommandName="Del" CommandArgument='<%#this.Eval("Path")%>'
                            OnClientClick="javascript:if(!confirm('确认删除该主题吗？')) return false;">删除</asp:LinkButton></li>
                </ul>
            </ItemTemplate>
        </YNHTM:Repeater>
    </div>
</asp:Content>
