﻿<%@ Page Title="用户管理 - 管理中心" Language="C#" MasterPageFile="Frame.master" AutoEventWireup="true"
    CodeBehind="UserList.aspx.cs" Inherits="ynhtm.Admin.UserList" %>

<%@ Register Assembly="ynhtm.WebControls" Namespace="ynhtm.WebControls" TagPrefix="YNHTM" %>
<asp:Content ID="contentTitle" ContentPlaceHolderID="contentTitlePlaceHolder" runat="server">
    <h1>
        用户管理</h1>
</asp:Content>
<asp:Content ID="contentRight" ContentPlaceHolderID="contentRightPlaceHolder" runat="server">
    <h2>
        <asp:Label ID="lblSubTitle" runat="server"></asp:Label></h2>
    <asp:Panel runat="server" DefaultButton="btnEdit" CssClass="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtUserName">用户名:</asp:Label><br />
                    <asp:TextBox ID="txtUserName" runat="server" Width="243px" MaxLength="20" ValidationGroup="Form"></asp:TextBox><br />
                    <span class="hit">英文、中文、数字或下划线</span>
                    <asp:RequiredFieldValidator ID="valrUserName" runat="server" ControlToValidate="txtUserName"
                        ErrorMessage="用户名不能为空" ValidationGroup="Form"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="valeUserName" runat="server" ErrorMessage="用户名不正确"
                        ControlToValidate="txtUserName" ValidationExpression="[a-zA-Z0-9\u4e00-\u9fa5_]+"
                        ValidationGroup="Form"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="chkIsAdmin" runat="server" Text="管理员" />
                    <asp:CheckBox ID="chkIsLock" runat="server" Text="锁定的" />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label ID="lblPassWord" runat="server" AssociatedControlID="txtPassWord" /><br />
                    <asp:TextBox ID="txtPassWord" runat="server" Width="243px" TextMode="Password" ValidationGroup="Form"></asp:TextBox><br />
                    <span class="hit">注意区分大小写</span>
                    <asp:RequiredFieldValidator ID="valrPassWord" runat="server" ControlToValidate="txtPassWord"
                        ErrorMessage="密码不能为空" ValidationGroup="Form"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtRealName">姓名:</asp:Label><br />
                    <asp:TextBox ID="txtRealName" runat="server" Width="243px" ValidationGroup="Form"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtEmail">邮件地址:</asp:Label><br />
                    <asp:TextBox ID="txtEmail" runat="server" Width="243px" ValidationGroup="Form"></asp:TextBox>
                    <asp:RegularExpressionValidator runat="server" ControlToValidate="txtEmail" ErrorMessage="邮件地址不正确"
                        ValidationGroup="Form" ValidationExpression="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtDescription">备注:</asp:Label><br />
                    <asp:TextBox ID="txtDescription" runat="server" Width="243px" ValidationGroup="Form"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Button ID="btnEdit" runat="server" OnClick="btnEdit_Click" ValidationGroup="Form"
                        UseSubmitBehavior="false" />
                    <asp:Button ID="btnCancel" runat="server" Text="取消" CausesValidation="false" UseSubmitBehavior="false"
                        OnClick="btnCancel_Click" />
                </td>
            </tr>
        </table>
    </asp:Panel>
</asp:Content>
<asp:Content ID="contentLeft" ContentPlaceHolderID="contentLeftPlaceHolder" runat="server">
    <table class="list" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th style="width: 180px;">
                    姓名(用户名)
                </th>
                <th>
                    备注
                </th>
                <th style="width: 60px;" class="center">
                    状态
                </th>
                <th style="width: 80px;" class="center">
                    文章/评论
                </th>
                <th style="width: 130px;" class="center">
                    创建日期
                </th>
                <th style="width: 80px;" class="center">
                    操作
                </th>
            </tr>
        </thead>
        <tbody>
            <YNHTM:Repeater ID="rptList" runat="server" OnItemCommand="rptList_ItemCommand">
                <EmptyTemplate>
                    <tr class="list-empty">
                        <td colspan="6">
                            没有任何用户
                        </td>
                    </tr>
                </EmptyTemplate>
                <ItemTemplate>
                    <tr>
                        <td>
                            <%#this.Eval<string>("RealName").HtmlDecode()%>
                            (<%#this.Eval<string>("UserName")%>)
                        </td>
                        <td class="gray">
                            <%#this.EvalDescription%>
                        </td>
                        <td class="center">
                            <asp:LinkButton runat="server" CausesValidation="false" CommandName="LockToggle"
                                CommandArgument='<%#this.Eval("UserID")%>' ToolTip="点击切换状态" CssClass='<%#this.Eval<bool>("IsLock") ? "orange" : "green"%>'><%#this.Eval<bool>("IsLock") ? "锁定的" : "启用的"%></asp:LinkButton>
                        </td>
                        <td class="center">
                            <%#this.Eval("PostCount")%>/<%#this.Eval("CommentCount")%>
                        </td>
                        <td class="center">
                            <%#this.Eval("RegDate", "{0:f}")%>
                        </td>
                        <td class="center gray">
                            <asp:LinkButton runat="server" CssClass="b" CausesValidation="false" CommandName="Edit"
                                CommandArgument='<%#this.Eval("UserID")%>'>编辑</asp:LinkButton>
                            |
                            <asp:LinkButton runat="server" CssClass="b" CausesValidation="false" CommandName="Del"
                                CommandArgument='<%#this.Eval("UserID")%>' OnClientClick="javascript:if(!confirm('确认删除该用户吗？')) return false;">删除</asp:LinkButton>
                        </td>
                    </tr>
                </ItemTemplate>
            </YNHTM:Repeater>
        </tbody>
    </table>
    <div class="command">
        <YNHTM:Pager ID="pager" runat="server" OnPageIndexChanged="pager_PageIndexChanged">
        </YNHTM:Pager>
    </div>
</asp:Content>
