﻿using System;
using System.Web.UI.WebControls;

namespace ynhtm.Admin
{
    using Common;

    public partial class UserList : System.Web.UI.Page
    {
        void ControlReset()
        {
            this.txtUserName.Enabled = true;
            this.valrUserName.Visible = true;
            this.valeUserName.Visible = true;
            this.valrPassWord.Visible = true;

            this.txtUserName.Text = "";
            this.txtRealName.Text = "";
            this.txtEmail.Text = "";
            this.txtDescription.Text = "";
            this.chkIsAdmin.Checked = false;
        }

        void SetValue(Model.User item)
        {
            item.UserName = this.txtUserName.Text;
            item.RealName = this.txtRealName.Text;
            item.Email = this.txtEmail.Text;
            item.Description = this.txtDescription.Text;
            item.IsAdmin = this.chkIsAdmin.Checked;
            item.IsLock = this.chkIsLock.Checked;
        }

        void AddBegin()
        {
            this.ViewState["KeyID"] = null;
            this.lblSubTitle.Text = "添加用户";
            this.lblPassWord.Text = "密码:";
            this.btnEdit.Text = "添加";
            this.btnCancel.Visible = false;
        }

        void AddEnd()
        {
            var item = new Model.User();
            this.SetValue(item);
            item.PassWord = this.txtPassWord.Text.HashMD5();
            item.RegIP = this.Request.UserHostAddress;
            var user = new BLL.User();
            user.Insert(item);
        }

        void EditBegin(int keyID)
        {
            this.ViewState["KeyID"] = keyID;
            this.lblSubTitle.Text = "编辑用户";
            this.lblPassWord.Text = "密码: <span class=\"hit\">(<span class=\"red\">留空不修改</span>)</span>";
            this.btnEdit.Text = "编辑";
            this.btnCancel.Visible = true;

            this.txtUserName.Enabled = false;
            this.valrUserName.Visible = false;
            this.valeUserName.Visible = false;
            this.valrPassWord.Visible = false;

            var user = new BLL.User();
            var item = user.GetByUserID(keyID);

            this.txtUserName.Text = item.UserName;
            this.txtRealName.Text = item.RealName;
            this.txtEmail.Text = item.Email;
            this.txtDescription.Text = item.Description;
            this.chkIsAdmin.Checked = item.IsAdmin;
            this.chkIsLock.Checked = item.IsLock;
        }

        void EditEnd()
        {
            var user = new BLL.User();
            var item = user.GetByUserID(Convert.ToInt32(this.ViewState["KeyID"]));
            this.SetValue(item);
            var s = this.txtPassWord.Text;
            if (!s.IsNullOrEmpty()) item.PassWord = s.HashMD5();
            user.Update(item);
        }

        void PageBind()
        {
            var recordCount = 0;
            var user = new BLL.User();
            this.rptList.DataSource = user.GetList(ref recordCount, this.pager.PageSize, this.pager.PageIndex);
            this.rptList.DataBind();
            this.pager.RecordCount = recordCount;
        }

        protected object EvalDescription
        {
            get { return this.Eval<string>("Description").HtmlEncode().IifNullOrWhiteSpace("(无)"); }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!this.IsPostBack)
            {
                this.PageBind();
                this.AddBegin();
            }
        }

        protected void btnEdit_Click(object sender, EventArgs e)
        {
            if (this.IsValid)
            {
                if (this.ViewState["KeyID"] == null)
                {
                    var user = new BLL.User();
                    if (user.IsExistUserName(this.txtUserName.Text))
                        this.ShowError("用户名已存在");
                    else
                    {
                        this.AddEnd();
                        this.ControlReset();
                        this.PageBind();
                        this.ShowInfo("添加用户成功");
                    }
                }
                else
                {
                    this.EditEnd();
                    this.PageBind();
                    this.ShowInfo("编辑用户成功");
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            this.AddBegin();
            this.ControlReset();
            this.PageBind();
        }

        protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            var user = new BLL.User();
#if DEMO
            var userItem = user.GetByUserID(Convert.ToInt32(e.CommandArgument));
            if (userItem.UserName.Equals("admin", StringComparison.OrdinalIgnoreCase))
            {
                this.ShowAlert("演示版无法操作此用户");
                return;
            }
#endif
            if (e.CommandName == "Edit")
            {
                this.EditBegin(Convert.ToInt32(e.CommandArgument));
            }
            else if (e.CommandName == "Del")
            {
                user.Delete(Convert.ToInt32(e.CommandArgument));
                this.PageBind();
                this.ShowInfo("删除用户成功");
            }
            else if (e.CommandName == "LockToggle")
            {
                user.LockToggle(Convert.ToInt32(e.CommandArgument));
                this.PageBind();
                this.ShowInfo("切换用户状态成功");
            }
        }

        protected void pager_PageIndexChanged(object sender, EventArgs e)
        {
            this.PageBind();
        }
    }
}