﻿/*
* ynhtm.com Slide V1.0
*
* (C) 2011 XiaoDao
*/

$.Slide = {
    init: function (options) {
        options = $.extend({}, { sleep: 5000, duration: 500, items: {} }, options);
        $("<img/>").one("load", function () {
            var len = options.items.length;
            var html = "<ul>";
            for (var i = 1; i <= len; i++)
                html += "<li>" + i + "</li>";
            html += "</ul><ol>";
            $(options.items).each(function () {
                html += "<li>";
                if (this.href != undefined)
                    html += '<a href="' + this.href + '" target="' + (this.target || '') + '"><img src="' + this.img + '" alt="" /></a>';
                else
                    html += '<img src="' + this.img + '" alt="" />';
                html += "</li>";
            });
            html += "</ol>";
            var animate = {
                time: 0,
                paly: function () {
                    this.time = setInterval(function () {
                        var context = $(options.context);
                        var index = context.data("index");
                        index++;
                        if (index > len - 1) index = 0;
                        $.Slide.move(context, index, options.duration);
                    }, options.sleep);
                },
                stop: function () {
                    clearInterval(this.time);
                }
            };
            $(options.context).append(html).hover(function () { animate.stop(); }, function () { animate.paly(); }).find("ul li").css("opacity", .7).each(function (index) {
                $(this).mouseover(function () { $.Slide.move(options.context, index, options.duration); });
            });
            $.Slide.move(options.context, 0);
            animate.paly();
        }).attr("src", "/Images/Load.gif");
    },
    move: function (context, index, duration) {
        duration = duration || 0;
        $("ul li", context).stop(true).css("opacity", .7).removeClass("slide-active").eq(index).css("opacity", .2).addClass("slide-active").animate({ opacity: 1 }, duration);
        var list = $(context).data("index", index).find("ol");
        var top = 0;
        $("li:lt(" + index + ")", list).each(function () { top += $(this).outerHeight(); });
        list.stop(true).animate({ marginTop: -top }, duration);
    }
};