﻿CREATE TABLE [ynhtm_Category] (
    [CategoryID] integer PRIMARY KEY AUTOINCREMENT NOT NULL,
    [Url] nvarchar(255) NOT NULL,
    [Name] nvarchar(50) NOT NULL,
    [RssEnabled] bit NOT NULL,
    [MapEnabled] bit NOT NULL,
    [Rewrite] nvarchar(255),
    [HomeTheme] nvarchar(50),
    [ListTheme] nvarchar(50),
    [PostTheme] nvarchar(50),
    [PostCount] integer NOT NULL,
    [CommentCount] integer NOT NULL,
    [DisplayOrder] integer NOT NULL,
    [CreateDate] datetime NOT NULL DEFAULT (datetime(CURRENT_TIMESTAMP,'localtime'))
);

CREATE INDEX [IX_ynhtm_Category] ON [ynhtm_Category] ([Rewrite], [RssEnabled], [MapEnabled], [DisplayOrder]);


CREATE TABLE [ynhtm_Comment] (
    [CommentID] integer PRIMARY KEY AUTOINCREMENT NOT NULL,
    [PostID] integer NOT NULL,
    [UserID] integer,
    [IsAudit] bit NOT NULL,
    [IsWap] bit NOT NULL,
    [Name] nvarchar(20),
    [Email] nvarchar(255),
    [Content] ntext NOT NULL,
    [IPAddr] nvarchar(30) NOT NULL,
    [PostDate] datetime NOT NULL DEFAULT (datetime(CURRENT_TIMESTAMP,'localtime'))
);

CREATE INDEX [IX_ynhtm_Comment] ON [ynhtm_Comment] ([PostID], [UserID], [IsAudit], [IsWap], [Name], [Email], [IPAddr]);


CREATE TABLE [ynhtm_Job] (
    [JobID] integer PRIMARY KEY AUTOINCREMENT NOT NULL,
    [Type] integer,
    [Url] nvarchar(255) NOT NULL,
    [Rewrite] nvarchar(255),
    [Theme] nvarchar(50),
    [Enabled] bit NOT NULL,
    [ViewCount] integer NOT NULL,
    [TryCount] integer NOT NULL,
    [Name] nvarchar(50) NOT NULL,
    [Area] nvarchar(50),
    [Count] integer,
    [Salary] money,
    [Sex] integer,
    [Age] integer,
    [Degree] integer,
    [Experience] integer,
    [Content] ntext,
    [EndDate] datetime,
    [CreateDate] datetime NOT NULL DEFAULT (datetime(CURRENT_TIMESTAMP,'localtime'))
);

CREATE INDEX [IX_ynhtm_Job] ON [ynhtm_Job] ([Type], [Rewrite], [Enabled], [Name], [Area], [Count], [Salary], [Sex], [Age], [Degree], [Experience]);


CREATE TABLE [ynhtm_JobTry] (
    [TryID] integer PRIMARY KEY AUTOINCREMENT NOT NULL,
    [JobID] integer NOT NULL,
    [RealName] nvarchar(20) NOT NULL,
    [Sex] integer,
    [Wedding] integer,
    [Bday] datetime,
    [School] nvarchar(255),
    [Contact] nvarchar(255) NOT NULL,
    [Addr] nvarchar(255),
    [EducationNote] ntext,
    [WorkNote] ntext,
    [Remark] ntext,
    [FileUrl] nvarchar(255),
    [IPAddr] nvarchar(30) NOT NULL,
    [PostDate] datetime NOT NULL DEFAULT (datetime(CURRENT_TIMESTAMP,'localtime'))
);

CREATE INDEX [IX_ynhtm_JobTry] ON [ynhtm_JobTry] ([RealName], [Contact]);


CREATE TABLE [ynhtm_Link] (
    [LinkID] integer PRIMARY KEY AUTOINCREMENT NOT NULL,
    [Name] nvarchar(50) NOT NULL,
    [Url] nvarchar(255) NOT NULL,
    [Logo] nvarchar(255),
    [DisplayOrder] integer NOT NULL,
    [CreateDate] datetime NOT NULL DEFAULT (datetime(CURRENT_TIMESTAMP,'localtime'))
);

CREATE INDEX [IX_ynhtm_Link] ON [ynhtm_Link] ([DisplayOrder]);


CREATE TABLE [ynhtm_Post] (
    [PostID] integer PRIMARY KEY AUTOINCREMENT NOT NULL,
    [CategoryID] integer,
    [UserID] integer NOT NULL,
    [Url] nvarchar(255) NOT NULL,
    [Rewrite] nvarchar(255),
    [Theme] nvarchar(50),
    [Face] nvarchar(255),
    [Title] nvarchar(80) NOT NULL,
    [TitleStyle] integer NOT NULL,
    [TitleColor] nvarchar(50),
    [Summary] ntext,
    [Content] ntext NOT NULL,
    [Source] nvarchar(255),
    [Author] nvarchar(50),
    [Tags] nvarchar(255),
    [Enabled] bit NOT NULL,
    [IsTop] bit NOT NULL,
    [IsHide] bit NOT NULL,
    [IsPic] bit NOT NULL,
    [IsFace] bit NOT NULL,
    [ViewCount] integer NOT NULL,
    [CommentEnabled] bit NOT NULL,
    [CommentCount] integer NOT NULL,
    [LastDate] datetime NOT NULL DEFAULT (datetime(CURRENT_TIMESTAMP,'localtime')),
    [PostDate] datetime NOT NULL DEFAULT (datetime(CURRENT_TIMESTAMP,'localtime'))
);

CREATE INDEX [IX_ynhtm_Post] ON [ynhtm_Post] ([CategoryID], [UserID], [Title], [Tags], [Enabled], [IsTop], [IsHide], [IsPic], [IsFace], [ViewCount], [CommentCount], [LastDate], [PostDate]);


CREATE TABLE [ynhtm_Setting] (
    [SiteName] nvarchar(80) NOT NULL,
    [SiteUrl] nvarchar(255) NOT NULL,
    [SiteEnabled] bit NOT NULL,
    [MetaKeyWord] nvarchar(255),
    [MetaDescr] nvarchar(255),
    [Theme] nvarchar(50),
    [WapTheme] nvarchar(50),
    [WapEnabled] bit NOT NULL,
    [WapDomain] nvarchar(255),
    [AuthcodeEnabled] bit NOT NULL,
    [MapEnabled] bit NOT NULL,
    [MapRowCount] integer NOT NULL,
    [TotalType] integer NOT NULL,
    [CacheEnabled] bit NOT NULL,
    [CacheExpire] integer NOT NULL,
    [CacheType] integer NOT NULL,
    [OAuthQzoneEnabled] bit NOT NULL,
    [OAuthQzoneAppID] nvarchar(255),
    [OAuthQzoneAppKey] nvarchar(255),
    [UserCount] integer NOT NULL,
    [RssEnabled] bit NOT NULL,
    [RssRowCount] integer NOT NULL,
    [RssShowType] integer NOT NULL,
    [PageSize] integer NOT NULL,
    [PostCount] integer NOT NULL,
    [CommentEnabled] bit NOT NULL,
    [CommentSort] integer NOT NULL,
    [CommentPageSize] integer NOT NULL,
    [CommentAudit] integer NOT NULL,
    [CommentDirty] ntext,
    [CommentCount] integer NOT NULL,
    [PicMaskEnabled] bit NOT NULL,
    [PicMaskFile] nvarchar(50),
    [PicMaskPos] integer NOT NULL,
    [PicQuality] integer NOT NULL,
    [UpfileCount] integer NOT NULL,
    [UpfileSize] bigint NOT NULL,
    [JobCount] integer NOT NULL,
    [JobTryCount] integer NOT NULL,
    [CodeHead] ntext,
    [CodeFoot] ntext,
    [CreateDate] datetime NOT NULL DEFAULT (datetime(CURRENT_TIMESTAMP,'localtime'))
);


CREATE TABLE [ynhtm_User] (
    [UserID] integer PRIMARY KEY AUTOINCREMENT NOT NULL,
    [UserName] nvarchar(20) NOT NULL,
    [PassWord] char(32),
    [OAuthQzoneID] nvarchar(50),
    [RealName] nvarchar(20),
    [Email] nvarchar(255),
    [Description] ntext,
    [IsLock] bit NOT NULL,
    [IsAdmin] bit NOT NULL,
    [PostCount] integer NOT NULL,
    [CommentCount] integer NOT NULL,
    [LoginCount] integer NOT NULL,
    [LastIP] nvarchar(30),
    [LastDate] datetime,
    [RegIP] nvarchar(30) NOT NULL,
    [RegDate] datetime NOT NULL DEFAULT (datetime(CURRENT_TIMESTAMP,'localtime'))
);

CREATE INDEX [IX_ynhtm_User] ON [ynhtm_User] ([UserName], [OAuthQzoneID], [PassWord], [IsLock], [Email]);