﻿using System;

namespace ynhtm.User
{
    using Common;

    public partial class OAuthQzoneGuide : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            var setting = new BLL.Setting();
            var settingItem = setting.Get();
            var s = settingItem.CreateDate.Year.ToString();
            if (DateTime.Now.Year > settingItem.CreateDate.Year) s += "-" + DateTime.Now.Year;
            this.lblCopy.Text = s + " " + settingItem.SiteName.IifNullOrWhiteSpace(this.Request.Url.Host).HtmlEncode();
            if (!this.IsPostBack)
            {
                this.txtUserName.Text = (string)this.Session["UserName"];
            }
            this.Form.DefaultButton = this.btnLogin.UniqueID;
        }

        protected void btnLogin_Click(object sender, EventArgs e)
        {
            if (this.IsValid)
            {
                var openID = (string)this.Session["OpenID"];
                var user = new BLL.User();
                if (user.IsExistUserName(this.txtUserName.Text))
                    this.ShowError("用户名已存在");
                else if (openID.IsNullOrWhiteSpace())
                    this.ShowError("OpenID 不正确");
                else
                {
                    var item = new Model.User();
                    item.UserName = this.txtUserName.Text;
                    item.OAuthQzoneID = openID;
                    item.Email = this.txtEmail.Text;
                    item.RegIP = this.Request.UserHostAddress;
                    user.Insert(item);
                    user.Login(item, this.Request, this.Response);
                    this.Response.ClearContent();
                    this.Response.Write(API.OAuthQzone.SCRIPT);
                    this.Response.End();
                }
            }
        }
    }
}