﻿<%@ Page Title="职位管理 - 管理中心" Language="C#" MasterPageFile="Frame.master" AutoEventWireup="true"
    CodeBehind="JobList.aspx.cs" Inherits="ynhtm.Admin.JobList" %>

<%@ Register Assembly="ynhtm.WebControls" Namespace="ynhtm.WebControls" TagPrefix="YNHTM" %>
<asp:Content ID="contentTitle" ContentPlaceHolderID="contentTitlePlaceHolder" runat="server">
    <h1>
        职位管理</h1>
</asp:Content>
<asp:Content ID="contentRight" ContentPlaceHolderID="contentRightPlaceHolder" runat="server">
    <h2>
        搜索</h2>
    <asp:Panel runat="server" DefaultButton="btnSearch" CssClass="form">
        <table cellpadding="0" cellspacing="10">
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtName">职位:</asp:Label><br />
                    <asp:TextBox ID="txtName" runat="server" Width="243px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label runat="server" AssociatedControlID="txtArea">工作地区:</asp:Label><br />
                    <asp:TextBox ID="txtArea" runat="server" Width="243px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" CausesValidation="false"
                        UseSubmitBehavior="false" Text="搜索" />
                </td>
            </tr>
        </table>
    </asp:Panel>
</asp:Content>
<asp:Content ID="contentLeft" ContentPlaceHolderID="contentLeftPlaceHolder" runat="server">
    <table class="list" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th>
                    职位
                </th>
                <th style="width: 100px;" class="center">
                    工作地区
                </th>
                <th style="width: 60px;" class="center">
                    状态
                </th>
                <th style="width: 80px;" class="center">
                    浏览/应聘
                </th>
                <th style="width: 130px;" class="center">
                    发布日期
                </th>
                <th style="width: 80px;" class="center">
                    操作
                </th>
            </tr>
        </thead>
        <tbody>
            <YNHTM:Repeater ID="rptList" runat="server" OnItemCommand="rptList_ItemCommand">
                <EmptyTemplate>
                    <tr class="list-empty">
                        <td colspan="6">
                            没有任何职位
                        </td>
                    </tr>
                </EmptyTemplate>
                <ItemTemplate>
                    <tr>
                        <td>
                            <a href="<%#this.Eval("Url")%>" target="_blank">
                                <%#this.EvalName%></a>
                        </td>
                        <td class="center">
                            <%#this.EvalArea.IifNullOrWhiteSpace("-")%>
                        </td>
                        <td class="center">
                            <asp:LinkButton runat="server" CausesValidation="false" CommandName="EnabledToggle"
                                CommandArgument='<%#this.Eval("JobID")%>' ToolTip="点击切换状态" CssClass='<%#this.Eval<bool>("Enabled") ? "green" : "orange"%>'><%#this.Eval<bool>("Enabled") ? "发布的" : "未发布"%></asp:LinkButton>
                        </td>
                        <td class="center">
                            <%#this.Eval("ViewCount")%>/<%#this.Eval("TryCount")%>
                        </td>
                        <td class="center">
                            <%#this.Eval("CreateDate", "{0:f}")%>
                        </td>
                        <td class="center gray">
                            <a href="<%#this.Eval("JobID", "JobEdit.aspx?JobID={0}")%>" class="b">编辑</a> |
                            <asp:LinkButton runat="server" CssClass="b" CausesValidation="false" CommandName="Del"
                                CommandArgument='<%#this.Eval("JobID")%>' OnClientClick="javascript:if(!confirm('确认删除该职位吗？')) return false;">删除</asp:LinkButton>
                        </td>
                    </tr>
                </ItemTemplate>
            </YNHTM:Repeater>
        </tbody>
    </table>
    <div class="command">
        <YNHTM:Pager ID="pager" runat="server" OnPageIndexChanged="pager_PageIndexChanged">
        </YNHTM:Pager>
    </div>
</asp:Content>
