﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Text.RegularExpressions;
using System.Data;

/// <summary>
///function 的摘要说明
/// </summary>
public class function : guandongren.MakeHtml
{
    public string model = "";
    public string isAuto = "";
    
    static guandongren.MakehtmlSQL SQL = new guandongren.MakehtmlSQL();
    public function()
    {
        DataTable dt = SQL.GetList("select * from c_config").Tables[0];
        try
        {
            model = dt.Rows[0]["c_model"].ToString();
            isAuto = dt.Rows[0]["c_isAuto"].ToString();
        }
        catch 
        { }
    }

    public override string functionhtml(string html, string str)
    {
        switch (html)
        {
            case "CutString":
                return CutString(str);
            case "DateFormat":
                string[] arr = str.Split(',');
                return DateFormat(arr[0], arr[1]);
            case "Get_htmlclass":
                return Get_htmlclass(str);
            case "HitNews":
                HitNews(str);
                break;
            case "HitProduct":
                HitProduct(str);
                break;
            case "Getlink":
                string[] link = str.Split(',');
                if (link.Length == 1)
                {
                    return Getlink(link[0], "");
                }
                return Getlink(link[0], link[1]);
        }
        return "";
    }

    public string Getlink(string item,string param)
    {
        if ("0" == model)
        {
            switch (item)
            {
                case "index":
                    return "/?index";
                case "about":
                    return "/?about";
                case "contact":
                    return "/?contact";
                case "pxxm":
                    return "/?pxxm";
                case "newsclass":
                    return "/?newsclass-" + param + "-1";
                case "news":
                    return "/?news-" + param;
                case "proclass":
                    return "/?proclass-" + param + "-1";
                case "product":
                    return "/?product-" + param;
            }
        }
        else
        {
            switch (item)
            {
                case "index":
                    return "/index.html";
                case "about":
                    return "/aboutus_prf.html";
                case "contact":
                    return "/contact_prf.html";
                case "pxxm":
                    return "/pxxm_prf.html";
                case "newsclass":
                    return "/NewsList/NewsClass_" + param + "_1.html";
                case "news":
                    return "/News/NewsInfo_" + param + ".html";
                case "proclass":
                    return "/ProList/ProductClass_" + param + "_1.html";
                case "product":
                    return "/Product/Product_" + param + ".html";
            }
        }
        return "";
    }

    #region 常用函数
    /// <summary>
    /// 字符串截取
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static string CutString(string str)
    {
        str = NoHTML(str);
        string title = str.Substring(0, str.LastIndexOf(","));
        string leng = str.Substring(str.LastIndexOf(",") + 1, str.Length - (str.LastIndexOf(",") + 1));
        if (title.Length > Convert.ToInt32(leng))
        {
            try
            {
                title = str.Substring(0, Convert.ToInt32(leng));
            }
            catch
            { }
            return title + "...";
        }
        return title;
    }

    /// <summary>
    /// 格式化日期
    /// </summary>
    /// <param name="date"></param>
    /// <param name="format"></param>
    /// <returns></returns>
    public static string DateFormat(string date, string format)
    {
        return Convert.ToDateTime(date).ToString(format);
    }

    //删除HTML脚本
    public static string NoHTML(string Htmlstring)
    {
        //删除脚本
        Htmlstring = Regex.Replace(Htmlstring, @"<script[^>]*?>.*?</script>", "", RegexOptions.IgnoreCase);
        //删除HTML
        Htmlstring = Regex.Replace(Htmlstring, @"<(.[^>]*)>", "", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"([\r\n])[\s]+", "", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"-->", "", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"<!--.*", "", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"&(quot|#34);", "\"", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"&(amp|#38);", "&", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"&(lt|#60);", "<", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"&(gt|#62);", ">", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"&(nbsp|#160);", " ", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"&(iexcl|#161);", "\xa1", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"&(cent|#162);", "\xa2", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"&(pound|#163);", "\xa3", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"&(copy|#169);", "\xa9", RegexOptions.IgnoreCase);
        Htmlstring = Regex.Replace(Htmlstring, @"&#(\d+);", "", RegexOptions.IgnoreCase);
        Htmlstring.Replace("<", "");
        Htmlstring.Replace(">", "");
        Htmlstring.Replace("\r\n", "");
        Htmlstring = HttpContext.Current.Server.HtmlEncode(Htmlstring).Trim().Replace("'", "`");
        return Htmlstring;
    }

    /// <summary>
    /// 检查是否为空，不为空返回true
    /// </summary>
    /// <param name="param"></param>
    /// <returns></returns>
    public static bool CheckNull(params string[] param)
    {
        foreach (object item in param)
        {
            if (object.Equals(item, null))
            {
                return false;
            }
            if (string.IsNullOrEmpty(item.ToString()))
            {
                return false;
            }
        }
        return true;
    }

    /// <summary>
    /// 判断是否数字，是数字返回true
    /// </summary>
    /// <param name="param"></param>
    /// <returns></returns>
    public static bool isNumber(params string[] param)
    {
        foreach (string item in param)
        {
            try
            {
                Convert.ToInt32(item);
            }
            catch (Exception)
            {
                return false;
            }
        }
        return true;
    }

    /// <summary>
    /// 弹出提示信息
    /// </summary>
    /// <param name="num">1:没有返回值2:有返回地址3:直接关闭当期窗口4:返回上一级5:直接跳转</param>
    /// <param name="str">弹出的内容</param>
    /// <param name="url">跳转的路径</param>
    /// <returns></returns>
    public static string alert_text(int num, string str, string url)
    {
        switch (num)
        {
            case 1://普通的弹出，没有返回值
                return "<script>alert('" + str + "');</script>";
            case 2://普通的弹出窗口，有返回地址
                return "<script>alert('" + str + "');location='" + url + "';</script>";
            case 3://普通的弹出窗口，直接关闭当期窗口
                return "<script>alert('" + str + "');location='javascript:window.close();';</script>";
            case 4://普通的弹出窗口，返回上一级
                return "<script>alert('" + str + "');location='javascript:window.history.go(-1);';</script>";
            case 5:
                return "<script>location='" + url + "';</script>";
        }
        return "";
    }

    /// <summary>
    /// 设置上传文件的名称
    /// </summary>
    /// <param name="filename"></param>
    /// <returns></returns>
    public static string SetFileName(string filename)
    {
        string sxiff = filename.Substring(filename.LastIndexOf(".") + 1, filename.Length - (filename.LastIndexOf(".") + 1)).ToLower();
        string newName = DateTime.Now.ToString("yyyyMMddhhmmssyyy") + "." + sxiff;
        return newName;
    }

    public static string HitNews(string id)
    {
        SQL.ExecuteSql("update c_news set n_hit=(n_hit+1) where n_id=" + id);
        DataTable dt = SQL.GetList("select n_hit from c_news where n_id=" + id).Tables[0];
        if (dt.Rows.Count > 0)
        {
            return dt.Rows[0][0].ToString();
        }
        return "1";
    }

    public static void HitProduct(string id)
    {
        SQL.ExecuteSql("update c_product set p_hit=(p_hit+1) where p_id=" + id);
    }
    #endregion

    #region 检查Session
    /// <summary>
    /// 检查Session
    /// </summary>
    public static void CheckSession()
    {
        if (HttpContext.Current.Session["adminName"] == null)
        {
            HttpContext.Current.Response.Redirect("../login.aspx");
        }
    }
    #endregion

    /// <summary>
    /// 通用删除方法
    /// checkboxName：页面复选框name
    /// table：表名
    /// primary：主键
    /// url：跳转路径
    /// </summary>
    /// <param name="table">表名</param>
    /// <param name="primary">主键</param>
    /// <param name="url">跳转路径</param>
    public static void Delete(string checkboxName, string table, string primary, string url)
    {
        try
        {
            string str = checkboxName;
            if (string.IsNullOrEmpty(str))
            {
                HttpContext.Current.Response.Write(alert_text(4, "没有选择任何项！", ""));
                return;
            }
            string[] id = str.Split(',');
            for (int i = 0; i < id.Length; i++)
            {
                SQL.ExecuteSql("delete from " + table + " where " + primary + "=" + id[i]);
            }
            HttpContext.Current.Response.Write(alert_text(2, "删除成功！", "" + url + ""));
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(alert_text(2, "错误，" + ex + "", "" + url + ""));
        }
    }
   
    /// <summary>
    /// 删除带文件的信息
    /// </summary>
    /// <param name="checkboxName">ID列表</param>
    /// <param name="table">表名</param>
    /// <param name="primary">主键</param>
    /// <param name="url">跳转路径</param>
    /// <param name="fileColunm"></param>
    public static void DataDel_file(string checkboxName, string table, string primary, string url,string fileColunm)
    {
        try
        {
            string str = checkboxName;
            if (string.IsNullOrEmpty(str))
            {
                HttpContext.Current.Response.Write(alert_text(4, "没有选择任何项！", ""));
                return;
            }
            string[] id = str.Split(',');
            for (int i = 0; i < id.Length; i++)
            {
                DataTable dt = SQL.GetList("select " + fileColunm + " from " + table + " where " + primary + "=" + id[i]).Tables[0];
                if (dt.Rows.Count > 0)
                {
                    try
                    {
                        System.IO.File.Delete(HttpContext.Current.Server.MapPath(dt.Rows[0][0].ToString()));
                        if ("p_img"==fileColunm)
                        {
                            System.IO.File.Delete(HttpContext.Current.Server.MapPath((dt.Rows[0][0].ToString()).Replace("UploadFiles/", "UploadFiles/small/")));
                        }
                    }
                    catch 
                    { }
                }
                SQL.ExecuteSql("delete from " + table + " where " + primary + "=" + id[i]);
            }
            HttpContext.Current.Response.Write(alert_text(2, "删除成功！", "" + url + ""));
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(alert_text(2, "错误，" + ex + "", "" + url + ""));
        }
    }

    private string Get_htmlclass(string str)
    {
        try
        {
            string t1 = str.Split('|')[0];
            string t2 = str.Split('|')[1];
            string[] mid = t1.Split(',');

            for (int i = 0; i < mid.Length; i++)
            {
                if (mid[i].IndexOf(t2) >= 0)
                {
                    return " checked";
                }
            }
        }
        catch { }
        return "";
    }
}