﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.OleDb;
using System.Data;

public partial class cms_manager_Admin_add : System.Web.UI.Page
{
    Config config = new Config();
    function make_htm = new function();
    guandongren.MakehtmlSQL SQL = new guandongren.MakehtmlSQL();
    protected void Page_Load(object sender, EventArgs e)
    {
        function.CheckSession();
        string T = Request["T"];
        switch (T)
        {
            case "config":
                ConfigUpdate();
                break;
            case "logo":
                ConfigLogoUpd();
                break;
            case "banner":
                ConfigBannerAdd();
                break;
            case "regex":
                RegexAdd();
                break;
            case "link":
                LinkAdd();
                break;
            case "menu":
                MenuAdd();
                break;
            case "newsClass":
                NewsClassAdd();
                break;
            case "news":
                NewsAdd();
                break;
            case "productClass":
                ProductClassAdd();
                break;
            case "product":
                ProductAdd();
                break;
            case "base":
                BaseInfoAdd();
                break;
            case "makehtml":
                Makehtml();
                break;
        }
    }

    /// <summary>
    /// 基本设置修改
    /// </summary>
    /// <param name="id"></param>
    private void ConfigUpdate()
    {
        try
        {
            string webName = Request.Form["txtWebName"];
            string template = Request.Form["txtTemplate"];
            string isOpen = Request.Form["isOpen"];//0-开启、1-关闭
            string closeUrl = Request.Form["txtCloseUrl"];
            string adminFolder = Request.Form["txtAdminFolder"];//后台管理地址
            string webUrl = Request.Form["txtWebUrl"];
            string keywords = Request.Form["txtKeywords"];
            string description = Request.Form["txtDescription"];
            string company = Request.Form["txtCompany"];
            string tel = Request.Form["txtTel"];
            string contact = Request.Form["txtContact"];
            string qq = Request.Form["txtQQ"];
            string address = Request.Form["txtAddress"];
            string foot = Request.Form["txtFoot"];
            string c_model = Request.Form["c_model"];
            string c_isAuto = Request.Form["c_isAuto"];
            if (c_isAuto == "" || c_isAuto == null)
            {
                c_isAuto = "0";
            }
            string sql = "update C_config set ";
            if (webName != "")
                sql += "c_web_name=@webName,";
            if (template != "")
                sql += "c_template=@template,";
            if (isOpen != "")
                sql += "c_web_open=@webOpen,";
            if (closeUrl != "")
                sql += "c_web_closeurl=@closeUrl,";
            if (adminFolder != "")
                sql += "c_adminfolder=@adminFolder,";
            if (webUrl != "")
                sql += "c_web_url=@webUrl,";
            if (keywords != "")
                sql += "c_keywords=@keywords,";
            if (description != "")
                sql += "c_description=@description,";
            if (company != "")
                sql += "c_company=@company,";
            if (tel != "")
                sql += "c_tel=@tel,";
            if (contact != "")
                sql += "c_contact=@contact,";
            if (qq != "")
                sql += "c_qq=@qq,";
            if (address != "")
                sql += "c_address=@address,";
            if (foot != "")
                sql += "c_foot=@foot,";
            if (c_model != "")
                sql += "c_model=@c_model,";
            if (c_isAuto != "")
                sql += "c_isAuto=@auto,";
            sql = sql.Substring(0, sql.LastIndexOf(","));
            OleDbParameter[] param ={new OleDbParameter("@webName",webName),
                                new OleDbParameter("@template",template),
                                new OleDbParameter("@webOpen",isOpen),
                                new OleDbParameter("@closeUrl",closeUrl),
                                new OleDbParameter("@adminFolder",adminFolder),
                                new OleDbParameter("@webUrl",webUrl),
                                new OleDbParameter("@keywords",keywords),
                                new OleDbParameter("@description",description),
                                new OleDbParameter("@company",company),
                                new OleDbParameter("@tel",tel),
                                new OleDbParameter("@contact",contact),
                                new OleDbParameter("@qq",qq),
                                new OleDbParameter("@address",address),
                                new OleDbParameter("@foot",foot),
                                new OleDbParameter("@c_model",c_model),
                                new OleDbParameter("@auto",c_isAuto)};
            int j = SQL.ExecuteSql(sql, param);
            if (j > 0)
                Response.Write(function.alert_text(2, "修改成功！", "G_config/C_config.aspx"));
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// Logo上传
    /// </summary>
    private void ConfigLogoUpd()
    {
        HttpPostedFile file = Request.Files[0];
        string filename = "";
        if (file.ContentLength > 0)
        {
            filename = make_htm.Upload("/UploadFiles/", 200, file, "jpg,gif,bmp,png");

            if (filename.Contains("上传失败"))
            {
                Response.Write(function.alert_text(4, filename, ""));
                return;
            }

            int j = SQL.ExecuteSql("update c_config set c_logo='" + filename + "'");
            if (j > 0)
            {
                Response.Write(function.alert_text(2, "上传成功！", "G_config/C_logo.aspx"));
                return;
            }
            Response.Write(function.alert_text(4, "请选择图片！", ""));
        }
    }

    private void ConfigBannerAdd()
    {
        string bannerLink = Request.Form["txtBannerLink"].Trim();
        if (bannerLink == "" || bannerLink == null)
        {
            bannerLink = "#";
        }
        string bannerAlt = Request.Form["txtBannerAlt"].Trim();
        string bannerTitle = Request.Form["txtBannertitle"].Trim();
        string filename = "";
        HttpPostedFile file = Request.Files[0];
        if (file.ContentLength > 0)
        {
            filename = make_htm.Upload("/UploadFiles/", 300, file, "jpg,gif,bmp,png");

            if (filename.Contains("上传失败"))
            {
                Response.Write(function.alert_text(4, filename, ""));
                return;
            }

            string sql = "insert into c_banner(b_link,b_url,b_alt,b_title) values(@link,@url,@alt,@title)";
            OleDbParameter[] param ={new OleDbParameter("@link",bannerLink),
                                        new OleDbParameter("@url",filename),
                                        new OleDbParameter("@alt",bannerAlt),
                                        new OleDbParameter("@title",bannerTitle)};
            int j = SQL.Add(sql, param);
            if (j>0)
            {
                Response.Write(function.alert_text(2, "添加成功！", "G_config/C_banner.aspx"));
                return;
            }
        }
        Response.Write(function.alert_text(4, "请选择图片！", ""));
    }

    /// <summary>
    /// 添加页面设置
    /// </summary>
    private void RegexAdd()
    {
        try
        {
            string url = Request.Form["txtUrl"].Trim();
            string rule = Request.Form["txtRule"].Trim();
            if (function.CheckNull(url, rule))
            {
                string sql = "insert into C_regex(r_url,r_rule) values(@url,@rule)";
                OleDbParameter[] param ={new OleDbParameter("@url",url),
                               new OleDbParameter("@rule",rule)};

                int j = SQL.Add(sql, param);
                if (j > 0)
                {
                    Response.Write(function.alert_text(2, "添加成功！", "G_Config/C_regex.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 添加友情链接
    /// </summary>
    private void LinkAdd()
    {
        try
        {
            string linkType = Request.Form["drpType"];
            string linkName = Request.Form["txtName"].Trim();
            string linkUrl = Request.Form["txtUrl"].Trim();
            string linkOrder = Request.Form["txtOrder"].Trim();
            string uploadPath = "";
            string filename = "";
            if (linkOrder == "" || linkOrder == null)
            {
                linkOrder = "0";
            }
            if (function.CheckNull(linkName, linkUrl))
            {
                if (!function.isNumber(linkOrder))
                {
                    Response.Write(function.alert_text(4, "排序必须是数字！", ""));
                    return;
                }
                if (linkType == "1")
                {
                    HttpPostedFile file = Request.Files[0];
                    if (file.ContentLength <= 0)
                    {
                        Response.Write(function.alert_text(4, "请选择图片！", ""));
                        return;
                    }
                    uploadPath = HttpContext.Current.Server.MapPath("/UploadFiles/");
                    if (!System.IO.Directory.Exists(uploadPath))
                    {
                        System.IO.Directory.CreateDirectory(uploadPath);
                    }

                    if (filename.Contains("上传失败"))
                    {
                        Response.Write(function.alert_text(4, filename, ""));
                        return;
                    }

                    string c_come = Request.UrlReferrer.ToString();
                    string c_type = file.ContentType;
                    string c_size = (Math.Round((Convert.ToDouble(file.ContentLength) / 1024), 2)).ToString();
                    string c_date = DateTime.Now.ToString();
                    SQL.ExecuteSql("insert into c_files(c_url,c_come,c_type,c_size,c_date) values('" + filename + "','" + c_come + "','" + c_type + "','" + c_size + "','" + c_date + "')");
                }
                string sql = "insert into c_link(l_name,l_url,l_img,l_type,l_order) values(@name,@url,@img,@type,@order)";
                OleDbParameter[] param ={ new OleDbParameter("@name",linkName),
                               new OleDbParameter("@url",linkUrl),
                               new OleDbParameter("@img",filename),
                               new OleDbParameter("@type",linkType),
                               new OleDbParameter("@order",linkOrder)};
                int j = SQL.Add(sql, param);
                if (j > 0)
                {
                    if (config.Ishtml)//是否需要生成静态页
                    {
                        Make_html.MakeHtml("c_link", "");
                    }
                    Response.Write(function.alert_text(2, "添加成功！", "G_Config/C_link.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 添加菜单
    /// </summary>
    private void MenuAdd()
    {
        try
        {
            string menuClassid = Request.Form["drpMenuClassid"];
            string menuClasslev = Request.Form["txtMenuClasslev"];
            string menuName = Request.Form["txtMenuName"].Trim();
            string menuUrl = Request.Form["txtMenuUrl"].Trim();
            string menuDisplay = Request.Form["rdoMenuDisplay"];
            if (menuUrl == "")
            {
                menuUrl = "#";
            }
            if (function.CheckNull(menuName))
            {
                string sql = "insert into c_menu(m_name,m_url,m_classid,m_classlev,m_display) values(@name,@url,@classid,@classlev,@display)";
                OleDbParameter[] param ={new OleDbParameter("@name",menuName),
                                   new OleDbParameter("@url",menuUrl),
                                   new OleDbParameter("@classid",menuClassid),
                                   new OleDbParameter("@classlev",menuClasslev),
                                   new OleDbParameter("@display",menuDisplay)};
                int j = SQL.Add(sql, param);
                if (j > 0)
                {
                    Response.Write(function.alert_text(2, "添加成功！", "G_Config/C_menu.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 添加新闻分类
    /// </summary>
    private void NewsClassAdd()
    {
        try
        {
            string newsClassid = Request.Form["drpNewsClassid"];
            string newsClasslev = Request.Form["txtNewsClasslev"];
            string newsClassName = Request.Form["txtNewsClassName"].Trim();
            if (function.CheckNull(newsClassName))
            {
                string sql = "insert into c_news_class(c_name,c_classlev,c_classid) values(@name,@classlev,@classid)";
                OleDbParameter[] param ={new OleDbParameter("@name",newsClassName),
                                   new OleDbParameter("@classlev",newsClasslev),
                                   new OleDbParameter("@classid",newsClassid)};
                int j = SQL.Add(sql, param);
                if (j > 0)
                {
                    if (config.Ishtml)//是否需要生成静态页
                    {
                        Make_html.MakeHtmlS("c_news_class", "where c_id=" + j, "[id]");
                    }
                    Response.Write(function.alert_text(2, "添加成功！", "G_News/C_class.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 添加新闻
    /// </summary>
    private void NewsAdd()
    {
        try
        {
            string newsTitle = Request.Form["txtNewsTitle"].Trim();
            string newsClassid = Request.Form["drpNewsClassid"];
            string newsClasslev = Request.Form["txtNewsClasslev"];
            string newsCome = Request.Form["txtNewsCome"].Trim();
            string newsOrder = Request.Form["txtNewsOrder"].Trim();
            string newsSimcontent = Request.Form["txtNewsSimcontent"];
            string newsContent = Request.Form["txtNewsContent"];
            string newsKeywords = Request.Form["txtNewsKeywords"];
            string newsDescription = Request.Form["txtNewsDescription"];
            if (newsOrder == "")
            {
                newsOrder = "0";
            }
            if (function.CheckNull(newsTitle))
            {
                if (!function.isNumber(newsOrder))
                {
                    Response.Write(function.alert_text(4, "排序必须是数字！", ""));
                    return;
                }
                string sql = "insert into c_news(n_title,n_simcontent,n_content,n_keywords,n_description,n_come,n_order,n_date,n_hit,n_classid,n_classlev) values(@title,@simcontent,@content,@keywords,@discription,@come,@order,@date,@hit,@classid,@classlev)";
                OleDbParameter[] param ={new OleDbParameter("@title",newsTitle),
                                   new OleDbParameter("@simcontent",newsSimcontent),
                                   new OleDbParameter("@content",newsContent),
                                   new OleDbParameter("@keywords",newsKeywords),
                                   new OleDbParameter("@discription",newsDescription),
                                   new OleDbParameter("@come",newsCome),
                                   new OleDbParameter("@order",Convert.ToInt32(newsOrder)),
                                   new OleDbParameter("@date",DateTime.Now.ToString()),
                                   new OleDbParameter("@hit","0"),
                                   new OleDbParameter("@classid",newsClassid),
                                   new OleDbParameter("@classlev",newsClasslev)};
                int j = SQL.Add(sql, param);
                if (j > 0)
                {
                    if (config.Ishtml)//是否需要生成静态页
                    {
                        Make_html.MakeHtml("c_news", j.ToString(), "0");
                        Make_html.MakeHtml("c_news_class", newsClassid,"0");
                    }
                    Response.Write(function.alert_text(2, "添加成功！", "G_News/C_news.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 添加产品分类
    /// </summary>
    private void ProductClassAdd()
    {
        try
        {
            string productClassid = Request.Form["drpProductClassid"];
            string productClasslev = Request.Form["txtProductClasslev"];
            string productClassName = Request.Form["txtProductClassName"].Trim();
            if (function.CheckNull(productClassName))
            {
                string sql = "insert into c_product_class(c_name,c_classlev,c_classid) values(@name,@classlev,@classid)";
                OleDbParameter[] param ={new OleDbParameter("@name",productClassName),
                                   new OleDbParameter("@classlev",productClasslev),
                                   new OleDbParameter("@classid",productClassid)};
                int j = SQL.Add(sql, param);
                if (j > 0)
                {
                    if (config.Ishtml)//是否需要生成静态页
                    {
                        Make_html.MakeHtmlS("c_product_class", "where c_id=" + j, "[id]");
                    }
                    Response.Write(function.alert_text(2, "添加成功！", "G_Product/C_class.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 添加产品
    /// </summary>
    private void ProductAdd()
    {
        try
        {
            string productName = Request.Form["txtProductName"].Trim();
            string productClassid = Request.Form["drpProductClassid"];
            string productClasslev = Request.Form["txtProductClasslev"];
            string productSimContent = Request.Form["txtProductSimcontent"];
            string productContent = Request.Form["txtProductContent"];
            string productOrder = Request.Form["txtProductOrder"].Trim();
            string productCom = Request.Form["rdoProductCom"];  //是否推荐
            HttpPostedFile file = Request.Files[0];             //产品图片
            if (productOrder == "")
            {
                productOrder = "0";
            }
            string filename = "";
            string bigImage = "";
            string smallImage = "";
            string uploadPath = "";
            if (function.CheckNull(productName, productClassid))
            {
                if (!function.isNumber(productOrder))
                {
                    Response.Write(function.alert_text(4, "排序必须为数字！", ""));
                    return;
                }
                #region
                if (file.ContentLength > 0)
                {
                    uploadPath = HttpContext.Current.Server.MapPath("/UploadFiles/");
                    if (!System.IO.Directory.Exists(Server.MapPath("/UploadFiles/small/")))
                    {
                        System.IO.Directory.CreateDirectory(Server.MapPath("/UploadFiles/small/"));
                    }
                    filename = make_htm.Upload("/UploadFiles/", "/UploadFiles/small/", 200, 200, 300, file, "jpg,gif,bmp,png");
                    //2,上传失败：文件太大
                    if (filename.Contains("上传失败"))
                    {
                        Response.Write(function.alert_text(4, filename, ""));
                        return;
                    }
                    bigImage = "/UploadFiles/" + filename;
                    smallImage = "/UploadFiles/small/" + filename;
                    System.IO.FileInfo fi = new System.IO.FileInfo(Server.MapPath(smallImage));
                    string c_come = Request.UrlReferrer.ToString();
                    string c_type = file.ContentType;
                    string c_size = (Math.Round((Convert.ToDouble(file.ContentLength) / 1024), 2)).ToString();
                    string smallSize = (Math.Round(Convert.ToDouble(fi.Length) / 1024, 2)).ToString();
                    string c_date = DateTime.Now.ToString();
                    SQL.ExecuteSql("insert into c_files(c_url,c_come,c_type,c_size,c_date) values('" + bigImage + "','" + c_come + "','" + c_type + "','" + c_size + "','" + c_date + "')");
                    SQL.ExecuteSql("insert into c_files(c_url,c_come,c_type,c_size,c_date) values('" + smallImage + "','" + c_come + "','" + c_type + "','" + smallSize + "','" + c_date + "')");
                }
                #endregion
                string sql = "insert into c_product(p_name,p_classid,p_classlev,p_img,p_preimg,p_simcontent,p_content,p_hit,p_order,p_date,p_com) values(@name,@classid,@classlev,@img,@perimg,@simcontent,@content,@hit,@order,@date,@com)";
                OleDbParameter[] param ={new OleDbParameter("@name",productName),
                                   new OleDbParameter("@classid",productClassid),
                                   new OleDbParameter("@classlev",productClasslev),
                                   new OleDbParameter("@img",bigImage),
                                   new OleDbParameter("@perimg",smallImage),
                                   new OleDbParameter("@simcontent",productSimContent),
                                   new OleDbParameter("@content",productContent),
                                   new OleDbParameter("@hit","0"),
                                   new OleDbParameter("@order",productOrder),
                                   new OleDbParameter("@date",DateTime.Now),
                                   new OleDbParameter("@com",productCom)};
                int j = SQL.Add(sql, param);
                if (j > 0)
                {
                    if (config.Ishtml)//是否需要生成静态页
                    {
                        Make_html.MakeHtml("c_product", j.ToString(), "0");
                        Make_html.MakeHtml("c_product_class", productClassid, "0");
                    }
                    Response.Write(function.alert_text(2, "添加成功！", "G_Product/C_product.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 添加单篇文章
    /// </summary>
    private void BaseInfoAdd()
    {
        try
        {
            string baseClassid = Request.Form["drpBaseClassid"];
            string baseClasslev = Request.Form["txtBaseClasslev"];
            string baseName = Request.Form["txtBaseName"];
            string baseSimContent = Request.Form["txtBaseSimcontent"];
            string baseContent = Request.Form["txtBaseContent"];

            if (function.CheckNull(baseName))
            {
                string sql = "insert into c_base(b_name,b_simcontent,b_content,b_classid,b_classlev) values(@name,@simcontent,@content,@classid,@classlev)";
                OleDbParameter[] param ={new OleDbParameter("@name",baseName),
                                   new OleDbParameter("@simcontent",baseSimContent),
                                   new OleDbParameter("@content",baseContent),
                                   new OleDbParameter("@classid",baseClassid),
                                   new OleDbParameter("@classlev",baseClasslev)};
                int j = SQL.Add(sql, param);
                if (j > 0)
                {
                    if (config.Ishtml)//是否需要生成静态页
                    {
                        Make_html.MakeHtml("c_base", baseName);
                    }
                    Response.Write(function.alert_text(2, "添加成功！", "G_Base/C_Info.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 静态页绑定添加
    /// </summary>
    private void Makehtml()
    {
        try
        {
            string m_name = Request.Form["m_name"];
            string m_template = Request.Form["m_template"];
            string m_makeUrl = Request.Form["m_makeUrl"];
            string m_table = Request.Form["m_table"];
            string m_where = Request.Form["m_where"];
            string m_classid = Request.Form["m_classid"];
            if (m_classid==null)
            {
                m_classid = "";
            }
            if (function.CheckNull(m_template, m_makeUrl, m_name, m_table))
            {
                DataTable t = SQL.GetList("select m_id from c_makehtml where m_name='" + m_name + "'").Tables[0];
                if (t.Rows.Count > 0)
                {
                    Response.Write(function.alert_text(4, "该数据页已经添加过！", ""));
                    return;
                }
                string sql = "insert into c_makehtml(m_template,m_makeUrl,m_name,m_table,m_where,m_classid) values(@m_template,@m_makeUrl,@m_name,@m_table,@m_where,@m_classid)";
                OleDbParameter[] param ={new OleDbParameter("@m_template",m_template),
                                   new OleDbParameter("@m_makeUrl",m_makeUrl),
                                   new OleDbParameter("@m_name",m_name),
                                   new OleDbParameter("@m_table",m_table),
                                   new OleDbParameter("@m_where",m_where),
                                   new OleDbParameter("@m_classid",m_classid)};
                int j = SQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    Response.Write(function.alert_text(2, "绑定成功！", "make_html/m_bind.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }
}