﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.OleDb;
using System.Data;

public partial class cms_manager_Admin_upd : System.Web.UI.Page
{
    Config config = new Config();
    function make_htm = new function();
    guandongren.MakehtmlSQL SQL = new guandongren.MakehtmlSQL();
    protected void Page_Load(object sender, EventArgs e)
    {
        function.CheckSession();
        string T = Request.QueryString["T"];
        string id = Request.QueryString["id"];
        switch (T)
        {
            case "banner":
                BannerUpd(id);
                break;
            case "regex":
                RegexUpd(id);
                break;
            case "link":
                LinkUpd(id);
                break;
            case "menu":
                MenuUpd(id);
                break;
            case "newsClass":
                NewsClassUpd(id);
                break;
            case "news":
                NewsUpd(id);
                break;
            case "productClass":
                ProductClassUpd(id);
                break;
            case "product":
                ProductUpd(id);
                break;
            case "base":
                BaseInfoUpd(id);
                break;
            case "makehtml":
                makehtml(id);
                break;
        }
    }

    private void BannerUpd(string id)
    {
        if (id == "" || id == null || !function.isNumber(id))
        {
            Response.Write(function.alert_text(4, "错误，ID为空或不是数字！", ""));
            return;
        }
        string bannerLink = Request.Form["txtBannerLink"];
        if (bannerLink == "" || bannerLink == null)
        {
            bannerLink = "#";
        }
        string bannerAlt = Request.Form["txtBannerAlt"];
        string bannerTitle = Request.Form["txtBannertitle"].Trim(); 
        string filename = "";
        HttpPostedFile file = Request.Files[0];
        if (file.ContentLength > 0)
        {
            if (filename.Contains("上传失败"))
            {
                Response.Write(function.alert_text(4, filename, ""));
                return;
            }

            string sql = "update c_banner set b_link=@link,b_url=@url,b_alt=@alt,b_title=@title where b_id=" + id;
            OleDbParameter[] param ={new OleDbParameter("@link",bannerLink),
                                        new OleDbParameter("@url",filename),
                                        new OleDbParameter("@alt",bannerAlt),
                                        new OleDbParameter("@title",bannerTitle)};
            int j = SQL.ExecuteSql(sql, param);
            if (j > 0)
            {
                Response.Write(function.alert_text(2, "修改成功！", "G_config/C_banner.aspx"));
                return;
            }
        }
        else
        {

            string sql = "update c_banner set b_link=@link,b_alt=@alt,b_title=@title where b_id=" + id;
            OleDbParameter[] param ={new OleDbParameter("@link",bannerLink),
                                        new OleDbParameter("@alt",bannerAlt),
                                    new OleDbParameter("@title",bannerTitle)};
            int j = SQL.ExecuteSql(sql, param);
            if (j > 0)
            {
                Response.Write(function.alert_text(2, "修改成功！", "G_config/C_banner.aspx"));
                return;
            }
        }
 
    }

    /// <summary>
    /// 修改页面设置
    /// </summary>
    /// <param name="id"></param>
    private void RegexUpd(string id)
    {
        try
        {
            if (id == "" || id == null || !function.isNumber(id))
            {
                Response.Write(function.alert_text(4, "错误，ID为空或不是数字！", ""));
                return;
            }
            string url = Request.Form["txtUrl"].Trim();
            string rule = Request.Form["txtRule"].Trim();
            if (function.CheckNull(url, rule))
            {
                string sql = "update c_regex set r_url=@url,r_rule=@rule where r_id=" + id;
                OleDbParameter[] param ={new OleDbParameter("@url",url),
                                   new OleDbParameter("@rule",rule)};
                int j = SQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    Response.Write(function.alert_text(2, "修改成功！", "G_Config/C_regex.aspx"));
                    return;
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 修改友情链接
    /// </summary>
    /// <param name="id"></param>
    private void LinkUpd(string id)
    {
        try
        {
            string linkType = Request.Form["drpType"];
            string linkName = Request.Form["txtName"];
            string linkUrl = Request.Form["txtUrl"];
            string linkOrder = Request.Form["txtOrder"];
            string oldImg = Request.Form["oldImg"];
            string uploadPath = "";
            string filename = "";
            if (linkOrder == "" || linkOrder == null)
            {
                linkOrder = "0";
            }
            if (function.CheckNull(linkName, linkUrl))
            {
                if (!function.isNumber(linkOrder))
                {
                    Response.Write(function.alert_text(4, "排序必须是数字！", ""));
                    return;
                }
                if (linkType == "1")
                {
                    HttpPostedFile file = Request.Files[0];
                    if (file.ContentLength <= 0 && oldImg == null)
                    {
                        Response.Write(function.alert_text(4, "请选择图片！", ""));
                        return;
                    }
                    if (file.ContentLength > 0)
                    {
                        uploadPath = HttpContext.Current.Server.MapPath("/UploadFiles/");
                        if (!System.IO.Directory.Exists(uploadPath))
                        {
                            System.IO.Directory.CreateDirectory(uploadPath);
                        }
                        filename = make_htm.Upload("/UploadFiles/", 200, file, "jpg,gif,bmp,png");
                        if (filename == "-2")
                        {
                            Response.Write(function.alert_text(4, "上传的文件不能大于200K！", ""));
                            return;
                        }
                        if (filename == "-3")
                        {
                            Response.Write(function.alert_text(4, "只能上传[jpg,gif,png,bmp]格式的文件！", ""));
                            return;
                        }
                        string c_come = Request.UrlReferrer.ToString();
                        string c_type = file.ContentType;
                        string c_size = (Math.Round((Convert.ToDouble(file.ContentLength) / 1024), 2)).ToString();
                        string c_date = DateTime.Now.ToString();
                        try
                        {
                            System.IO.File.Delete(Server.MapPath(oldImg));
                        }
                        catch (Exception)
                        { }
                        int k = SQL.GetListcount("c_files", "c_url='" + oldImg + "'");
                        if (k > 0)
                        {
                            SQL.ExecuteSql("update c_files set c_url='" + filename + "',c_come='" + c_come + "',c_type='" + c_type + "',c_size='" + c_size + "',c_date='" + c_date + "' where c_url='" + oldImg + "'");
                        }
                        else
                        {
                            SQL.ExecuteSql("insert into c_files(c_url,c_type,c_come,c_size,c_date) values('" + filename + "','" + c_type + "','" + c_come + "','" + c_size + "','" + c_date + "')");
                        }
                        SQL.ExecuteSql("update c_link set l_img='" + filename + "' where l_id=" + id);
                    }
                }
                else
                {
                    try
                    {
                        System.IO.File.Delete(Server.MapPath(oldImg));
                    }
                    catch
                    { }
                    SQL.ExecuteSql("delete from c_files where c_url='" + oldImg + "'");
                    SQL.ExecuteSql("update c_link set l_img='' where l_id=" + id);
                }

                string sql = "update c_link set l_name=@name,l_url=@url,l_type=@type,l_order=@order where l_id=" + id;
                OleDbParameter[] param ={new OleDbParameter("@name",linkName),
                                   new OleDbParameter("@url",linkUrl),
                                   new OleDbParameter("@type",linkType),
                                   new OleDbParameter("@order",linkOrder)};
                int j = SQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    if (config.Ishtml)//是否需要生成静态页
                    {
                        Make_html.MakeHtml("c_link","","");
                    }
                    Response.Write(function.alert_text(2, "修改成功！", "G_Config/C_link.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 修改菜单
    /// </summary>
    /// <param name="id"></param>
    private void MenuUpd(string id)
    {
        try
        {
            string menuName = Request.Form["txtMenuName"];
            string menuUrl = Request.Form["txtMenuUrl"];
            string classid = Request.Form["drpMenuClassid"];
            if (menuUrl == "")
            {
                menuUrl = "#";
            }
            string menuDisplay = Request.Form["rdoMenuDisplay"];
            if (function.CheckNull(menuName))
            {
                string sql = "update c_menu set m_name=@name,m_url=@url,m_display=@display,m_classid=@m_classid where m_id=" + id;
                OleDbParameter[] param ={new OleDbParameter("@name",menuName),
                                   new OleDbParameter("@url",menuUrl),
                                   new OleDbParameter("@display",menuDisplay),
                                    new OleDbParameter("@m_classid",classid)
                                        };
                int j = SQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    Response.Write(function.alert_text(2, "修改成功！", "G_Config/C_menu.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 修改新闻分类
    /// </summary>
    /// <param name="id"></param>
    private void NewsClassUpd(string id)
    {
        try
        {
            string newsClassid = Request.Form["drpNewsClassid"];
            string newsClasslev = Request.Form["txtNewsClasslev"];
            string newsClassName = Request.Form["txtNewsClassName"].Trim();
            if (function.CheckNull(newsClassName))
            {
                DataTable dt = SQL.GetList("select * from c_news_class where c_id=" + id).Tables[0];
                if (dt.Rows.Count > 0)
                {
                    if (dt.Rows[0]["c_classlev"].ToString() != newsClasslev)
                    {
                        dt = SQL.GetList("select c_id from c_news_class where c_classid=" + id).Tables[0];
                        if (dt.Rows.Count > 0)
                        {
                            Response.Write(function.alert_text(4, "该分类下存在子类，请先删除子类！", ""));
                            return;
                        }
                    }
                }
                string sql = "update c_news_class set c_name=@name,c_classlev=@classlev,c_classid=@classid where c_id=" + id;
                OleDbParameter[] param ={new OleDbParameter("@name",newsClassName),
                                   new OleDbParameter("@classlev",newsClasslev),
                                   new OleDbParameter("@classid",newsClassid)};
                int j = SQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    if (config.Ishtml)//是否需要生成静态页
                    {
                        Make_html.MakeHtml("c_news_class", id, "0");
                    }
                    Response.Write(function.alert_text(2, "修改成功！", "G_News/C_class.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 修改新闻
    /// </summary>
    /// <param name="id"></param>
    private void NewsUpd(string id)
    {
        try
        {
            string newsTitle = Request.Form["txtNewsTitle"].Trim();
            string newsClassid = Request.Form["drpNewsClassid"];
            string newsClasslev = Request.Form["txtNewsClasslev"];
            string newsCome = Request.Form["txtNewsCome"].Trim();
            string newsOrder = Request.Form["txtNewsOrder"].Trim();
            string newsSimcontent = Request.Form["txtNewsSimcontent"];
            string newsContent = Request.Form["txtNewsContent"];
            string newsKeywords = Request.Form["txtNewsKeywords"];
            string newsDescription = Request.Form["txtNewsDescription"];
            if (newsOrder == "")
            {
                newsOrder = "0";
            }
            if (function.CheckNull(newsTitle))
            {
                if (!function.isNumber(newsOrder))
                {
                    Response.Write(function.alert_text(4, "排序必须是数字！", ""));
                    return;
                }
                string sql = "update c_news set n_title=@title,n_simcontent=@simcontent,n_content=@content,n_keywords=@keywords,n_description=@discription,n_come=@come,n_order=@order,n_classid=@classid,n_classlev=@classlev where n_id=" + id;
                OleDbParameter[] param ={new OleDbParameter("@title",newsTitle),
                                   new OleDbParameter("@simcontent",newsSimcontent),
                                   new OleDbParameter("@content",newsContent),
                                   new OleDbParameter("@keywords",newsKeywords),
                                   new OleDbParameter("@discription",newsDescription),
                                   new OleDbParameter("@come",newsCome),
                                   new OleDbParameter("@order",newsOrder),
                                   new OleDbParameter("@classid",newsClassid),
                                   new OleDbParameter("@classlev",newsClasslev)};
                int j = SQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    if (config.Ishtml)//是否需要生成静态页
                    {
                        Make_html.MakeHtml("c_news", id, "0");
                        Make_html.MakeHtml("c_news_class", newsClassid, "0");
                    }
                    Response.Write(function.alert_text(2, "修改成功！", "G_News/C_news.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 修改产品分类
    /// </summary>
    /// <param name="id"></param>
    private void ProductClassUpd(string id)
    {
        try
        {
            string productClassid = Request.Form["drpProductClassid"];
            string productClasslev = Request.Form["txtProductClasslev"];
            string productClassName = Request.Form["txtProductClassName"].Trim();
            if (function.CheckNull(productClassName))
            {
                DataTable dt = SQL.GetList("select * from c_product_class where c_id=" + id).Tables[0];
                if (dt.Rows.Count > 0)
                {
                    if (dt.Rows[0]["c_classlev"].ToString() != productClasslev)
                    {
                        dt = SQL.GetList("select c_id from c_product_class where c_classid=" + id).Tables[0];
                        if (dt.Rows.Count > 0)
                        {
                            Response.Write(function.alert_text(4, "该分类下存在子类，请先删除子类！", ""));
                            return;
                        }
                    }
                }
                string sql = "update c_product_class set c_name=@name,c_classlev=@classlev,c_classid=@classid where c_id=" + id;
                OleDbParameter[] param ={new OleDbParameter("@name",productClassName),
                                   new OleDbParameter("@classlev",productClasslev),
                                   new OleDbParameter("@classid",productClassid)};
                int j = SQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    if (config.Ishtml)//是否需要生成静态页
                    {
                        Make_html.MakeHtml("c_product_class", id, "0");
                    }
                    Response.Write(function.alert_text(2, "修改成功！", "G_Product/C_class.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 修改产品信息
    /// </summary>
    /// <param name="id"></param>
    private void ProductUpd(string id)
    {
        try
        {
            string productName = Request.Form["txtProductName"].Trim();
            string productClassid = Request.Form["drpProductClassid"];
            string productClasslev = Request.Form["txtProductClasslev"];
            string productSimContent = Request.Form["txtProductSimcontent"];
            string productContent = Request.Form["txtProductContent"];
            string productOrder = Request.Form["txtProductOrder"].Trim();
            string productCom = Request.Form["rdoProductCom"];  //是否推荐
            HttpPostedFile file = Request.Files[0];             //产品图片
            if (productOrder == "")
            {
                productOrder = "0";
            }
            string filename = "";
            string bigImage = "";
            string smallImage = "";
            string uploadPath = "";
            if (function.CheckNull(productName, productClassid))
            {
                if (!function.isNumber(productOrder))
                {
                    Response.Write(function.alert_text(4, "排序必须为数字！", ""));
                    return;
                }
                #region
                if (file.ContentLength > 0)
                {
                    uploadPath = HttpContext.Current.Server.MapPath("/UploadFiles/");
                    if (!System.IO.Directory.Exists(Server.MapPath("/UploadFiles/small/")))
                    {
                        System.IO.Directory.CreateDirectory(Server.MapPath("/UploadFiles/small/"));
                    }
                    filename = make_htm.Upload("/UploadFiles/", "/UploadFiles/small/", 200, 200, 300, file, "jpg,gif,bmp,png");
                    //2,上传失败：文件太大
                    if (filename.Contains("上传失败"))
                    {
                        Response.Write(function.alert_text(4, filename, ""));
                        return;
                    }
                    bigImage = "/UploadFiles/" + filename;
                    smallImage = "/UploadFiles/small/" + filename;
                    System.IO.FileInfo fi = new System.IO.FileInfo(Server.MapPath(smallImage));
                    string c_come = Request.UrlReferrer.ToString();
                    string c_type = file.ContentType;
                    string c_size = (Math.Round((Convert.ToDouble(file.ContentLength) / 1024), 2)).ToString();
                    string smallSize = (Math.Round(Convert.ToDouble(fi.Length) / 1024, 2)).ToString();
                    string c_date = DateTime.Now.ToString();
                    SQL.ExecuteSql("update c_product set p_img='" + bigImage + "',p_preimg='" + smallImage + "' where p_id=" + id);
                    SQL.ExecuteSql("insert into c_files(c_url,c_come,c_type,c_size,c_date) values('" + bigImage + "','" + c_come + "','" + c_type + "','" + c_size + "','" + c_date + "')");
                    SQL.ExecuteSql("insert into c_files(c_url,c_come,c_type,c_size,c_date) values('" + smallImage + "','" + c_come + "','" + c_type + "','" + smallSize + "','" + c_date + "')");
                }
                #endregion
                string sql = "update c_product set p_name=@name,p_classid=@classid,p_classlev=@classlev,p_simcontent=@simcontent,p_content=@content,p_order=@order,p_date=@date,p_com=@com where p_id=" + id;
                OleDbParameter[] param ={new OleDbParameter("@name",productName),
                                   new OleDbParameter("@classid",productClassid),
                                   new OleDbParameter("@classlev",productClasslev),
                                   new OleDbParameter("@simcontent",productSimContent),
                                   new OleDbParameter("@content",productContent),
                                   new OleDbParameter("@order",productOrder),
                                   new OleDbParameter("@date",DateTime.Now),
                                   new OleDbParameter("@com",productCom)};
                int j = SQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    if (config.Ishtml)//是否需要生成静态页
                    {
                        Make_html.MakeHtml("c_product", id, "0");
                        Make_html.MakeHtml("c_product_class", productClassid, "0");
                    }
                    Response.Write(function.alert_text(2, "修改成功！", "G_Product/C_product.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 修改常规设置
    /// </summary>
    /// <param name="id"></param>
    private void BaseInfoUpd(string id)
    {
        //try
        //{
            string baseClassid = Request.Form["drpBaseClassid"];
            string baseClasslev = Request.Form["txtBaseClasslev"];
            string baseName = Request.Form["txtBaseName"];
            string baseSimContent = Request.Form["txtBaseSimcontent"];
            string baseContent = Request.Form["txtBaseContent"];
            if (function.CheckNull(baseName))
            {
                string sql = "update c_base set b_name=@name,b_simcontent=@simcontent,b_content=@content,b_classid=@classid,b_classlev=@classlev where b_id=" + id;
                OleDbParameter[] param ={new OleDbParameter("@name",baseName),
                                   new OleDbParameter("@simcontent",baseSimContent),
                                   new OleDbParameter("@content",baseContent),
                                   new OleDbParameter("@classid",baseClassid),
                                   new OleDbParameter("@classlev",baseClasslev)};
                int j = SQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    if (config.Ishtml)//是否需要生成静态页
                    {
                        Make_html.MakeHtml("c_base",baseName);
                    }
                    Response.Write(function.alert_text(2, "修改成功！", "G_Base/C_Info.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        //}
        //catch (Exception ex)
        //{
        //    Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        //}
    }

    /// <summary>
    /// 修改生成静态页绑定
    /// </summary>
    /// <param name="id"></param>
    private void makehtml(string id)
    {
        try
        {
            string m_name = Request.Form["m_name"];
            string m_template = Request.Form["m_template"];
            string m_makeUrl = Request.Form["m_makeUrl"];
            string m_table = Request.Form["m_table"];
            string m_where = Request.Form["m_where"];
            string m_classid = Request.Form["m_classid"];
            if (m_classid==null)
            {
                m_classid = "0";
            }
            if (function.CheckNull(m_template, m_makeUrl, m_name, m_table))
            {
                string sql = "update c_makehtml set m_template=@m_template,m_makeUrl=@m_makeUrl,m_name=@m_name,m_where=@m_where,m_table=@m_table,m_classid=@m_classid where m_id=" + id;
                OleDbParameter[] param ={new OleDbParameter("@m_template",m_template),
                                   new OleDbParameter("@m_makeUrl",m_makeUrl),
                                   new OleDbParameter("@m_name",m_name),
                                   new OleDbParameter("@m_where",m_where),
                                   new OleDbParameter("@m_table",m_table),
                                   new OleDbParameter("@m_classid",m_classid)};
                int j = SQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    Response.Write(function.alert_text(2, "修改成功！", "make_html/M_bind.aspx"));
                }
            }
            else
            {
                Response.Write(function.alert_text(4, "请将资料填写完整！", ""));
            }
        }
        catch (Exception ex)
        {
            Response.Write(function.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }
}