﻿/********************************************
 * 
 * description: 基于 .NET 2.0 
 *              常用方法类 
 * 
 * author:     漠北
 * 
 * blogs:       http://www.mksun.com
 * 
 * Date:        2006-10-8 
 * 
 ********************************************/
using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using System.IO;
using System.Web.Mail;
using System.Text;
using System.Xml;
namespace MkSun.Ke_System
{
/// <summary>
/// function 的摘要说明
/// </summary>
    public class Ke_Common : Page
{
    public Ke_Common()
	{
		//
		// TODO: 在此处添加构造函数逻辑
		//
	}

    //8. --------------- 系统函数---------------
    // 执行提示，页面重定向到相关页面
    // </summary>
    // <param name="text">窗口提示信息</param>
    // <param name="href">目标页面</param>
    public static void Alert(string text, string href)
    {
        HttpContext.Current.Response.Write("<script language='JavaScript'>alert('" + text + "');this.location.href = '" + href + "';</script>");
        HttpContext.Current.Response.End();

    }
    // <summary>
    // 执行提示，页面重定向到相关页面
    // </summary>
    // <param name="text">窗口提示信息</param>

    public static void Alert(string text)
    {
        HttpContext.Current.Response.Write("<script language='JavaScript'>alert('" + text + "')</script>");
        HttpContext.Current.Response.End();


    }
    //进行操作判断，是否进一步操作
    //strAlert 提示语言 url1 确认返回的地址 url2 取消返回的地址
    //
    public static void Confirm(string strAlert, string url1, string url2)
    {
        HttpContext.Current.Response.Write("<Script Language='Javascript'>");
        HttpContext.Current.Response.Write("if(confirm('" + strAlert + "'))");
        HttpContext.Current.Response.Write("{");
        HttpContext.Current.Response.Write("this.location.href='" + url1 + "';");
        HttpContext.Current.Response.Write("}");
        HttpContext.Current.Response.Write("else");
        HttpContext.Current.Response.Write("{");
        HttpContext.Current.Response.Write("this.location.href='" + url2 + "';");
        HttpContext.Current.Response.Write("}");
        HttpContext.Current.Response.Write("</Script>");
        HttpContext.Current.Response.End();

    }
    /// <summary>
    /// 去除HTML标记
    /// </summary>
    /// <param name="NoHTML">包括HTML的源码 </param>
    /// <returns>已经去除后的文字</returns>
    public string NoHTML(string Htmlstring)
    {
        string strOutput = Htmlstring;

        strOutput = Regex.Replace(strOutput, @"<script[^>]*?>.*?</script>", "", RegexOptions.IgnoreCase);
        //			strOutput = Regex.Replace(strOutput,@"<(\/\s*)?!?((\w+:)?\w+)(\w+(\s*=?\s*(([""'])(\\[""'tbnr]|[^\7])*?\7|\w+)|.{0})|\s)*?(\/\s*)?>","",RegexOptions.IgnoreCase);//在个别情况下会引起IIS吃爆CPU的现象
        strOutput = Regex.Replace(strOutput, @"<(.[^>]*)>", "", RegexOptions.IgnoreCase);
        strOutput = Regex.Replace(strOutput, @"([\r\n])[\s]+", "", RegexOptions.IgnoreCase);
        strOutput = Regex.Replace(strOutput, @"-->", "", RegexOptions.IgnoreCase);
        strOutput = Regex.Replace(strOutput, @"<!--.*", "", RegexOptions.IgnoreCase);


        strOutput = Regex.Replace(strOutput, @"&(quot|#34);", "\"", RegexOptions.IgnoreCase);
        strOutput = Regex.Replace(strOutput, @"&(amp|#38);", "&", RegexOptions.IgnoreCase);
        strOutput = Regex.Replace(strOutput, @"&(lt|#60);", "<", RegexOptions.IgnoreCase);
        strOutput = Regex.Replace(strOutput, @"&(gt|#62);", ">", RegexOptions.IgnoreCase);
        strOutput = Regex.Replace(strOutput, @"&(nbsp|#160);", " ", RegexOptions.IgnoreCase);
        strOutput = Regex.Replace(strOutput, @"&(iexcl|#161);", "\xa1", RegexOptions.IgnoreCase);
        strOutput = Regex.Replace(strOutput, @"&(cent|#162);", "\xa2", RegexOptions.IgnoreCase);
        strOutput = Regex.Replace(strOutput, @"&(pound|#163);", "\xa3", RegexOptions.IgnoreCase);
        strOutput = Regex.Replace(strOutput, @"&(copy|#169);", "\xa9", RegexOptions.IgnoreCase);
        strOutput = Regex.Replace(strOutput, @"&#(\d+);", "", RegexOptions.IgnoreCase);


        strOutput.Replace("<", "");
        strOutput.Replace(">", "");
        strOutput.Replace("\r\n", "");
        strOutput = HttpContext.Current.Server.HtmlEncode(strOutput).Trim();

        return strOutput;
    } 
    // MD5加密
    // </summary>
    // <param name="InputString">要加密的字串</param>
    // <returns>密文</returns>
    public static string Md5hash_String(string InputString)
    {
        InputString = System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(InputString, "MD5");
        return InputString;
    }
    // <summary>
    // 截短字串的函数
    // </summary>
    // <param name="mText">要加工的字串</param>
    // <param name="byteCount">长度</param>
    // <returns>被加工过的字串</returns>
    public static string GetString(string mText, int byteCount)
    {
        if (byteCount < 1) return mText;

        if (System.Text.Encoding.Default.GetByteCount(mText) <= byteCount)
        {
            return mText;
        }
        else
        {
            byte[] txtBytes = System.Text.Encoding.Default.GetBytes(mText);
            byte[] newBytes = new byte[byteCount - 4];

            for (int i = 0; i < byteCount - 4; i++)
                newBytes[i] = txtBytes[i];

            return System.Text.Encoding.Default.GetString(newBytes) + "...";
        }
    }
    // <summary>
    // 检察是否都是数字
    // </summary>
    // <param name="str">要检查的字串</param>
    // <returns>bool</returns>
    public static bool IsNumeric(string str)
    {
        if (str == null || str == "")
        {

            return false;
        }
        Regex reg = new Regex(@"^[+]?\d*$");
        return reg.IsMatch(str);
    }

    // <summary>
    // 检察是否都是浮点数
    // </summary>
    // <param name="str">要检查的字串</param>
    // <returns>bool</returns>
        public static bool Isfloat(string str)
        {
            if (str == null || str == "")
            {

                return false;
            }
            Regex reg = new Regex(@"^\d+(.\d+)?$");
            return reg.IsMatch(str);
        }
    // <summary>
    // 检察是否正确的Email格式
    // </summary>
    // <param name="str">要检查的字串</param>
    // <returns>bool</returns>
    public static bool IsEmail(string str)
    {
        Regex reg = new Regex(@"^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$");
        return reg.IsMatch(str);
    }

    // <summary>
    // 检察是否正确的日期格式
    // </summary>
    // <param name="str">要检查的字串</param>
    // <returns>bool</returns>
    public static bool IsDate(string str)
    {
        //考虑到了4年一度的366天，还有特殊的2月的日期
        Regex reg = new Regex(@"^((((1[6-9]|[2-9]\d)\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\d|3[01]))|(((1[6-9]|[2-9]\d)\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\d|30))|(((1[6-9]|[2-9]\d)\d{2})-0?2-(0?[1-9]|1\d|2[0-8]))|(((1[6-9]|[2-9]\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-)) (20|21|22|23|[0-1]?\d):[0-5]?\d:[0-5]?\d$");
        return reg.IsMatch(str);
    }


    // <summary>
    // 获取用户登录IP
    // </summary>
    // <returns></returns>
    public static string GetUserIP()
    {
        string UserIP =HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
        if (UserIP == null || UserIP == "")
        {
            UserIP = HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"];
        }
        return UserIP;
    }
        

    /// <summary>
    /// 显示标准的HTML
    /// </summary>
    /// <param name="str"> 要显示的字符串</param>
    /// <returns></returns>
    public static string HTMLEnCode(string str)
     {
         string Str = "";
         if (str != null || str == null)
         {
             System.Text.StringBuilder sb = new System.Text.StringBuilder(str);
             sb = sb.Replace(">", "&gt;");
             sb = sb.Replace("<", "&lt;");
             sb = sb.Replace(Convert.ToChar(32).ToString(), "&nbsp;");
             sb = sb.Replace(Convert.ToChar(13).ToString(), "");
             sb = sb.Replace(Convert.ToChar(10).ToString() + Convert.ToChar(10).ToString(), "</P><P>");
             sb = sb.Replace(Convert.ToChar(10).ToString(), "<BR>");
             sb = sb.Replace("'", "''");
             sb = sb.Replace("&amp;", "&");
             return sb.ToString();
         }
         else
         {
             return "";
         }
      }

     // <summary>
     // 获得一个num位时间随机数
     // </summary>
     // <returns>返回随机数</returns>
        public static string GetDataRandom(int Num)
     {
         string strData = DateTime.Now.ToShortDateString();
         strData = strData.Replace(":", "");
         strData = strData.Replace("-", "");
         strData = strData.Replace(" ", "");
         Random r = new Random();
         strData = strData + r.Next(Num);
         return strData;
     }

        /// <summary>
        /// 是否含有非法字符
        /// </summary>
        /// <param name="_String"></param>
        /// <returns></returns>

        public static bool GetSafeString(string _String)
        { 
                 string[] parms=new string[]{"DROP","CREATE","SELECT","INSERT INTO","DELETE","KE_SYSTEM","<",">","SCRIPT","<+SCRIPT"};
                 foreach (string str in parms)
                 {
                     if (_String == str)
                     {
                         return false;
                     }
                 
                 }
                 return true;       
        }
 }
}