﻿/********************************************
 * 
 * description: 基于 .NET 2.0 
 *              系统错误业务逻辑类 
 * 
 * author:     漠北
 * 
 * blogs:       http://www.mksun.com
 * 
 * Date:        2006-10-8 
 * 
 ********************************************/
using System;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
/// <summary>
/// 错误处理函数，用于记录错误日志
/// </summary>
namespace MkSun.System_Error
{
public class SystemError:Page 
	{
		//记录错误日志位置
    private static string _fileName = HttpContext.Current.Server.MapPath(@"~/LOG/Systemlog.txt");

		public static String  FileName
		{
			get
			{
				return(_fileName);
			}
			set
			{
				if(value != null || value != "")
				{
					_fileName = value;
				}
			}
		}

		/// <summary>
		/// 记录日志至文本文件
		/// </summary>
		/// <param name="message">记录的内容</param>
		public static void SystemLog(string message) 
		{
            if (File.Exists(FileName))
            {
                ///如果日志文件已经存在，则直接写入日志文件
                StreamWriter sr = File.AppendText(FileName);
                sr.WriteLine("\n");
                sr.WriteLine(DateTime.Now.ToString() + message);
                sr.Close();
            }
            else
            {
                ///创建日志文件
                StreamWriter sr = File.CreateText(FileName);
                sr.Close();
            }	
		}
	}
}
