
/********************************************
 * 
 * description:  .NET 2.0 
 *              XML߼
 * 
 * author:     Į
 * 
 * blogs:       http://www.mksun.com
 * 
 * Date:        2006-10-8 
 * 
 ********************************************/
using System;
using System.Xml;

namespace Ke_System_xml
{
	/// <summary>
	/// xml ժҪ˵
	/// </summary>
	public class XmlHelper
	{
		protected XmlDocument xdoc=new XmlDocument();
		public XmlElement root;
		public XmlHelper()
		{
			
		}

        //һµXML

        public void CreateXML(XmlDataDocument Doc,string xmlName, string version, string encoding, string standalone)
        {  
            //Write and Append the XML heading
            XmlNode DeclarationNode = Doc.CreateXmlDeclaration(version, encoding, standalone);

            Doc.AppendChild(DeclarationNode);
        }

        //˵

        public void CreateComment(XmlDataDocument Doc, string strCommen)
        {
            //Write and Append some comment

            XmlNode comment = Doc.CreateComment(strCommen);

            Doc.AppendChild(comment);
        
        }

        //XML
		public void LoadXml(string xml)
		{
			xdoc.LoadXml(xml);
			root=(XmlElement)xdoc.FirstChild;
		}

		//ȡΪnameĽֵ
		public string GetValue(string name)
		{
			XmlNode xn=FindXnByName(root.ChildNodes,name);
			if(xn==null)return null;
			return xn.InnerText;
		}

		//һversionָڵXmlDocument
		public void CreateRoot(string rootName)
		{
			XmlElement xe=xdoc.CreateElement(rootName);
			xdoc.AppendChild(xe);
			root=xe;
		}
		
		//һӽ
		public XmlElement AppendChild(string name,string _value)
		{
			return AddChild((XmlElement)root,name,_value);
		}
		
		public override string ToString()
		{
			return xdoc.OuterXml;
		}

		//ΪһXmlElementӽڵ㣬ӵӽڵ
		public XmlElement AddChild(XmlElement xe,string sField,string sValue)
		{
			XmlElement xeTemp=xdoc.CreateElement(sField);
			xeTemp.InnerText=sValue;
			xe.AppendChild(xeTemp);
			return xeTemp;
		}

		//ΪһXmlElementӽڵ㣬ӵӽڵ
		protected XmlElement AddChild(XmlElement xe,XmlDocument xd,string sField)
		{
			XmlElement xeTemp=xd.CreateElement(sField);
			xe.AppendChild(xeTemp);
			return xeTemp;
		}

		//Ϊһڵ
		public void AddAttribute(XmlElement xe,string strName,string strValue)
		{
			//жǷ
			string s=GetXaValue(xe.Attributes,strName);
			//Ѿ
			if(s!=null)
			{
				throw new System.Exception("attribute exists");
			}
			XmlAttribute xa=xdoc.CreateAttribute(strName);
			xa.Value=strValue;
			xe.Attributes.Append(xa);
		}

		//Ϊһڵԣϵͳ
		protected void AddAttribute(XmlDocument xdoc,XmlElement xe,string strName,string strValue)
		{
			//жǷ
			string s=GetXaValue(xe.Attributes,strName);
			//Ѿ
			if(s!=null)
			{
				throw new Exception("Error:The attribute '"+strName+"' has been existed!");
			}
			XmlAttribute xa=xdoc.CreateAttribute(strName);
			xa.Value=strValue;
			xe.Attributes.Append(xa);
		}

		//ͨڵҵָĽڵ
		protected XmlNode FindXnByName(XmlNodeList xnl,string strName)
		{
			for(int i=0;i<xnl.Count;i++)
			{
				if(xnl.Item(i).LocalName==strName)return xnl.Item(i);
			}
			return null;
		}

		//ҵָԵֵ
		protected string GetXaValue(XmlAttributeCollection xac,string strName)
		{
			for(int i=0;i<xac.Count;i++)
			{
				if(xac.Item(i).LocalName==strName)return xac.Item(i).Value ;
			}
			return null;
		}

		//ҵָԵֵ
		protected string GetXnValue(XmlNodeList xnl,string strName)
		{
			for(int i=0;i<xnl.Count;i++)
			{
				if(xnl.Item(i).LocalName==strName)return xnl.Item(i).InnerText;
			}
			return null;
		}

		//Ϊһڵֵָ
		protected void SetXnValue(XmlNodeList xnl,string strName,string strValue)
		{
			for(int i=0;i<xnl.Count;i++)
			{
				if(xnl.Item(i).LocalName==strName)
				{
					xnl.Item(i).InnerText=strValue;
					return;
				}
			}
			return;
		}

		//Ϊһֵָ
		protected void SetXaValue(XmlAttributeCollection xac,string strName,string strValue)
		{
			for(int i=0;i<xac.Count;i++)
			{
				if(xac.Item(i).LocalName==strName)
				{
					xac.Item(i).Value=strValue;
					return;
				}
			}
			return;
		}


		//ѰҾָƺ/ֵϵĽڵ
		protected XmlNode FindXnByXa(XmlNodeList xnl,string strXaName,string strXaValue)
		{
			string xa;
			for(int i=0;i<xnl.Count;i++)
			{
				xa=GetXaValue(xnl.Item(i).Attributes,strXaName);
				if(xa!=null)
				{
					if(xa==strXaValue)return xnl.Item(i);
				}
			}
			return null;
		}
	}
}
