﻿
/********************************************
 * 
 * description: 基于 .NET 2.0 
 *              购物车
 * 
 * author:     漠北
 * 
 * blogs:       http://www.mksun.com
 * 
 * Date:        2006-10-8 
 * 
 ********************************************/
using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Configuration.Assemblies;
using MK.BusinessFacade;
using MK.Common;
using MK.DataAccress;


/// <summary>
/// Clas5 的摘要说明
/// </summary>
namespace MK.BusinessRules
{
    

    public class Order
    {
       
        
        public Order()
        {
        }
        public bool InsertOrder(OrderData order, out int orderNum)
        {
            bool flag1 = true;
            orderNum = 0;
            DataRow row1 = order.Tables["tbOrderHead"].Rows[0];
            row1.ClearErrors();
            flag1 &= this.IsValidField(row1, "reciveName", 50);
            flag1 &= this.IsValidField(row1, "Email", 50);
            flag1 &= this.IsValidField(row1, "Phone", 50);
          
            DataRowCollection collection1 = order.Tables["tborder"].Rows;
            float num1 = 0;
            int num2 = 0;
            foreach (DataRow row2 in collection1)
            {
                row2.ClearErrors();
                num1 += (float)row2["CopePrice"];
                num2 += (int)row2["Quantity"];
                if (((float)row2["UnitPrice"]) <= 0)
                {
                    row2.SetColumnError("UintPrice", "Invalid Field");
                    flag1 = false;
                }
                if (((int)row2["Quantity"]) <= 0)
                {
                    row2.SetColumnError("Quantity", "Invalid Field");
                    flag1 = false;
                }
            }
            if (num1 != Convert.ToSingle(row1["TotalPrice"]))
            {
                row1.SetColumnError("TotalPrice", "Invalid Field");
                flag1 = false;
            }
            if (num2 != Convert.ToUInt32(row1["TotalQty"]))
            {
                row1.SetColumnError("TotalQty", "Invalid Field");
                flag1 = false;
            }
            if (flag1)
            {
                using (Orders orders1 = new Orders())
                {
                    orderNum = orders1.InsertOrder(order);
                    return (orderNum != 0);
                }
            }
            return false;
        }

        private bool IsValidField(DataRow OrderRow, string fieldName, short maxLen)
        {
            short num1 = (short)OrderRow[fieldName].ToString().Trim().Length;
            if ((num1 < 1) || (num1 > maxLen))
            {
                OrderRow.SetColumnError(fieldName, "Invalid Field");
                return false;
            }
            return true;
        }




    }
    public class MKConfiguration : IConfigurationSectionHandler
    {
       
        
        private static string dbConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + HttpContext.Current.Server.MapPath(".") + ConfigurationManager.ConnectionStrings["AccessConnstr"].ConnectionString;
        

        public MKConfiguration()
        {
        }

        public object Create(object parent, object configContext, XmlNode section)
        {
            NameValueCollection collection1;
            try
            {
                NameValueSectionHandler handler1 = new NameValueSectionHandler();
                collection1 = (NameValueCollection)handler1.Create(parent, configContext, section);
            }
            catch
            {
                collection1 = null;
            }
            if (collection1 == null)
            {
                MKConfiguration.dbConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + HttpContext.Current.Server.MapPath(".") + ConfigurationManager.ConnectionStrings["AccessConnstr"].ConnectionString;

                return collection1;
            }
            MKConfiguration.dbConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + HttpContext.Current.Server.MapPath(".") + ConfigurationManager.ConnectionStrings["AccessConnstr"].ConnectionString;
            
            return collection1;
        }

        public static string ConnectionString
        {
            get
            {
                return dbConnectionString;
            }
        }



    }
}


