﻿/********************************************
 * 
 * description: 基于 .NET 2.0 
 *              购物车业务逻辑类
 * 
 * author:     漠北
 * 
 * blogs:       http://www.mksun.com
 * 
 * Date:        2006-10-8 
 * 
 ********************************************/
using System;
using System.Web;
using System.Collections;
using System.Data;
using System.Runtime.Serialization;
using System.Security.Permissions;
using MK.DataAccress;
using MK.BusinessRules;
using MK.SystemFramework;


    [Serializable]
    public class Cart : ISerializable
    {

        private const String KEY_ORDERDATA = "Cache:OrderData:";
        private int TmpOrderNum =0;

        //shopping cart data variable
        private OrderData cartOrderData;

        /// <summary>
        ///     Make sure that the cart can actually be written to. 
        ///     <remarks>
        ///         The cart may still be empty at this point, all methods will succeed.
        ///         The cart is initially created without data so that we don't actually 
        ///         create an OrderData until we need to populate it.
        ///     </remarks> 
        /// </summary>
        public void EnsureWritable()
        {
            if (null == cartOrderData)
            {
                cartOrderData = new OrderData();
            }
        }

        /// <summary>
        ///     Constructor for Cart.  
        ///     <remarks>Create a new object. Included to expose default constructor.</remarks> 
        /// </summary>
        public Cart()
        {
        }

        /// <summary>
        ///     Depersist the Cart object from serialized data.
        ///     <remarks>Constructor that supports serialization.</remarks> 
        ///     <remarks>
        ///         This is called by the runtime. It is private so that no
        ///         one else can call it.
        ///     </remarks>
        ///     <param name="info">The SerializationInfo object to read from.</param>
        ///     <param name="context">Information on who is calling this method.</param>
        /// </summary>
        private Cart(SerializationInfo info, StreamingContext context)
        {
            try
            {
                cartOrderData = (MK.DataAccress.OrderData)info.GetValue(KEY_ORDERDATA, typeof(MK.DataAccress.OrderData));
            }
            catch
            {
                // Leave cartOrderData null if it hasn't been serialized
            }
        }


        //----------------------------------------------------------------
        // Sub GetObjectData:
        //   Serialize the cart class.
        // Parameters:
        //   [in] info: The SerializationInfo object to write to
        //   [in] context: Information on who is calling this method
        //----------------------------------------------------------------
        [SecurityPermission(SecurityAction.Demand, SerializationFormatter = true)]
        void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (cartOrderData != null)
            {
                info.AddValue(KEY_ORDERDATA, cartOrderData);
            }
        }
        /// <value>
        ///     Property IsEmpty is used to get whether the cart is empty. 
        ///     <remarks> Returns true if the cart is empty, false otherwise.</remarks>
        /// </value>
        public int OrderNum
        {
            get
            {
                return TmpOrderNum;
            }
        }
        /// <value>
        ///     Property IsEmpty is used to get whether the cart is empty. 
        ///     <remarks> Returns true if the cart is empty, false otherwise.</remarks>
        /// </value>
        public bool IsEmpty
        {
            get
            {
                return (null == cartOrderData) ? true : (0 == OrderItems.Rows.Count);
            }
        }

        /// <summary>
        ///     Adds an Item to the shopping cart.
        ///     <remarks>Constructor that supports serialization.</remarks> 
        ///     <param name="Plucode">The Plucode of a shopping cart item.</param>
        ///     <param name="itemPrice">The Price of a shopping cart item.</param>
        ///     <param name="itemDiscount">The Discount of a shopping cart item.</param>
        /// </summary>
        public void AddItem(int ProductID,string ProductName, float UnitPrice, int Discount, float Weight)
        {
            DataTable itemTable = OrderItems;
            DataView itemSource = new DataView(itemTable);

            //search for item, check to see if the item has already been ordered
            itemSource.RowFilter = "ProductID = '" + ProductID + "'";

            if (itemSource.Count > 0)
            {
                DataRowView sourceRow = itemSource[0];
                int count = (int)(sourceRow[OrderData.QUANTITY_FIELD]);
                int discount = Math.Min(Discount, int.Parse(sourceRow[OrderData.DISCOUNT_FIELD].ToString()));               
                float weight = Math.Min(Discount, Convert.ToSingle(sourceRow[OrderData.WEIGHT_FIELD].ToString()));
                count += 1;
                sourceRow[OrderData.QUANTITY_FIELD] = count;
                sourceRow[OrderData.DISCOUNT_FIELD] = discount;
                        
                sourceRow[OrderData.WEIGHT_FIELD] = weight*count;  
                sourceRow[OrderData.COPE_PRICE_FIELD] = (float)sourceRow[OrderData.PRICE_FIELD] * count;
                sourceRow[OrderData.FACT_PRICE_FIELD] = (float)sourceRow[OrderData.PRICE_FIELD] * count * discount / 100;
                sourceRow[OrderData.PRODUCTNAME_FIELD] = ProductName;
            }
            else
            {

                //It's a new item
                DataRow itemRow = itemTable.NewRow();
                itemRow[OrderData.PRODUCTID_FIELD] = ProductID;
                itemRow[OrderData.QUANTITY_FIELD] = 1;
                itemRow[OrderData.DISCOUNT_FIELD] = Discount;
                itemRow[OrderData.PRICE_FIELD] = UnitPrice;
                itemRow[OrderData.COPE_PRICE_FIELD] = UnitPrice;
                itemRow[OrderData.FACT_PRICE_FIELD] = UnitPrice * Discount / 100;            
                itemRow[OrderData.WEIGHT_FIELD] = Weight;
                itemRow[OrderData.PRODUCTNAME_FIELD] = ProductName;
              
                //Add it to the table
                itemTable.Rows.Add(itemRow);
            }
        }

        /// <summary>
        ///     Updates the Items in the shopping cart.
        /// </summary>
        public void UpdateItems()
        {
            int quantity, discount;
            int itemsCount = OrderItems.Rows.Count;
            DataRow row;

            for (int i = 0; i < itemsCount; i++)
            {
                row = OrderItems.Rows[i];

                quantity = Int32.Parse(row[OrderData.QUANTITY_FIELD].ToString());
                discount = Int32.Parse(row[OrderData.DISCOUNT_FIELD].ToString());
                if (quantity < 1)
                {
                    row.Delete();
                    itemsCount--;
                    i--;
                }
                else
                {
                    row[OrderData.COPE_PRICE_FIELD] = (float)row[OrderData.PRICE_FIELD] * quantity;
                    row[OrderData.FACT_PRICE_FIELD] = (float)row[OrderData.PRICE_FIELD] * quantity * discount / 100;
                    //row[OrderData.TOTALTRAFFIC_FIELD] = (Decimal)row[OrderData.TRAFFIC_FIELD] * quantity*((Decimal)row[OrderData.WEIGHT_FIELD]);
                    //row[OrderData.TOTAL_AMTPRICE_FIELD] = (Decimal)row[OrderData.PRICE_FIELD] * quantity * discount / 100 + (Decimal)row[OrderData.TRAFFIC_FIELD] * quantity * ((Decimal)row[OrderData.WEIGHT_FIELD]);
                }
            }
        }

        /// <summary>
        ///     Removes all items from the cart.
        /// </summary>
        public void RemoveAllItems()
        {
            OrderItems.Rows.Clear();
        }
        /// <summary>
        ///   删除符合参数plucode项
        /// </summary>
        /// <param name="plucode"></param>
        public void DeleteItem(int ProductID)    
        {
            DataTable itemTable = OrderItems;
            DataView itemSource = new DataView(itemTable);

            //search for item, check to see if the item has already been ordered
            itemSource.RowFilter = "ProductID = '" + ProductID + "'";

            if (itemSource.Count > 0)
            {
                itemSource[0].Delete();
            }
            itemTable.AcceptChanges();
        }


        /// <value>
        ///     Property OrderItems is used to get the OrderItems datatable from OrderData.
        ///     <exception> class='System.ApplicationException'>
        ///         The cartOrderData is null.
        ///     </exception>
        /// </value>
        public DataTable OrderItems
        {
            get
            {
                ApplicationAssert.Check(cartOrderData != null, "Don't call if IsEmpty is True", ApplicationAssert.LineNumber);
                return cartOrderData.Tables[OrderData.ORDER_DETAIL_TABLE];
            }
        }

        /// <value>
        ///     Property Order is used to get the Order datatable from OrderData.
        ///     <exception> class='System.ApplicationException'>
        ///         The cartOrderData is null.
        ///     </exception>
        /// </value>
        public DataTable Order
        {
            get
            {
                ApplicationAssert.CheckCondition(cartOrderData != null, "Don't call if IsEmpty is True", ApplicationAssert.LineNumber);
                return cartOrderData.Tables[OrderData.ORDERHEAD_TABLE];
            }
        }
        /// <summary>
        ///     Save a customer's shipping address in the OrderData for there order.
        ///     <remarks>Constructor that supports serialization.</remarks> 
        ///     <param name="shipToName">The name of the person the order will be shipped to.</param>
        ///     <param name="address">The address where the order will be shipped to.</param>
        ///     <param name="country">The country where the order will be shipped..</param>
        ///     <param name="phone">The phone number of the person the order will be shipped to.</param>
        ///     <param name="fax">The fax number of the person the order will be shipped to.  
        ///         This field is optional.
        ///     </param>
        /// </summary>
        public void SetCustomer(String UserID, String RiveceName,String Country, String Address, String PostCode, String Phone, String Email)
        {
            DataTable customerTable = Order;
            customerTable.Rows.Clear();        //clear former address
            DataRow row = customerTable.NewRow();

            row.BeginEdit();
            row[OrderData.USERID_FIELD] = UserID;
            row[OrderData.RECIVENAME_FIELD] = RiveceName;
            row[OrderData.ADDRESS_FIELD] = Address;
            row[OrderData.POSTCODE_FIELD] = PostCode;
            row[OrderData.PHONE_FIELD] = Phone;
            row[OrderData.EMAIL_FIELD] = Email;
            row[OrderData.COUNTRY_FIELD] = Country;
            row.EndEdit();

            customerTable.Rows.Add(row);
            customerTable.AcceptChanges();
        }
      
        public void CalculateOrderSummary(float Traffic)
        {
            ApplicationAssert.Check(cartOrderData != null, "购物车中没有品种，不能调用此方法", ApplicationAssert.LineNumber);


            float TotalPrice = 0, TotalAmtPrice = 0,TotalWeight=0,TotalTraffic=0;
            int TotalQty = 0, TotalProduct = 0;
            foreach (DataRow row in cartOrderData.Tables[OrderData.ORDER_DETAIL_TABLE].Rows)
            {
                TotalProduct += 1;
                TotalQty += Int32.Parse(row[OrderData.QUANTITY_FIELD].ToString());
                TotalAmtPrice +=Convert.ToSingle(row[OrderData.FACT_PRICE_FIELD].ToString());
                TotalPrice += Convert.ToSingle(row[OrderData.COPE_PRICE_FIELD].ToString());
                TotalWeight += Convert.ToSingle(row[OrderData.WEIGHT_FIELD].ToString());               
            }
          
            TotalTraffic = TotalWeight * Traffic;
            TotalAmtPrice += TotalTraffic;
            //
            // Create a new row
            //
            DataTable OrderHeadTable = Order;
            if (OrderHeadTable.Rows.Count == 1)
            {

                DataRow summaryRow = OrderHeadTable.Rows[0];
                summaryRow[OrderData.TOTAL_QTY_FIELD] = TotalQty.ToString();
                summaryRow[OrderData.TOTAL_PRODUCT_FIELD] = TotalProduct.ToString();
                summaryRow[OrderData.TOTAL_PRICE_FIELD] = TotalPrice.ToString();
                summaryRow[OrderData.TOTAL_AMTPRICE_FIELD] = TotalAmtPrice.ToString();
                summaryRow[OrderData.TOTAL_TRAFFIC_FIELD] = TotalTraffic.ToString();
                summaryRow[OrderData.TOTAL_WEIGHT_FIELD] = TotalWeight.ToString();
            }
            else
            {
                DataRow summaryRow = OrderHeadTable.NewRow();
                summaryRow.BeginEdit();
                summaryRow[OrderData.TOTAL_QTY_FIELD] = TotalQty.ToString();
                summaryRow[OrderData.TOTAL_PRODUCT_FIELD] = TotalProduct.ToString();
                summaryRow[OrderData.TOTAL_PRICE_FIELD] = TotalPrice.ToString();
                summaryRow[OrderData.TOTAL_AMTPRICE_FIELD] = TotalAmtPrice.ToString();
                summaryRow[OrderData.TOTAL_TRAFFIC_FIELD] = TotalTraffic.ToString();
                summaryRow[OrderData.TOTAL_WEIGHT_FIELD] = TotalWeight.ToString();
                summaryRow.EndEdit();
                OrderHeadTable.Rows.Add(summaryRow);
            }
            OrderHeadTable.AcceptChanges();
        }
        /// <summary>
        ///     Add the order in OrderData and returns the transaction id.
        ///     <exception> class='System.ApplicationException'>
        ///         The cartOrderData is null.
        ///     </exception>
        /// </summary>
        public void AddOrder()
        {
            ApplicationAssert.CheckCondition(cartOrderData != null, "Order requires data", ApplicationAssert.LineNumber);

            //Write trace log.
            ApplicationLog.WriteTrace("Bayakala.Web.Cart.AddOrder:\r\nCustomer: " + cartOrderData.Tables[OrderData.ORDERHEAD_TABLE].Rows[0][OrderData.USERID_FIELD].ToString());

            OrderSystem orders1 = new OrderSystem();
            
               orders1.AddOrder(cartOrderData, out  TmpOrderNum);
           
         

        }
    } // class Cart

