﻿/********************************************
 * 
 * description: 基于 .NET 2.0 
 *              购物车数据类
 * 
 * author:     漠北
 * 
 * blogs:       http://www.mksun.com
 * 
 * Date:        2006-10-8 
 * 
 ********************************************/
using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Runtime.Serialization;
using System.Diagnostics;
using System.Threading;
using System.Text;
using System.ComponentModel;
using System.Data.OleDb;
using MK.DataAccress;
using MK.BusinessRules;
using MK.SystemFramework;

/// <summary>
/// DataAccress 的摘要说明
/// </summary>
/// 
namespace MK.DataAccress
{

    [Serializable, DesignerCategory("Code")]
    public class OrderData : DataSet
    {
        // Methods
        //public OrderData();
        //private OrderData(SerializationInfo info, StreamingContext context);
        //private void BuildDataTables();

        // Fields
        public const string DISCOUNT_FIELD = "Discount";  //折扣
        public const string ORDER_DETAIL_TABLE = "tborder"; //定单表  
        public const string ORDERDATE_FIELD = "OrderDate"; //下单时间
        public const string ORDERHEAD_TABLE = "tbOrderHead";//定单主表
        public const string ORDERID_FIELD = "OrderID";  //定单号
        public const string PRODUCTID_FIELD = "ProductID";//产品ID
        public const string PRODUCTNAME_FIELD = "ProductName";//产品名称

        public const string PRICE_FIELD = "UnitPrice"; //单价
        public const string QUANTITY_FIELD = "Quantity";//数量
        public const string ADDRESS_FIELD = "address";//收货人地址
        public const string EMAIL_FIELD = "Email";//收货人EMAIL
        public const string RECIVENAME_FIELD = "reciveName";//收货人姓名
        public const string PHONE_FIELD = "phone";//收货人电话
        public const string POSTCODE_FIELD = "postcode";       //邮编
        public const string TOTAL_TRAFFIC_FIELD = "TotalTraffic";       //总运费
        public const string TOTAL_AMTPRICE_FIELD = "TotalAmtPrice";  //总金额+总运费
        public const string TOTAL_PRODUCT_FIELD = "TotalProduct"; //产品总数
        public const string TOTAL_PRICE_FIELD = "TotalPrice"; //打折前的总金额
       
        public const string TOTAL_QTY_FIELD = "TotalQty";//产品数量总和平
        public const string USERID_FIELD = "UserID";//下单人用户ID号

        public const string TOTAL_WEIGHT_FIELD = "TotalWeight";//总重量
        public const string COUNTRY_FIELD = "Country";//国家
        public const string WEIGHT_FIELD = "Weight";//单个产品的重量
         public const string FACT_PRICE_FIELD = "FactPrice";
        public const string COPE_PRICE_FIELD = "CopePrice";//打折前的价格
        public OrderData()
        {
            this.BuildDataTables();
        }
        private OrderData(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }



        private void BuildDataTables()
        {
            DataTable table1 = new DataTable("tborder");
            DataColumnCollection collection1 = table1.Columns;
            collection1.Add("OrderID", typeof(int));
            collection1.Add("ProductID", typeof(int));
            collection1.Add("ProductName",typeof(string));
            collection1.Add("Quantity", typeof(int));
            collection1.Add("UnitPrice", typeof(float));
            collection1.Add("Discount", typeof(int));
            collection1.Add("Weight", typeof(float));
            collection1.Add("CopePrice", typeof(float));
            collection1.Add("FactPrice", typeof(float));
            base.Tables.Add(table1);
            table1 = new DataTable("tbOrderHead");
            collection1 = table1.Columns;

            collection1.Add("OrderID", typeof(int));
            collection1.Add("OrderDate", typeof(DateTime));
            collection1.Add("UserID", typeof(int));
            collection1.Add("TotalPrice", typeof(float));
            collection1.Add("TotalAmtPrice", typeof(float));
            collection1.Add("TotalProduct", typeof(int));
            collection1.Add("TotalQty", typeof(int));
            collection1.Add("ReciveName", typeof(string));
            collection1.Add("Address", typeof(string));
            collection1.Add("PostCode", typeof(string));
            collection1.Add("Phone", typeof(string));
            collection1.Add("Email", typeof(string));
            collection1.Add("TotalTraffic", typeof(float));
            collection1.Add("Country", typeof(string));

            collection1.Add("TotalWeight", typeof(float));

            base.Tables.Add(table1);
        }


    }
    public class Orders : IDisposable
    {
       
     
        private OleDbDataAdapter dsCommand;
        private OleDbConnection connection;

        private const string DISCOUNT_PARM = "@Discount";
        private const string ORDERDATE_PARM = "@OrderDate";
        private const string ORDERID_PARM = "@OrderID";       
        private const string PORDUCTID_PARM = "@ProductID";
        private const string UNITPRICE_PARM = "@UnitPrice";
        private const string QUANTITY_PARM = "@Quantity";
        private const string ADDRESS_PARM = "@Address";
        private const string EMAIL_PARM = "@Email";
        private const string RECEIVE_NAME_PARM = "@ReciveName";
        private const string PHONE_PARM = "@Phone";
        private const string POSTCODE_PARM = "@PostCode";        
        private const string TOTAL_TRAFFIC_PARM = "@TotalTraffic";          
        private const string TOTAL_AMTPRICE_PARM = "@TotalAmtPrice";     
        private const string TOTAL_PRODUCT_PARM = "@TotalProduct";
        private const string TOTAL_PRICE_PARM = "@TotalPrice";
        private const string COPEPRICE_PARM = "@CopePrice";
        private const string FACTPRICE_PARM = "@FactPrice";
        private const string TOTAL_QTY_PARM = "@TotalQty";
        private const string USERID_PARM = "@UserID";
      
        private const string TOTAL_WEIGHT__PARM = "@TotalWeight";
        private const string COUNTRY_PARM = "@Country";


        public Orders()
        {
            this.dsCommand = new OleDbDataAdapter();
            this.dsCommand.TableMappings.Add("tbOrderHead", "tbOrderHead");
            this.dsCommand.TableMappings.Add("tborder", "tborder");
            this.connection = new OleDbConnection(MKConfiguration.ConnectionString);
        }

        public bool DeleteOrder(string orderNum)
        {
        //    if (this.dsCommand == null)
        //    {
        //        throw new ObjectDisposedException(base.GetType().FullName);
        //    }
        //    this.dsCommand.DeleteCommand = this.GetDeleteCommand();
        //    this.dsCommand.DeleteCommand.Parameters["@OrderID"].Value = orderNum;
        //    if (this.dsCommand.DeleteCommand.Connection.State != ConnectionState.Open)
        //    {
        //        this.dsCommand.DeleteCommand.Connection.Open();
        //    }
        //    this.dsCommand.DeleteCommand.ExecuteNonQuery();
            return true;
        }

        public void Dispose()
        {
            this.Dispose(true);
            GC.SuppressFinalize(true);
        }


        protected virtual void Dispose(bool disposing)
        {
            if (disposing && (this.dsCommand != null))
            {
                if (this.dsCommand.SelectCommand != null)
                {
                    if (this.dsCommand.SelectCommand.Connection != null)
                    {
                        this.dsCommand.SelectCommand.Connection.Dispose();
                    }
                    this.dsCommand.SelectCommand.Dispose();
                }
                this.dsCommand.Dispose();
                this.dsCommand = null;
            }
        }


        private OrderData FillOrderHead(string commandText, string paramName, string paramValue, string orderType)
        {
        //    if (this.dsCommand == null)
        //    {
        //        throw new ObjectDisposedException(base.GetType().FullName);
        //    }
            OrderData data1 = new OrderData();
        //    SqlCommand command1 = new SqlCommand(commandText, new SqlConnection(MKConfiguration.ConnectionString));
        //    command1.CommandType = CommandType.StoredProcedure;
        //    SqlParameter parameter1 = new SqlParameter(paramName, SqlDbType.NVarChar, 50);
        //    parameter1.Value = paramValue;
        //    command1.Parameters.Add(parameter1);
        //    if (orderType != "None")
        //    {
        //        parameter1 = new SqlParameter("@OrderType", SqlDbType.VarChar, 10);
        //        parameter1.Value = orderType;
        //        command1.Parameters.Add(parameter1);
        //    }
        //    this.dsCommand.SelectCommand = command1;
        //    this.dsCommand.Fill(data1, "tbOrderHead");
            return data1;
        }


        private SqlCommand GetDeleteCommand()
        {
            SqlCommand command1 = new SqlCommand("sp_DeleteOrder", new SqlConnection(MKConfiguration.ConnectionString));
            command1.CommandType = CommandType.StoredProcedure;
            command1.Parameters.Add(new SqlParameter("@OrderID", SqlDbType.Int));
            return command1;
        }
        private void DeleteOrderDetailByOrderID(int orderNum)
        {
        //    if (this.dsCommand == null)
        //    {
        //        throw new ObjectDisposedException(base.GetType().FullName);
        //    }
        //    this.dsCommand.DeleteCommand = this.GetDeleteDetailCommandByOrderID();
        //    this.dsCommand.DeleteCommand.Parameters["@OrderID"].Value = orderNum;
        //    if (this.dsCommand.DeleteCommand.Connection.State != ConnectionState.Open)
        //    {
        //        this.dsCommand.DeleteCommand.Connection.Open();
        //    }
        //    this.dsCommand.DeleteCommand.ExecuteNonQuery();
        //    return true;

        }

        private SqlCommand GetDeleteDetailCommand()
        {
            SqlCommand command1 = new SqlCommand("sp_DeleteOrderDetail", new SqlConnection(MKConfiguration.ConnectionString));
            command1.CommandType = CommandType.StoredProcedure;
            command1.Parameters.Add(new SqlParameter("@OrderID", SqlDbType.Int));
            command1.Parameters.Add(new SqlParameter("@ProductID", SqlDbType.Int));
            return command1;
        }

        private SqlCommand GetDeleteDetailCommandByOrderID()
        {
            SqlCommand command1 = new SqlCommand("sp_DeleteOrderDetailByOrderID", new SqlConnection(MKConfiguration.ConnectionString));
            command1.CommandType = CommandType.StoredProcedure;
            command1.Parameters.Add(new SqlParameter("@OrderID", SqlDbType.Int));           
            return command1;
        }


        private SqlCommand GetInsertCommand()
        {
            SqlCommand command1 = new SqlCommand("sp_AddOrder", new SqlConnection(MKConfiguration.ConnectionString));
            command1.CommandType = CommandType.StoredProcedure;
            SqlParameterCollection collection1 = command1.Parameters;
            collection1.Add(new SqlParameter("@OrderID", SqlDbType.Int)).Direction = ParameterDirection.Output;
            collection1.Add(new SqlParameter("@UserID", SqlDbType.Int));
            collection1.Add(new SqlParameter("@TotalPrice", SqlDbType.Float));
            collection1.Add(new SqlParameter("@TotalAmtPrice", SqlDbType.Float));
            collection1.Add(new SqlParameter("@TotalProduct", SqlDbType.Int));
            collection1.Add(new SqlParameter("@TotalQty", SqlDbType.Int));
            collection1.Add(new SqlParameter("@ReciveName", SqlDbType.NVarChar, 50));
            collection1.Add(new SqlParameter("@Address", SqlDbType.NVarChar,100));
            collection1.Add(new SqlParameter("@Country", SqlDbType.NVarChar,20));
            collection1.Add(new SqlParameter("@PostCode", SqlDbType.NVarChar, 20));
            collection1.Add(new SqlParameter("@Phone", SqlDbType.NVarChar, 50));
            collection1.Add(new SqlParameter("@Email", SqlDbType.NVarChar, 50));           
            collection1.Add(new SqlParameter("@TotalWeight", SqlDbType.Float));
            collection1.Add(new SqlParameter("@TotalTraffic", SqlDbType.Float));           
            return command1;
        }

        private SqlCommand GetInsertDetailCommand()
        {
            SqlCommand command1 = new SqlCommand("sp_AddOrderDetail", new SqlConnection(MKConfiguration.ConnectionString));
            command1.CommandType = CommandType.StoredProcedure;
            SqlParameterCollection collection1 = command1.Parameters;
            collection1.Add(new SqlParameter("@OrderID", SqlDbType.Int));
            collection1.Add(new SqlParameter("@ProductID", SqlDbType.Int));
            collection1.Add(new SqlParameter("@UnitPrice", SqlDbType.Float));
            collection1.Add(new SqlParameter("@Quantity", SqlDbType.Int));
            collection1.Add(new SqlParameter("@DisCount", SqlDbType.Int));
           
            return command1;
        }


        private SqlCommand GetLoadOrderDetailCommand()
        {
            SqlCommand command1 = new SqlCommand("GetOrderDetailByOrderNum", new SqlConnection(MKConfiguration.ConnectionString));
            command1.CommandType = CommandType.StoredProcedure;
            command1.Parameters.Add(new SqlParameter("@OrderNum", SqlDbType.NVarChar, 50));
            return command1;
        }


        private SqlCommand GetLoadOrderHeadCommand()
        {
            SqlCommand command1 = new SqlCommand("GetOrderHeadByOrderNum", new SqlConnection(MKConfiguration.ConnectionString));
            command1.CommandType = CommandType.StoredProcedure;
            command1.Parameters.Add(new SqlParameter("@OrderNum", SqlDbType.NVarChar, 50));
            return command1;
        }


        private SqlCommand GetLoadVendor()
        {
            SqlCommand command1 = new SqlCommand("GetOrderVendor", new SqlConnection(MKConfiguration.ConnectionString));
            command1.CommandType = CommandType.StoredProcedure;
            command1.Parameters.Add(new SqlParameter("@Vendor", SqlDbType.NVarChar, 50));
            return command1;
        }


        private SqlCommand GetUpdateCommand()
        {
            SqlCommand command1 = new SqlCommand("sp_EditOrder", new SqlConnection(MKConfiguration.ConnectionString));
            command1.CommandType = CommandType.StoredProcedure;
            SqlParameterCollection collection1 = command1.Parameters;
            collection1.Add(new SqlParameter("@OrderID", SqlDbType.Int));
            collection1.Add(new SqlParameter("@ReciveName", SqlDbType.NVarChar, 50));
            collection1.Add(new SqlParameter("@Address", SqlDbType.NVarChar, 100));
            collection1.Add(new SqlParameter("@Country", SqlDbType.NVarChar, 20));
            collection1.Add(new SqlParameter("@PostCode", SqlDbType.NVarChar, 20));
            collection1.Add(new SqlParameter("@Phone", SqlDbType.NVarChar, 50));
            collection1.Add(new SqlParameter("@Email", SqlDbType.NVarChar, 50));     
            return command1;
        }


        private SqlCommand GetUpdateDetailCommand()
        {
            SqlCommand command1 = new SqlCommand("sp_EditOrderDetail", new SqlConnection(MKConfiguration.ConnectionString));
            command1.CommandType = CommandType.StoredProcedure;
            SqlParameterCollection collection1 = command1.Parameters;
            collection1.Add(new SqlParameter("@OrderID", SqlDbType.Int));
            collection1.Add(new SqlParameter("@ProductID", SqlDbType.Int));
            collection1.Add(new SqlParameter("@UnitPrice", SqlDbType.Float));
            collection1.Add(new SqlParameter("@Quantity", SqlDbType.Int));
            collection1.Add(new SqlParameter("@DisCount", SqlDbType.Int));
            return command1;
        }


        public int InsertOrder(OrderData order)
        {
            int OrderID;
            DataRow row1;
            if (this.dsCommand == null)
            {
                throw new ObjectDisposedException(base.GetType().FullName);
            }
            DataTable table1 = order.Tables["tborder"];
            DataRowCollection collection1 = table1.Rows;
            int totalProduct = collection1.Count;
          
            row1 = order.Tables["tbOrderHead"].Rows[0];
            string strSql = "INSERT INTO [Ke_Orders]( [UserID],phone,[Address],[Country],[postCode],[ReceiveName],[Email],[TotalPrice], [TotalAmtPrice],[TotalQty],[TotalProduct],[TotalTraffic],[TotalWeight])VALUES("+row1["UserID"]+",'"+row1["phone"]+"','"+ row1["Address"]+"','"+row1["Country"]+"','"+row1["postCode"]+"','"+row1["ReciveName"]+"','"+row1["Email"]+"',"+ row1["TotalPrice"]+","+ row1["TotalAmtPrice"]+","+ row1["TotalQty"]+","+row1["TotalProduct"]+","+ row1["TotalTraffic"]+","+ row1["TotalWeight"]+")";
            OleDbCommand command = new OleDbCommand(strSql, connection);
            this.dsCommand.InsertCommand = command;  
            this.dsCommand.InsertCommand.CommandType = CommandType.Text;
               
            if (this.dsCommand.InsertCommand.Connection.State != ConnectionState.Open)
            {
                this.dsCommand.InsertCommand.Connection.Open();
            }
           this.dsCommand.InsertCommand.ExecuteNonQuery();

            //this.dsCommand.Update(order, "tborder");
            strSql = "select top 1 orderid from Ke_Orders order by orderid desc";
            OleDbCommand command2 = new OleDbCommand(strSql, connection);
            if (command2.Connection.State == ConnectionState.Closed)
            {
                command2.Connection.Open();
            }
            string i = command2.ExecuteScalar().ToString();          
            OrderID = Int32.Parse(i);

            
            int ProductID, Quantity,Discount;
            float UnitPrice;         
           
            for (int num1 = 0; num1 < totalProduct; num1++)
            {
                row1 = collection1[num1];
                ProductID =(Int32) row1["ProductID"];
                Quantity =(Int32) row1["Quantity"];
                UnitPrice=Convert.ToSingle(row1["UnitPrice"]);
                Discount =(Int32) row1["Discount"];
                strSql = " INSERT INTO [Ke_OrderDetail] ( [OrderID], [ProductID], [UnitPrice],[Quantity],[Discount])VALUES (" + OrderID + "," + ProductID + "," + UnitPrice + "," + Quantity + "," + Discount + ")";
                this.dsCommand.InsertCommand = command;
                this.dsCommand.InsertCommand.CommandText = strSql;
                this.dsCommand.InsertCommand.CommandType = CommandType.Text;
                this.dsCommand.InsertCommand.Connection = connection;
                if (this.dsCommand.InsertCommand.Connection.State != ConnectionState.Open)
                    {
                        this.dsCommand.InsertCommand.Connection.Open();
                    }
                this.dsCommand.InsertCommand.ExecuteNonQuery();
                
            }
            return OrderID;
        }
	

       public OrderData LoadOrderDetailByOrderNum(string orderNum)
        {
       //     if (this.dsCommand == null)
       //     {
       //         throw new ObjectDisposedException(base.GetType().FullName);
       //     }
            OrderData data1 = new OrderData();
       //     this.dsCommand.SelectCommand = this.GetLoadOrderDetailCommand();
       //     this.dsCommand.SelectCommand.Parameters["@OrderNum"].Value = orderNum;
       //     this.dsCommand.Fill(data1, "tborder");
       //     if (data1.Tables["tborder"].Rows.Count == 0)
       //     {
       //         return null;
       //     }
       //     this.dsCommand.SelectCommand = this.GetLoadOrderHeadCommand();
       //     this.dsCommand.SelectCommand.Parameters["@OrderNum"].Value = orderNum;
       //     this.dsCommand.Fill(data1, "tbOrderHead");
       //     if (data1.Tables["tbOrderHead"].Rows.Count == 0)
       //     {
       //         return null;
            //}
            return data1;
        }


        public OrderData LoadOrderHeadByOrderNum(string orderNum)
        {
            return this.FillOrderHead("GetOrderHeadByOrderNum", "@OrderNum", orderNum, "None");
        }


        public OrderData LoadOrderHeadByOrderSTS(string orderSts, string orderType)
        {
            return this.FillOrderHead("GetOrderHeadBySTS", "@Status", orderSts, orderType);
        }


        public OrderData LoadOrderHeadByUserCode(string userCode)
        {
            return this.FillOrderHead("GetOrderHeadByUserCode", "@UserID", userCode, "None");
        }


        public DataTable LoadVendorByVendorCode(string vendoeCode)
        {
            //if (this.dsCommand == null)
            //{
            //    throw new ObjectDisposedException(base.GetType().FullName);
            //}
            DataTable table1 = new DataTable();
            //this.dsCommand.SelectCommand = this.GetLoadVendor();
            //this.dsCommand.SelectCommand.Parameters["@Vendor"].Value = vendoeCode;
            //this.dsCommand.Fill(table1);
            return table1;
        }


        public bool UpdateOrderHead(string updateMode, OrderData order)
        {
            //if (this.dsCommand == null)
            //{
            //    throw new ObjectDisposedException(base.GetType().FullName);
            //}
            //this.dsCommand.UpdateCommand = this.GetUpdateCommand();
            //DataRow row1 = order.Tables["tbOrderHead"].Rows[0];
            //this.dsCommand.UpdateCommand.Parameters["@UpdateMode"].Value = updateMode;
            //this.dsCommand.UpdateCommand.Parameters["@OrderNum"].Value = row1["OrderNum"];
            //this.dsCommand.UpdateCommand.Parameters["@Status"].Value = row1["Status"];
            //this.dsCommand.UpdateCommand.Parameters["@Vendor"].Value = row1["Vendor"];
            //this.dsCommand.UpdateCommand.Parameters["@RecName"].Value = row1["recName"];
            //this.dsCommand.UpdateCommand.Parameters["@RecAddress"].Value = row1["recaddress"];
            //this.dsCommand.UpdateCommand.Parameters["@RecZip"].Value = row1["recZip"];
            //this.dsCommand.UpdateCommand.Parameters["@RecTel"].Value = row1["recTel"];
            //this.dsCommand.UpdateCommand.Parameters["@RecEmail"].Value = row1["recEmail"];
            //this.dsCommand.UpdateCommand.Parameters["@Remark"].Value = row1["Remark"];
            //if (this.dsCommand.UpdateCommand.Connection.State != ConnectionState.Open)
            //{
            //    this.dsCommand.UpdateCommand.Connection.Open();
            //}
            //this.dsCommand.UpdateCommand.ExecuteNonQuery();
            return true;
        }

    }
    public class OrderSystem : MarshalByRefObject
    {
       
        public OrderSystem()
        {

        }
        public bool AddOrder(OrderData order, out int ordernum)
        {
            ordernum = 0;
            ApplicationAssert.CheckCondition(order != null, "Order is required", ApplicationAssert.LineNumber);
            Order orders1 = new Order();

            return orders1.InsertOrder(order, out ordernum);


        }
        public bool DeleteOrder(string orderNum)
        {
            ApplicationAssert.CheckCondition(orderNum != string.Empty, "ordernum is required", ApplicationAssert.LineNumber);
            using (Orders orders1 = new Orders())
            {
                return orders1.DeleteOrder(orderNum);
            }
        }
        public OrderData GetOrderDetailByOrderNum(string PorderNum)
        {
            ApplicationAssert.CheckCondition(PorderNum != string.Empty, "Invalid OrderNum", ApplicationAssert.LineNumber);
            using (Orders orders1 = new Orders())
            {
                return orders1.LoadOrderDetailByOrderNum(PorderNum);
            }
        }
        public OrderData GetOrderHeadByOrderNum(string PorderNum)
        {
            ApplicationAssert.CheckCondition(PorderNum != string.Empty, "Invalid OrderNum", ApplicationAssert.LineNumber);
            using (Orders orders1 = new Orders())
            {
                return orders1.LoadOrderHeadByOrderNum(PorderNum);
            }
        }
        public OrderData GetOrderHeadBySTS(string orderSts, string orderType)
        {
            ApplicationAssert.CheckCondition(orderSts != string.Empty, "Invalid OrderStatus", ApplicationAssert.LineNumber);
            ApplicationAssert.CheckCondition(orderType != string.Empty, "Invalid OrderType", ApplicationAssert.LineNumber);
            using (Orders orders1 = new Orders())
            {
                return orders1.LoadOrderHeadByOrderSTS(orderSts, orderType);
            }
        }
        public OrderData GetOrderHeadByUserID(string PuserID)
        {
            ApplicationAssert.CheckCondition(PuserID != string.Empty, "Invalid UserID", ApplicationAssert.LineNumber);
            using (Orders orders1 = new Orders())
            {
                return orders1.LoadOrderHeadByUserCode(PuserID);
            }
        }
        public DataTable GetVendor(string vendorCode)
        {
            using (Orders orders1 = new Orders())
            {
                return orders1.LoadVendorByVendorCode(vendorCode);
            }
        }

        public bool UpdateOrder(string updateMode, OrderData updateOrder)
        {
            ApplicationAssert.CheckCondition(updateOrder != null, "OrderData is required", ApplicationAssert.LineNumber);
            using (Orders orders1 = new Orders())
            {
                return orders1.UpdateOrderHead(updateMode, updateOrder);
            }
        }
    }

}
