﻿/********************************************
 * 
 * description: 基于 .NET 2.0 
 *              购物车
 * 
 * author:     漠北
 * 
 * blogs:       http://www.mksun.com
 * 
 * Date:        2006-10-8 
 * 
 ********************************************/
using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.Collections.Specialized;
using MK.BusinessRules;
using MK.BusinessFacade;
using MK.SystemFramework;
namespace MK.Common
{
    public class MKConfiguration : IConfigurationSectionHandler
    {
     
        private static string bookImagePath;
        private const string DATAACCESS_CONNECTIONSTRING = "MK.DataAccess.ConnectionString";
        private const string DATAACCESS_CONNECTIONSTRING_DEFAULT = "server=127.0.0.1; User ID=sa;database=szbook";
        private static string dbConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source="+HttpContext.Current.Server.MapPath("/")+ConfigurationManager.ConnectionStrings["AccessConnstr"].ConnectionString;

        private static bool enablePageCache;
        private static bool enableSsl;
        private static string infoDataPath;
        private static string otherImagePath;
        private static int pageCacheExpiresInSeconds;
        private const string WEB_BOOKIMAGEPATH = "MK.Web.BookImagePath";
        private const string WEB_ENABLEPAGECACHE = "MK.Web.EnablePageCache";
        private const bool WEB_ENABLEPAGECACHE_DEFAULT = true;
        private const string WEB_ENABLESSL = "MK.Web.EnableSsl";
        private const bool WEB_ENABLESSL_DEFAULT = false;
        private const string WEB_INFODATAPATH = "MK.Web.InfoDataPath";
        private const string WEB_OTHERIMAGEPATH = "MK.Web.OtherImagePath";
        private const string WEB_PAGECACHEEXPIRESINSECONDS = "MK.Web.PageCacheExpiresInSeconds";
        private const int WEB_PAGECACHEEXPIRESINSECONDS_DEFAULT = 0xe10;

        public MKConfiguration()
        {
        }

        public object Create(object parent, object configContext, XmlNode section)
        {
            NameValueCollection collection1;
            try
            {
                NameValueSectionHandler handler1 = new NameValueSectionHandler();
                collection1 = (NameValueCollection)handler1.Create(parent, configContext, section);
            }
            catch
            {
                collection1 = null;
            }
            if (collection1 == null)
            {
                MKConfiguration.dbConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + HttpContext.Current.Server.MapPath("/") + ConfigurationManager.ConnectionStrings["AccessConnstr"].ConnectionString;
                MKConfiguration.pageCacheExpiresInSeconds = 0xe10;
                MKConfiguration.enablePageCache = true;
                MKConfiguration.enableSsl = false;
                MKConfiguration.bookImagePath = "";
                MKConfiguration.infoDataPath = "";
                MKConfiguration.otherImagePath = "";
                return collection1;
            }
            MKConfiguration.dbConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + HttpContext.Current.Server.MapPath("/") + ConfigurationManager.ConnectionStrings["AccessConnstr"].ConnectionString;
            MKConfiguration.pageCacheExpiresInSeconds = ApplicationConfiguration.ReadSetting(collection1, "MK.Web.PageCacheExpiresInSeconds", 0xe10);
            MKConfiguration.enablePageCache = ApplicationConfiguration.ReadSetting(collection1, "MK.Web.EnablePageCache", true);
            MKConfiguration.enableSsl = ApplicationConfiguration.ReadSetting(collection1, "MK.Web.EnableSsl", false);
            MKConfiguration.bookImagePath = ApplicationConfiguration.ReadSetting(collection1, "MK.Web.BookImagePath", "Default");
            MKConfiguration.infoDataPath = ApplicationConfiguration.ReadSetting(collection1, "MK.Web.InfoDataPath", "Default");
            MKConfiguration.otherImagePath = ApplicationConfiguration.ReadSetting(collection1, "MK.Web.OtherImagePath", "Default");
            return collection1;
        }

        public static string ConnectionString
        {
            get
            {
                return MKConfiguration.dbConnectionString;
            }
        }
        


    }
}

