﻿/********************************************
 * 
 * description: 基于 .NET 2.0 
 *              购物车
 * 
 * author:     漠北
 * 
 * blogs:       http://www.mksun.com
 * 
 * Date:        2006-10-8 
 * 
 ********************************************/
using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MK.SystemFramework;
using MK.Common;
using MK.DataAccress;
using MK.BusinessRules;
namespace MK.BusinessFacade
{

    /// <summary>
    /// Class1 的摘要说明
    /// </summary>
    
   
    public class OrderSystem : MarshalByRefObject
    {
      
        public OrderSystem()
        { 
        
        }
        public bool AddOrder(MK.DataAccress.OrderData order, out int ordernum)
        {
            ordernum = 0;
            ApplicationAssert.CheckCondition(order != null, "Order is required", ApplicationAssert.LineNumber);
            Order orders1 = new Order();
           
            return orders1.InsertOrder(order,out ordernum);
            
           
        }
        public bool DeleteOrder(string orderNum)
        {
            ApplicationAssert.CheckCondition(orderNum != string.Empty, "ordernum is required", ApplicationAssert.LineNumber);
            using (Orders orders1 = new Orders())
            {
                return orders1.DeleteOrder(orderNum);
            }
        }
        public MK.DataAccress.OrderData GetOrderDetailByOrderNum(string PorderNum)
        {
            ApplicationAssert.CheckCondition(PorderNum != string.Empty, "Invalid OrderNum", ApplicationAssert.LineNumber);
            using (Orders orders1 = new Orders())
            {
                return orders1.LoadOrderDetailByOrderNum(PorderNum);
            }
        }
        public MK.DataAccress.OrderData GetOrderHeadByOrderNum(string PorderNum)
        {
            ApplicationAssert.CheckCondition(PorderNum != string.Empty, "Invalid OrderNum", ApplicationAssert.LineNumber);
            using (Orders orders1 = new Orders())
            {
                return orders1.LoadOrderHeadByOrderNum(PorderNum);
            }
        }
        public MK.DataAccress.OrderData GetOrderHeadBySTS(string orderSts, string orderType)
        {
            ApplicationAssert.CheckCondition(orderSts != string.Empty, "Invalid OrderStatus", ApplicationAssert.LineNumber);
            ApplicationAssert.CheckCondition(orderType != string.Empty, "Invalid OrderType", ApplicationAssert.LineNumber);
            using (Orders orders1 = new Orders())
            {
                return orders1.LoadOrderHeadByOrderSTS(orderSts, orderType);
            }
        }
        public MK.DataAccress.OrderData GetOrderHeadByUserID(string PuserID)
        {
            ApplicationAssert.CheckCondition(PuserID != string.Empty, "Invalid UserID", ApplicationAssert.LineNumber);
            using (Orders orders1 = new Orders())
            {
                return orders1.LoadOrderHeadByUserCode(PuserID);
            }
        }
        public DataTable GetVendor(string vendorCode)
        {
            using (Orders orders1 = new Orders())
            {
                return orders1.LoadVendorByVendorCode(vendorCode);
            }
        }

        public bool UpdateOrder(string updateMode, MK.DataAccress.OrderData updateOrder)
        {
            ApplicationAssert.CheckCondition(updateOrder != null, "OrderData is required", ApplicationAssert.LineNumber);
            using (Orders orders1 = new Orders())
            {
                return orders1.UpdateOrderHead(updateMode, updateOrder);
            }
        }

    }

}
