﻿/********************************************
 * 
 * description: 基于 .NET 2.0 
 *              购物车
 * 
 * author:     漠北
 * 
 * blogs:       http://www.mksun.com
 * 
 * Date:        2006-10-8 
 * 
 ********************************************/
using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using MK.DataAccress;
using MK.BusinessRules;
using MK.SystemFramework;
/// <summary>
/// PageBase 的摘要说明
/// </summary>
    public class PageBase : Page
    {
        private const string KEY_CACHECART = "Cache:ShoppingCart:";
        private const string KEY_CACHECUSTOMER = "Cache:Customer:";
        private const string UNHANDLED_EXCEPTION = "Unhandled Exception:";

        public PageBase()
        {
        }



        protected override void OnError(EventArgs e)
        {
            //ApplicationLog.WriteError(ApplicationLog.FormatException(base.Server.GetLastError(), "Unhandled Exception:"));
            //base.OnError(e);
        }

        public Cart ShoppingCart()
        {
            return this.ShoppingCart(true);
        }

        public Cart ShoppingCart(bool forceCreate)
        {
            Cart cart1 = (Cart)this.Session["Cache:ShoppingCart:"];
            if (cart1 == null)
            {
                cart1 = new Cart();
                this.Session.Add("Cache:ShoppingCart:", cart1);
            }
            if (forceCreate)
            {
                cart1.EnsureWritable();
            }
            return cart1;
        }

        public string ShowOrderStatus(int orderStatus)
        {
            switch (orderStatus)
            {
                case 0:
                    return "\u62a5\u8ba2";

                case 1:
                    return "\u786e\u8ba4";

                case 2:
                    return "\u914d\u8d27";

                case 3:
                    return "\u914d\u8d27\u5b8c\u6210";

                case 4:
                    return "\u53d1\u8d27";

                case 5:
                    return "\u9500\u552e";

                case 9:
                    return "\u64a4\u9500";
            }
            return "\u672a\u5b9a\u4e49";
        }


        public string ShowOrderSts(int orderSts)
        {
            switch (orderSts)
            {
                case 0:
                    return "\u62a5\u8ba2";

                case 1:
                    return "\u786e\u8ba4";

                case 2:
                    return "\u914d\u8d27";

                case 3:
                    return "\u914d\u8d27\u5b8c\u6210";

                case 4:
                    return "\u53d1\u8d27";

                case 5:
                    return "\u9500\u552e";

                case 9:
                    return "\u64a4\u9500";
            }
            return "\u672a\u5b9a\u4e49";
        }


        public string ShowSendType(string sendTypeValue)
        {
            switch (sendTypeValue)
            {
                case "1":
                    return "\u90ae\u5bc4";

                case "2":
                    return "\u9001\u8d27\u4e0a\u95e8";

                case "3":
                    return "\u5230\u5e97\u53d6\u8d27";
            }
            return "\u672a\u5b9a\u4e49";
        }


        public DataSet Customer
        {
            get
            {
                try
                {
                    return (DataSet)this.Session["Cache:Customer:"];
                }
                catch
                {
                    return null;
                }
            }
            set
            {
                if (value == null)
                {
                    this.Session.Remove("Cache:Customer:");
                }
                else
                {
                    this.Session["Cache:Customer:"] = value;
                }
            }
        }

        public static int Discount
        {
            get
            {
                return 0x62;
            }
        }






    }
	

