﻿/********************************************
 * 
 * description: 基于 .NET 2.0 
 *              购物车
 * 
 * author:     漠北
 * 
 * blogs:       http://www.mksun.com
 * 
 * Date:        2006-10-8 
 * 
 ********************************************/
using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.Runtime;
using Microsoft.Win32;
using System.Threading;
using System.IO;
using System.Globalization;
using System.Runtime.Remoting;
using System.Net;
using System.Collections;
using System.Configuration.Assemblies;
using System.Diagnostics;
using System.Diagnostics.SymbolStore;
using System.Text;
using System.Collections.Generic;
using System.ComponentModel;
using System.Collections.Specialized;

namespace MK.SystemFramework
{
    public class ApplicationAssert
    {
       
        public ApplicationAssert()
        {
        }


        [Conditional("DEBUG")]
        public static void Check(bool condition, string errorText, int lineNumber)
        {
            if (!condition)
            {
                string text1 = string.Empty;
                ApplicationAssert.GenerateStackTrace(lineNumber, out text1);
                StringBuilder builder1 = new StringBuilder();
                builder1.Append("Assert: ").Append("\r\n").Append(errorText).Append("\r\n").Append(text1);
                ApplicationLog.WriteWarning(builder1.ToString());
                Debug.Fail(errorText, text1);
            }
        }

        public static void CheckCondition(bool condition, string errorText, int lineNumber)
        {
            if (!condition)
            {
                string text1;
                ApplicationAssert.GenerateStackTrace(lineNumber, out text1);
                Debug.Fail(errorText, text1);
                throw new ApplicationException(errorText);
            }
        }

       //[Conditional("DEBUG")]
        private static void GenerateStackTrace(int lineNumber, out string currentTrace)
        {
            currentTrace = string.Empty;
            StreamReader reader1 = null;
            bool flag1 = false;
            StringBuilder builder1 = new StringBuilder();
            try
            {
                StackTrace trace1 = new StackTrace(2, true);
                try
                {
                    string text1;
                    int num1;
                    StackFrame frame1 = trace1.GetFrame(0);
                    if ((string.Empty != (text1 = frame1.GetFileName())) && (0 <= (num1 = (lineNumber != 0) ? lineNumber : frame1.GetFileLineNumber())))
                    {
                        string text2;
                        builder1.Append(text1).Append(", Line: ").Append(num1);
                        reader1 = new StreamReader(text1);
                        flag1 = true;
                        do
                        {
                            text2 = reader1.ReadLine();
                            num1--;
                        }
                        while (num1 != 0);
                        builder1.Append("\r\n");
                        if (lineNumber != 0)
                        {
                            builder1.Append("Current executable line:");
                        }
                        else
                        {
                            builder1.Append("\r\n").Append("Next executable line:");
                        }
                        builder1.Append("\r\n").Append(text2.Trim());
                    }
                }
                catch
                {
                }
                finally
                {
                    if (flag1)
                    {
                        reader1.Close();
                    }
                }
                currentTrace = builder1.ToString();
            }
            catch
            {
            }
        }

        public static int LineNumber
        {
            get
            {
                try
                {
                    return new StackTrace(1, true).GetFrame(0).GetFileLineNumber();
                }
                catch
                {
                }
                return 0;
            }
        }

    }

    public class ApplicationConfiguration : IConfigurationSectionHandler
    {
       
        private static string appRoot;
        private const string EVENTLOG_ENABLED = "SystemFramework.EventLog.Enabled";
        private const bool EVENTLOG_ENABLED_DEFAULT = true;
        private const string EVENTLOG_MACHINENAME = "SystemFramework.EventLog.Machine";
        private const string EVENTLOG_MACHINENAME_DEFAULT = ".";
        private const string EVENTLOG_SOURCENAME = "SystemFramework.EventLog.SourceName";
        private const string EVENTLOG_SOURCENAME_DEFAULT = "WebApplication";
        private const string EVENTLOG_TRACELEVEL = "SystemFramework.EventLog.LogLevel";
        //private const TraceLevel EVENTLOG_TRACELEVEL_DEFAULT=1;//1
        private static string eventLogMachineName;
        private static string eventLogSourceName;
        private static bool eventLogEnabled;
        private static TraceLevel eventLogTraceLevel;
        private const string TRACING_ENABLED = "SystemFramework.Tracing.Enabled";
        private const bool TRACING_ENABLED_DEFAULT = true;
        private const string TRACING_SWITCHDESCRIPTION = "SystemFramework.Tracing.SwitchDescription";
        private const string TRACING_SWITCHDESCRIPTION_DEFAULT = "Application error and tracing information";
        private const string TRACING_SWITCHNAME = "SystemFramework.Tracing.SwitchName";
        private const string TRACING_SWITCHNAME_DEFAULT = "ApplicationTraceSwitch";
        private const string TRACING_TRACEFILE = "SystemFramework.Tracing.TraceFile";
        private const string TRACING_TRACEFILE_DEFAULT = "ApplicationTrace.txt";
        private const string TRACING_TRACELEVEL = "SystemFramework.Tracing.TraceLevel";
        //private const TraceLevel TRACING_TRACELEVEL_DEFAULT=4;//4
        private static bool tracingEnabled;
        private static string tracingSwitchDescription;
        private static string tracingSwitchName;
        private static string tracingTraceFile;
        private static TraceLevel tracingTraceLevel;

        public ApplicationConfiguration()
        {
        }

        public object Create(object parent, object configContext, XmlNode section)
        {
            NameValueCollection collection1;
            try
            {
                NameValueSectionHandler handler1 = new NameValueSectionHandler();
                collection1 = (NameValueCollection)handler1.Create(parent, configContext, section);
            }
            catch
            {
                collection1 = null;
            }
            if (collection1 == null)
            {
                ApplicationConfiguration.tracingEnabled = true;
                ApplicationConfiguration.tracingTraceFile = "ApplicationTrace.txt";
                ApplicationConfiguration.tracingTraceLevel = TraceLevel.Verbose;
                ApplicationConfiguration.tracingSwitchName = "ApplicationTraceSwitch";
                ApplicationConfiguration.tracingSwitchDescription = "Application error and tracing information";
                ApplicationConfiguration.eventLogEnabled = true;
                ApplicationConfiguration.eventLogMachineName = ".";
                ApplicationConfiguration.eventLogSourceName = "WebApplication";
                ApplicationConfiguration.eventLogTraceLevel = TraceLevel.Error;
            }
            else
            {
                ApplicationConfiguration.tracingEnabled = ApplicationConfiguration.ReadSetting(collection1, "SystemFramework.Tracing.Enabled", true);
                ApplicationConfiguration.tracingTraceFile = ApplicationConfiguration.ReadSetting(collection1, "SystemFramework.Tracing.TraceFile", "ApplicationTrace.txt");
                ApplicationConfiguration.tracingTraceLevel = ApplicationConfiguration.ReadSetting(collection1, "SystemFramework.Tracing.TraceLevel", TraceLevel.Verbose);
                ApplicationConfiguration.tracingSwitchName = ApplicationConfiguration.ReadSetting(collection1, "SystemFramework.Tracing.SwitchName", "ApplicationTraceSwitch");
                ApplicationConfiguration.tracingSwitchDescription = ApplicationConfiguration.ReadSetting(collection1, "SystemFramework.Tracing.SwitchDescription", "Application error and tracing information");
                ApplicationConfiguration.eventLogEnabled = ApplicationConfiguration.ReadSetting(collection1, "SystemFramework.EventLog.Enabled", true);
                ApplicationConfiguration.eventLogMachineName = ApplicationConfiguration.ReadSetting(collection1, "SystemFramework.EventLog.Machine", ".");
                ApplicationConfiguration.eventLogSourceName = ApplicationConfiguration.ReadSetting(collection1, "SystemFramework.EventLog.SourceName", "WebApplication");
                ApplicationConfiguration.eventLogTraceLevel = ApplicationConfiguration.ReadSetting(collection1, "SystemFramework.EventLog.LogLevel", TraceLevel.Error);
            }
            return null;
        }
        public static void OnApplicationStart(string myAppPath)
        {
            ApplicationConfiguration.appRoot = myAppPath;
            ConfigurationManager.GetSection("ApplicationConfiguration");
            ConfigurationManager.GetSection("BayakalaConfiguration");
            ConfigurationManager.GetSection("SourceViewer");
            
        }

        public static bool ReadSetting(NameValueCollection settings, string key, bool defaultValue)
        {
            try
            {
                object obj1 = settings[key];
                return ((obj1 == null) ? defaultValue : Convert.ToBoolean((string)obj1));
            }
            catch
            {
                return defaultValue;
            }
        }

        public static TraceLevel ReadSetting(NameValueCollection settings, string key, TraceLevel defaultValue)
        {
            try
            {
                object obj1 =settings[key];
                return (obj1 == null) ? defaultValue :(TraceLevel)obj1;
            }
            catch
            {
                return defaultValue;
            }
        }


        public static int ReadSetting(NameValueCollection settings, string key, int defaultValue)
        {
            try
            {
                object obj1 = settings[key];
                return ((obj1 == null) ? defaultValue : Convert.ToInt32((string)obj1));
            }
            catch
            {
                return defaultValue;
            }
        }


        public static string ReadSetting(NameValueCollection settings, string key, string defaultValue)
        {
            try
            {
                object obj1 = settings[key];
                return ((obj1 == null) ? defaultValue : ((string)obj1));
            }
            catch
            {
                return defaultValue;
            }
        }


        public static string get_AppRoot()
        {
            return ApplicationConfiguration.appRoot;
        }

       


        public static bool get_EventLogEnabled()
        {
            return ApplicationConfiguration.eventLogEnabled;
        }

       
        public static string get_EventLogMachineName()
        {
            return ApplicationConfiguration.eventLogMachineName;
        }

        public static string get_EventLogSourceName()
        {
            return ApplicationConfiguration.eventLogSourceName;
        }


        public static TraceLevel get_EventLogTraceLevel()
        {
            return ApplicationConfiguration.eventLogTraceLevel;
        }


        public static bool TracingEnabled
        {
            get
            {
                return ApplicationConfiguration.tracingEnabled;
            }
        }

        //public static string get_TracingSwitchDescription()
        //{
        //    return ApplicationConfiguration.tracingSwitchDescription;
        //}

        public static string TracingSwitchName
        {
            get
            {
                return ApplicationConfiguration.tracingSwitchName;
            }
        }
        public static string TracingTraceFile
        {
            get
            {
                return ApplicationConfiguration.tracingTraceFile;
            }
        }

        public static TraceLevel TracingTraceLevel
        {
            get
            {
                return ApplicationConfiguration.tracingTraceLevel;
            }
        }
        public static string TracingSwitchDescription
        {
            get
            {
                return ApplicationConfiguration.tracingSwitchDescription;
            }
        }


    }

    public class ApplicationLog
    {
        
        private static TraceSwitch debugSwitch;
        private static StreamWriter debugWriter;
        private static TraceLevel eventLogTraceLevel;

        static ApplicationLog()
        {
            Type type1 = typeof(ApplicationLog);
            try
            {
                if (!Monitor.TryEnter(type1))
                {
                    Monitor.Enter(type1);
                }
                else
                {
                    bool flag1 = true;
                    try
                    {
                        if (ApplicationConfiguration.TracingEnabled)
                        {
                            string text1 = ApplicationConfiguration.TracingTraceFile;
                            if (text1 != string.Empty)
                            {
                                string text2 = ApplicationConfiguration.TracingSwitchName;
                                if (text2 != string.Empty)
                                {
                                    FileInfo info1 = new FileInfo(text1);
                                    ApplicationLog.debugWriter = new StreamWriter(info1.Open(FileMode.Append, FileAccess.Write, FileShare.ReadWrite));
                                    Debug.Listeners.Add(new TextWriterTraceListener(ApplicationLog.debugWriter));
                                    ApplicationLog.debugSwitch = new TraceSwitch(text2, ApplicationConfiguration.TracingSwitchDescription);
                                    ApplicationLog.debugSwitch.Level = ApplicationConfiguration.TracingTraceLevel;
                                }
                                flag1 = false;
                            }
                        }
                    }
                    catch
                    {
                    }
                    if (flag1)
                    {
                        ApplicationLog.debugSwitch = null;
                        ApplicationLog.debugWriter = null;
                    }
                    if (ApplicationConfiguration.get_EventLogEnabled())
                    {
                        ApplicationLog.eventLogTraceLevel = ApplicationConfiguration.get_EventLogTraceLevel();
                    }
                    else
                    {
                        ApplicationLog.eventLogTraceLevel = TraceLevel.Off;
                    }
                }
            }
            finally
            {
                Monitor.Exit(type1);
            }
        }
        public ApplicationLog()
        {
        }

        public static string FormatException(Exception ex, string catchInfo)
        {
            StringBuilder builder1 = new StringBuilder();
            if (catchInfo != string.Empty)
            {
                builder1.Append(catchInfo).Append("\r\n");
            }
            builder1.Append(ex.Message).Append("\r\n").Append(ex.StackTrace);
            return builder1.ToString();
        }

        public static void WriteError(string message)
        {
            ApplicationLog.WriteLog(TraceLevel.Error, message);
        }

        public static void WriteInfo(string message)
        {
            ApplicationLog.WriteLog(TraceLevel.Info, message);
        }


        private static void WriteLog(TraceLevel level, string messageText)
        {
            try
            {
                if ((ApplicationLog.debugWriter != null) && (level <= ApplicationLog.debugSwitch.Level))
                {
                    lock (ApplicationLog.debugWriter)
                    {
                        Debug.WriteLine(messageText);
                        ApplicationLog.debugWriter.Flush();
                    }
                }
                if (level <= ApplicationLog.eventLogTraceLevel)
                {
                    EventLogEntryType type1;
                    switch (level)
                    {
                        case TraceLevel.Error:
                            type1 = EventLogEntryType.Error;
                            break;

                        case TraceLevel.Warning:
                            type1 = EventLogEntryType.Warning;
                            break;

                        case TraceLevel.Info:
                            type1 = EventLogEntryType.Information;
                            break;

                        case TraceLevel.Verbose:
                            type1 = EventLogEntryType.SuccessAudit;
                            break;

                        default:
                            type1 = EventLogEntryType.SuccessAudit;
                            break;
                    }
                    new EventLog("Application", ApplicationConfiguration.get_EventLogMachineName(), ApplicationConfiguration.get_EventLogSourceName()).WriteEntry(messageText, type1);
                }
            }
            catch
            {
            }
        }


        public static void WriteTrace(string message)
        {
            ApplicationLog.WriteLog(TraceLevel.Verbose, message);
        }


        public static void WriteWarning(string message)
        {
            ApplicationLog.WriteLog(TraceLevel.Warning, message);
        }

 


    }
}

