﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="Tree.ascx.cs" Inherits="MkSun.Ke_System.Tree" %>
    <div class="TreeMenu" id="CategoryTree">
      <h4>动态树型菜单</h4>
    </div>

	<script language="jscript">

			function ExpandSubCategory(iCategoryID)
			{
				var li_father = document.getElementById("li_" + iCategoryID);
				if (li_father.getElementsByTagName("li").length > 0) //分类已下载
				{
					ChangeStatus(iCategoryID);
					switchNote(iCategoryID, false);
					return;
				}
				
				li_father.className = "Opened";
				switchNote(iCategoryID, true);
				MkSun.Ke_System.Tree.GetSubCategory(iCategoryID, GetSubCategory_callback);				
			}
			
			function GetSubCategory_callback(response)
			{
				var dt = response.value.Tables[0];
				if (dt.Rows.length > 0)
				{
					var iCategoryID = dt.Rows[0].ParentID;
				}
				var li_father = document.getElementById("li_" + iCategoryID);
				var ul = document.createElement("ul");
				ul.id="ul_note_"+iCategoryID;
				for (var i = 0;i < dt.Rows.length;i++)
				{
					if (dt.Rows[i].HaveBaby == 0) //叶子节点
					{
						var li = document.createElement("li");
						li.className = "Child";
						li.id = "li_" + dt.Rows[i].ID;
						
						var img = document.createElement("img");
						img.id = dt.Rows[i].ID;
						img.className = "s";
						img.src = "Css/skin1/opened.gif";
						
						var a = document.createElement("a");
					   a.href = "?ClassID="+ dt.Rows[i].ID;
					   a.innerHTML = dt.Rows[i].ClassName;
					   li.appendChild(img);
					   li.appendChild(a);
					   ul.appendChild(li)
					   li_father.appendChild(ul);
					}
					else
					{
						var li = document.createElement("li");
						li.className = "Closed";
						li.id = "li_" + dt.Rows[i].ID;
						
						var img = document.createElement("img");
						img.id = dt.Rows[i].ID;
						img.className = "s";
					    img.src = "Css/skin1/closed.gif";
						img.onclick = function () {
						ExpandSubCategory(this.id);
						};
						img.alt = "展开/折叠";
						
						var a = document.createElement("a");
						a.href = "javascript:ExpandSubCategory(" + dt.Rows[i].ID + ");";
						a.innerHTML = dt.Rows[i].ClassName;
					   li.appendChild(img);
					   li.appendChild(a);
					   ul.appendChild(li)
					   li_father.appendChild(ul);
					}
				}
				
				switchNote(iCategoryID, false);
			
			}
			
			function ChangeStatus(iCategoryID)
			{
				var li_father = document.getElementById("li_" + iCategoryID);
				if (li_father.className == "Closed")
				{
					li_father.className = "Opened";
				}
				else
				{
					li_father.className = "Closed";
				}				
			}
			
			function switchNote(iCategoryID, show)
			{
				var li_father = document.getElementById("li_" + iCategoryID);
				if (show)
				{
					var ul = document.createElement("ul");
					ul.id = "ul_note_" + iCategoryID;
					
					var note = document.createElement("li");
					note.className = "Child";
					
					var img = document.createElement("img");
					img.className = "s";
					img.src = "Css/skin1/child.gif";
					
					var a = document.createElement("a");
					a.href = "javascript:void(0);";
					a.innerHTML = "请稍候...";
					
					note.appendChild(img);
					note.appendChild(a);
					ul.appendChild(note);
					li_father.appendChild(ul);
				}
				else
				{
					var ul = document.getElementById("ul_note_" + iCategoryID);
					if (ul)
					{
						li_father.removeChild(ul);
					}				
				}
			}
			// 加载根节点
			var tree = document.getElementById("CategoryTree");
			var root = document.createElement("li");
			root.id = "li_0";
			tree.appendChild(root);
			// 加载页面时显示第一级分类
			ExpandSubCategory(0);
    </script>

