﻿using System;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
namespace MkSun.Ke_System
{
public partial class Control_Product_Product_V_Control : System.Web.UI.UserControl
{
    static int PageSizes=8, RecordCount=0, CurrentPage=1, PageCount=0;
    public OleDbConnection myConnection = null;
    public OleDbDataAdapter myAdapter = null;
    public DataSet myds = null;
    public static string str_sql = "select * from [Ke_Product] order by ProductID ";
    public static string strSqlCount = "select Count(*) from [Ke_Product]";
    private static string StrLanguage = "中文版";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            dataBind(strSqlCount);
            myGridView_Bind(1);
            SetPage(1, PageCount);

        }
    }

    #region 数据绑定
    private void dataBind(string strSqlCount)
    {
      
        RecordCount = Convert.ToInt32(SqlHelper.ExecuteScalar(strSqlCount).ToString());
        if (RecordCount > 0)
        {
            PageCount = ((RecordCount % PageSizes) == 0) ? (RecordCount / PageSizes) : ((RecordCount / PageSizes) + 1);
            CurrentPage = 1;
            DropDownListPage.Items.Clear();
            LabelRecordCount.Text = RecordCount.ToString();
            LabelPageCount.Text = PageCount.ToString();
            for (int i = 1; i < PageCount + 1; i++)
            {
                DropDownListPage.Items.Add(i.ToString());
            }
        }
        else
        {
            btnPageFirst.Enabled = false;
            btnPageNext.Enabled = false;
            btnPagePre.Enabled = false;
            btnPageLast.Enabled = false;
            DropDownListPage.Enabled = false;

        }

    }
    private void myGridView_Bind(int currentPage)
    {
        if (currentPage < 1) return;
        using (myConnection = new OleDbConnection(SqlHelper.ConnectionStringProfile))
        {
            myAdapter = new OleDbDataAdapter(str_sql, myConnection);
            myds = new DataSet();
            int str = (currentPage - 1) * PageSizes;
            myAdapter.Fill(myds, str, PageSizes, "News");
            myGridView.DataSource = myds.Tables[0].DefaultView;
            myGridView.DataBind();
        }
    }
    #endregion

    #region 分页
    private void SetPage(int currentPage, int pageCount)
    {
        if (currentPage == 1)
        {
            btnPageFirst.Enabled = false;
            btnPagePre.Enabled = false;
            if (pageCount > 1)
            {
                btnPageNext.Enabled = true;
                btnPageLast.Enabled = true;
            }
            else
            {
                btnPageNext.Enabled = false;
                btnPageLast.Enabled = false;
            }
        }
        else
        {
            if (currentPage == pageCount)
            {
                btnPageFirst.Enabled = true;
                btnPagePre.Enabled = true;
                btnPageNext.Enabled = false;
                btnPageLast.Enabled = false;
            }
            else
            {
                btnPageFirst.Enabled = true;
                btnPagePre.Enabled = true;
                btnPageNext.Enabled = true;
                btnPageLast.Enabled = true;
            }
        }
        LabelPageCurrent.Text = currentPage.ToString();

    }
    protected void DropDownListPage_SelectedIndexChanged(object sender, EventArgs e)
    {
        CurrentPage = Int32.Parse(DropDownListPage.SelectedValue);
        myGridView_Bind(CurrentPage);
        SetPage(CurrentPage, PageCount);
        LabelPageCurrent.Text = CurrentPage.ToString();
    }
    protected void btnPageFirst_Click(object sender, EventArgs e)
    {
        CurrentPage = 1;
        DropDownListPage.SelectedIndex = CurrentPage - 1;
        myGridView_Bind(CurrentPage);
        SetPage(CurrentPage, PageCount);
    }
    protected void btnNext_Click(object sender, EventArgs e)
    {
        CurrentPage = Int32.Parse(DropDownListPage.SelectedValue) + 1;
        DropDownListPage.SelectedIndex = CurrentPage - 1;
        myGridView_Bind(CurrentPage);
        SetPage(CurrentPage, PageCount);
    }
    protected void btnPre_Click(object sender, EventArgs e)
    {
        CurrentPage = Int32.Parse(DropDownListPage.SelectedValue) - 1;
        DropDownListPage.SelectedIndex = CurrentPage - 1;
        myGridView_Bind(CurrentPage);
        SetPage(CurrentPage, PageCount);
    }
    protected void btnLast_Click(object sender, EventArgs e)
    {
        CurrentPage = PageCount;
        DropDownListPage.SelectedIndex = CurrentPage - 1;
        myGridView_Bind(CurrentPage);
        SetPage(CurrentPage, PageCount);
    }

    #endregion

    public string GetStr(string Str, int count)
    {
        return Ke_Common.GetString(Str, count);
    }
 


    public string Str_sql
    {
        set { str_sql = value; }
    }
    public string StrSqlCount
    {
        set { strSqlCount = value; }
    }
}
}