﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.OleDb;
using MkSun.System_Error;
namespace MkSun.Ke_System
{
    public partial class admin_admin_persons : System.Web.UI.Page
    {
      
        DataSet ds;
        OleDbDataAdapter myAdapter;
        OleDbConnection myConnection;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["ManageName"] == null || Session["ManageName"].ToString() == "" || Session["ManageLevel"] == null || Session["ManageLevel"].ToString() == "")
            {

                Ke_Common.Alert("Re-entry !", "../login.aspx");

            }
            if (!IsPostBack)
            {
                using (myConnection = new OleDbConnection(SqlHelper.ConnectionStringProfile))
                {
                    ds = new DataSet();
                    myAdapter = new OleDbDataAdapter("select PersonID,PersonName,PersonSex,PersonQualification,PersonComputerLevel,PersonLook, PostName,j.postid from [Ke_person] p  left join [Ke_Job] J on J.PostID=p.PostID order by personlook, personid desc", myConnection);
                    myAdapter.Fill(ds);
                    myGridView.DataSource = ds.Tables[0].DefaultView;
                    myGridView.DataBind();
                }

            }
        }

        #region 分页
        protected void myGridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            myGridView.PageIndex = e.NewPageIndex;
            using (myConnection = new OleDbConnection(SqlHelper.ConnectionStringProfile))
            {
                ds = new DataSet();
                myAdapter = new OleDbDataAdapter("select PersonID,PersonName,PersonSex,PersonQualification,PersonComputerLevel,PersonLook=case PersonLook when 1 then '已查看' else '<font color=red >未查看</font>' end ,isnull(J.PostName,'职位不存在') as PostName,j.postid from [Ke_person] p  left join [Ke_Job] J on J.PostID=p.PostID order by personlook, personid desc", myConnection);
                myAdapter.Fill(ds);
                myGridView.DataSource = ds.Tables[0].DefaultView;
                myGridView.DataBind();
            }

        }
        #endregion

        #region 删除
        protected void LinkButton1_Click(object sender, EventArgs e)
        {
            //删除
            string ID = ((LinkButton)sender).CommandName;
            if (!Ke_Common.IsNumeric(ID))
            {
                SystemError.SystemLog("后台管理员删除简历时，提交了非法ＩＤ号");
                Ke_Common.Alert("参数错误！", "Default.aspx");

            }
            else
            {
                int i = SqlHelper.ExecuteNonQuery(SqlHelper.ConnectionStringProfile, CommandType.Text, "delete  from  Ke_Person whre PersonID='"+ID+"'");
                if (i < 0)
                {

                    SystemError.SystemLog("后台管理员删除简历时，记录没有找到");
                    Ke_Common.Alert("删除错误！", "Default.aspx");
                }
                else
                {

                    Ke_Common.Alert("删除成功！", "Default.aspx");
                }

            }
        }
        #endregion

        #region 查看情况
        public string PersonLooks(string value)
        {
            if (value == "1")
            {
                return "已查看";
            }
            else
            {
                return "<font color=red >未查看</font>";
            }

        }
        #endregion

        #region 职位情况

        public string Post(string value)
        {
            if (value == "" || value == null)
            {
                return "本职位不存在";
            }
            else
            {
                return value;
            }
        
        }

        #endregion




    }
}