using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class AfficheBiz
	{
		public static void AddAffiche(Affiche objAffiche)
		{
			AfficheInsert objAfficheDAL = new AfficheInsert();
			objAfficheDAL.ReceiveParameter(objAffiche);
			objAfficheDAL.ExecuteNonQuery();
			objAffiche.AfficheID = objAfficheDAL.AfficheID;
		}

		public static DataTable GetAllAffiche()
		{
			AfficheSelectAll objAfficheDAL = new AfficheSelectAll();
			return objAfficheDAL.ExecuteDataTable();
		}

		public static void UpdateAffiche(Affiche objAffiche)
		{
			AfficheUpdate objAfficheDAL = new AfficheUpdate();
			objAfficheDAL.ReceiveParameter(objAffiche);
			objAfficheDAL.ExecuteNonQuery();
		}

		public static void DeleteAffiche(System.Int32 AfficheID)
		{
			AfficheDelete objAfficheDAL = new AfficheDelete();
			objAfficheDAL.AfficheID = AfficheID;
			objAfficheDAL.ExecuteNonQuery();
		}

		public static Affiche GetAffiche(System.Int32 AfficheID)
		{
			AfficheSelectByPk objAfficheDAL = new AfficheSelectByPk();
			Affiche objAffiche = new Affiche();
			objAfficheDAL.AfficheID = AfficheID;
			objAffiche.SetMetaDataTable(objAfficheDAL.ExecuteDataTable());
			return objAffiche;
		}

        public static DataTable GetAfficheSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
        {
            AfficheSelectAllPaged objAfficheDAL = new AfficheSelectAllPaged();
            objAfficheDAL.CurrentPage = CurrentPage;
            objAfficheDAL.PageSize = PageSize;
            objAfficheDAL.SortBy = SortBy;
            DataTable AfficheTable = objAfficheDAL.ExecuteDataTable();
            TotalPage = objAfficheDAL.TotalPage;
            TotalRecord = objAfficheDAL.TotalRecord;
            return AfficheTable;
        }

	}
}