using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class BusBiz
	{
		public static void AddBus(Bus objBus)
		{
			BusInsert objBusDAL = new BusInsert();
			objBusDAL.ReceiveParameter(objBus);
			objBusDAL.ExecuteNonQuery();
			objBus.ID = objBusDAL.ID;
		}

		public static DataTable GetAllBus()
		{
			BusSelectAll objBusDAL = new BusSelectAll();
			return objBusDAL.ExecuteDataTable();
	    }
		
	    public static DataTable GetBusSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
	    {
	        BusSelectAllPaged objBusDAL = new BusSelectAllPaged();
	        objBusDAL.CurrentPage = CurrentPage;
	        objBusDAL.PageSize = PageSize;
	        objBusDAL.SortBy = SortBy;
	        DataTable BusTable =  objBusDAL.ExecuteDataTable();
	        TotalPage = objBusDAL.TotalPage;
	        TotalRecord = objBusDAL.TotalRecord;
	        return BusTable;
	     }

		public static void UpdateBus(Bus objBus)
		{
			BusUpdate objBusDAL = new BusUpdate();
			objBusDAL.ReceiveParameter(objBus);
			objBusDAL.ExecuteNonQuery();
		}

		public static void DeleteBus(System.Int32 ID)
		{
			BusDelete objBusDAL = new BusDelete();
			objBusDAL.ID = ID;
			objBusDAL.ExecuteNonQuery();
		}

		public static Bus GetBus(System.Int32 ID)
		{
			BusSelectByPk objBusDAL = new BusSelectByPk();
			Bus objBus = new Bus();
			objBusDAL.ID = ID;
			objBus.SetMetaDataTable(objBusDAL.ExecuteDataTable());
			return objBus;
		}
	}
}