using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class BusEmployeeBiz
	{
		public static void AddBusEmployee(BusEmployee objBusEmployee)
		{
			BusEmployeeInsert objBusEmployeeDAL = new BusEmployeeInsert();
			objBusEmployeeDAL.ReceiveParameter(objBusEmployee);
			objBusEmployeeDAL.ExecuteNonQuery();
			objBusEmployee.ID = objBusEmployeeDAL.ID;
		}

		public static DataTable GetAllBusEmployee()
		{
			BusEmployeeSelectAll objBusEmployeeDAL = new BusEmployeeSelectAll();
			return objBusEmployeeDAL.ExecuteDataTable();
	    }
		
	    public static DataTable GetBusEmployeeSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
	    {
	        BusEmployeeSelectAllPaged objBusEmployeeDAL = new BusEmployeeSelectAllPaged();
	        objBusEmployeeDAL.CurrentPage = CurrentPage;
	        objBusEmployeeDAL.PageSize = PageSize;
	        objBusEmployeeDAL.SortBy = SortBy;
	        DataTable BusEmployeeTable =  objBusEmployeeDAL.ExecuteDataTable();
	        TotalPage = objBusEmployeeDAL.TotalPage;
	        TotalRecord = objBusEmployeeDAL.TotalRecord;
	        return BusEmployeeTable;
	     }

		public static void UpdateBusEmployee(BusEmployee objBusEmployee)
		{
			BusEmployeeUpdate objBusEmployeeDAL = new BusEmployeeUpdate();
			objBusEmployeeDAL.ReceiveParameter(objBusEmployee);
			objBusEmployeeDAL.ExecuteNonQuery();
		}

		public static void DeleteBusEmployee(System.Int32 ID)
		{
			BusEmployeeDelete objBusEmployeeDAL = new BusEmployeeDelete();
			objBusEmployeeDAL.ID = ID;
			objBusEmployeeDAL.ExecuteNonQuery();
		}

		public static BusEmployee GetBusEmployee(System.Int32 ID)
		{
			BusEmployeeSelectByPk objBusEmployeeDAL = new BusEmployeeSelectByPk();
			BusEmployee objBusEmployee = new BusEmployee();
			objBusEmployeeDAL.ID = ID;
			objBusEmployee.SetMetaDataTable(objBusEmployeeDAL.ExecuteDataTable());
			return objBusEmployee;
		}

		public static DataTable GetBusEmployeeByBusID(System.Int32 BusID)
		{
			BusEmployeeSelectByBusID objBusEmployeeDAL = new BusEmployeeSelectByBusID();
			objBusEmployeeDAL.BusID = BusID;
			return objBusEmployeeDAL.ExecuteDataTable();
		}
	}
}