using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class BusOwnersBiz
	{
		public static void AddBusOwners(BusOwners objBusOwners)
		{
			BusOwnersInsert objBusOwnersDAL = new BusOwnersInsert();
			objBusOwnersDAL.ReceiveParameter(objBusOwners);
			objBusOwnersDAL.ExecuteNonQuery();
			objBusOwners.ID = objBusOwnersDAL.ID;
		}

		public static DataTable GetAllBusOwners()
		{
			BusOwnersSelectAll objBusOwnersDAL = new BusOwnersSelectAll();
			return objBusOwnersDAL.ExecuteDataTable();
	    }
		
	    public static DataTable GetBusOwnersSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
	    {
	        BusOwnersSelectAllPaged objBusOwnersDAL = new BusOwnersSelectAllPaged();
	        objBusOwnersDAL.CurrentPage = CurrentPage;
	        objBusOwnersDAL.PageSize = PageSize;
	        objBusOwnersDAL.SortBy = SortBy;
	        DataTable BusOwnersTable =  objBusOwnersDAL.ExecuteDataTable();
	        TotalPage = objBusOwnersDAL.TotalPage;
	        TotalRecord = objBusOwnersDAL.TotalRecord;
	        return BusOwnersTable;
	     }

		public static void UpdateBusOwners(BusOwners objBusOwners)
		{
			BusOwnersUpdate objBusOwnersDAL = new BusOwnersUpdate();
			objBusOwnersDAL.ReceiveParameter(objBusOwners);
			objBusOwnersDAL.ExecuteNonQuery();
		}

		public static void DeleteBusOwners(System.Int32 ID)
		{
			BusOwnersDelete objBusOwnersDAL = new BusOwnersDelete();
			objBusOwnersDAL.ID = ID;
			objBusOwnersDAL.ExecuteNonQuery();
		}

		public static BusOwners GetBusOwners(System.Int32 ID)
		{
			BusOwnersSelectByPk objBusOwnersDAL = new BusOwnersSelectByPk();
			BusOwners objBusOwners = new BusOwners();
			objBusOwnersDAL.ID = ID;
			objBusOwners.SetMetaDataTable(objBusOwnersDAL.ExecuteDataTable());
			return objBusOwners;
		}
	}
}