using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class CarOwnersBiz
	{
		public static void AddCarOwners(CarOwners objCarOwners)
		{
			CarOwnersInsert objCarOwnersDAL = new CarOwnersInsert();
			objCarOwnersDAL.ReceiveParameter(objCarOwners);
			objCarOwnersDAL.ExecuteNonQuery();
			objCarOwners.ID = objCarOwnersDAL.ID;
		}

		public static DataTable GetAllCarOwners()
		{
			CarOwnersSelectAll objCarOwnersDAL = new CarOwnersSelectAll();
			return objCarOwnersDAL.ExecuteDataTable();
	    }
		
	    public static DataTable GetCarOwnersSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
	    {
	        CarOwnersSelectAllPaged objCarOwnersDAL = new CarOwnersSelectAllPaged();
	        objCarOwnersDAL.CurrentPage = CurrentPage;
	        objCarOwnersDAL.PageSize = PageSize;
	        objCarOwnersDAL.SortBy = SortBy;
	        DataTable CarOwnersTable =  objCarOwnersDAL.ExecuteDataTable();
	        TotalPage = objCarOwnersDAL.TotalPage;
	        TotalRecord = objCarOwnersDAL.TotalRecord;
	        return CarOwnersTable;
	     }

		public static void UpdateCarOwners(CarOwners objCarOwners)
		{
			CarOwnersUpdate objCarOwnersDAL = new CarOwnersUpdate();
			objCarOwnersDAL.ReceiveParameter(objCarOwners);
			objCarOwnersDAL.ExecuteNonQuery();
		}

		public static void DeleteCarOwners(System.Int32 ID)
		{
			CarOwnersDelete objCarOwnersDAL = new CarOwnersDelete();
			objCarOwnersDAL.ID = ID;
			objCarOwnersDAL.ExecuteNonQuery();
		}

		public static CarOwners GetCarOwners(System.Int32 ID)
		{
			CarOwnersSelectByPk objCarOwnersDAL = new CarOwnersSelectByPk();
			CarOwners objCarOwners = new CarOwners();
			objCarOwnersDAL.ID = ID;
			objCarOwners.SetMetaDataTable(objCarOwnersDAL.ExecuteDataTable());
			return objCarOwners;
		}
	}
}