using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class ConductorEmployeeBiz
	{
		public static void AddConductorEmployee(ConductorEmployee objConductorEmployee)
		{
			ConductorEmployeeInsert objConductorEmployeeDAL = new ConductorEmployeeInsert();
			objConductorEmployeeDAL.ReceiveParameter(objConductorEmployee);
			objConductorEmployeeDAL.ExecuteNonQuery();
			objConductorEmployee.ID = objConductorEmployeeDAL.ID;
		}

		public static DataTable GetAllConductorEmployee()
		{
			ConductorEmployeeSelectAll objConductorEmployeeDAL = new ConductorEmployeeSelectAll();
			return objConductorEmployeeDAL.ExecuteDataTable();
	    }
		
	    public static DataTable GetConductorEmployeeSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
	    {
	        ConductorEmployeeSelectAllPaged objConductorEmployeeDAL = new ConductorEmployeeSelectAllPaged();
	        objConductorEmployeeDAL.CurrentPage = CurrentPage;
	        objConductorEmployeeDAL.PageSize = PageSize;
	        objConductorEmployeeDAL.SortBy = SortBy;
	        DataTable ConductorEmployeeTable =  objConductorEmployeeDAL.ExecuteDataTable();
	        TotalPage = objConductorEmployeeDAL.TotalPage;
	        TotalRecord = objConductorEmployeeDAL.TotalRecord;
	        return ConductorEmployeeTable;
	     }

		public static void UpdateConductorEmployee(ConductorEmployee objConductorEmployee)
		{
			ConductorEmployeeUpdate objConductorEmployeeDAL = new ConductorEmployeeUpdate();
			objConductorEmployeeDAL.ReceiveParameter(objConductorEmployee);
			objConductorEmployeeDAL.ExecuteNonQuery();
		}

		public static void DeleteConductorEmployee(System.Int32 ID)
		{
			ConductorEmployeeDelete objConductorEmployeeDAL = new ConductorEmployeeDelete();
			objConductorEmployeeDAL.ID = ID;
			objConductorEmployeeDAL.ExecuteNonQuery();
		}

		public static ConductorEmployee GetConductorEmployee(System.Int32 ID)
		{
			ConductorEmployeeSelectByPk objConductorEmployeeDAL = new ConductorEmployeeSelectByPk();
			ConductorEmployee objConductorEmployee = new ConductorEmployee();
			objConductorEmployeeDAL.ID = ID;
			objConductorEmployee.SetMetaDataTable(objConductorEmployeeDAL.ExecuteDataTable());
			return objConductorEmployee;
		}

		public static DataTable GetConductorEmployeeByID(System.Int32 ID)
		{
			ConductorEmployeeSelectByID objConductorEmployeeDAL = new ConductorEmployeeSelectByID();
			objConductorEmployeeDAL.ID = ID;
			return objConductorEmployeeDAL.ExecuteDataTable();
		}
	}
}