using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class TrainRecordBiz
	{
		public static void AddTrainRecord(TrainRecord objTrainRecord)
		{
			TrainRecordInsert objTrainRecordDAL = new TrainRecordInsert();
			objTrainRecordDAL.ReceiveParameter(objTrainRecord);
			objTrainRecordDAL.ExecuteNonQuery();
			objTrainRecord.ID = objTrainRecordDAL.ID;
		}

		public static DataTable GetAllTrainRecord()
		{
			TrainRecordSelectAll objTrainRecordDAL = new TrainRecordSelectAll();
			return objTrainRecordDAL.ExecuteDataTable();
	    }
		
	    public static DataTable GetTrainRecordSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
	    {
	        TrainRecordSelectAllPaged objTrainRecordDAL = new TrainRecordSelectAllPaged();
	        objTrainRecordDAL.CurrentPage = CurrentPage;
	        objTrainRecordDAL.PageSize = PageSize;
	        objTrainRecordDAL.SortBy = SortBy;
	        DataTable TrainRecordTable =  objTrainRecordDAL.ExecuteDataTable();
	        TotalPage = objTrainRecordDAL.TotalPage;
	        TotalRecord = objTrainRecordDAL.TotalRecord;
	        return TrainRecordTable;
	     }

		public static void UpdateTrainRecord(TrainRecord objTrainRecord)
		{
			TrainRecordUpdate objTrainRecordDAL = new TrainRecordUpdate();
			objTrainRecordDAL.ReceiveParameter(objTrainRecord);
			objTrainRecordDAL.ExecuteNonQuery();
		}

		public static void DeleteTrainRecord(System.Int32 ID)
		{
			TrainRecordDelete objTrainRecordDAL = new TrainRecordDelete();
			objTrainRecordDAL.ID = ID;
			objTrainRecordDAL.ExecuteNonQuery();
		}

		public static TrainRecord GetTrainRecord(System.Int32 ID)
		{
			TrainRecordSelectByPk objTrainRecordDAL = new TrainRecordSelectByPk();
			TrainRecord objTrainRecord = new TrainRecord();
			objTrainRecordDAL.ID = ID;
			objTrainRecord.SetMetaDataTable(objTrainRecordDAL.ExecuteDataTable());
			return objTrainRecord;
		}
	}
}