﻿namespace ESpace.DALibrary
{
    using System;
    using System.IO;
    using System.Security.Cryptography;
    using System.Text;

    public class Alogrim
    {
        private byte[] _IV;
        private byte[] _Key;
        private SymmetricAlgorithm objCryptoService;

        public Alogrim(SymmProvEnum NetSelected)
        {
            switch (NetSelected)
            {
                case SymmProvEnum.DES:
                    this.objCryptoService = new DESCryptoServiceProvider();
                    break;

                case SymmProvEnum.RC2:
                    this.objCryptoService = new RC2CryptoServiceProvider();
                    break;

                case SymmProvEnum.Rijndael:
                    this.objCryptoService = new RijndaelManaged();
                    break;

                case SymmProvEnum.TripleDES:
                    this.objCryptoService = new TripleDESCryptoServiceProvider();
                    break;
            }
            this._Key = this.objCryptoService.Key;
            this._IV = this.objCryptoService.IV;
        }

        public Alogrim(SymmetricAlgorithm ServiceProvider)
        {
            this.objCryptoService = ServiceProvider;
        }

        public string Decrypting(string Source)
        {
            byte[] buffer = Convert.FromBase64String(Source);
            MemoryStream stream = new MemoryStream(buffer, 0, buffer.Length, false, true);
            ICryptoTransform transform = this.objCryptoService.CreateDecryptor();
            CryptoStream stream2 = new CryptoStream(stream, transform, CryptoStreamMode.Read);
            StreamReader reader = new StreamReader(stream2);
          
            return reader.ReadToEnd();
        }

        public string Encrypting(string Source)
        {
            MemoryStream stream = new MemoryStream();
            ICryptoTransform transform = this.objCryptoService.CreateEncryptor();
            CryptoStream stream2 = new CryptoStream(stream, transform, CryptoStreamMode.Write);
            StreamWriter writer = new StreamWriter(stream2);
            writer.Write(Source);
            writer.Flush();
            stream2.FlushFinalBlock();
            byte[] buffer = new byte[stream.Length];
            stream.Position = 0L;
            stream.Read(buffer, 0, buffer.Length);
            string str = Convert.ToBase64String(buffer);
            this.objCryptoService.Clear();
            stream.Close();
            writer.Close();
            return str;
        }

        public string IV
        {
            get
            {
                return Encoding.Default.GetString(this._IV);
            }
            set
            {
                string s = value;
                if ((value.Length * 8) > this.objCryptoService.BlockSize)
                {
                    s = value.Substring(0, this.objCryptoService.BlockSize / 8);
                }
                if ((value.Length * 8) < this.objCryptoService.BlockSize)
                {
                    s = value.PadRight(this.objCryptoService.BlockSize / 8);
                }
                this._IV = Encoding.Default.GetBytes(s);
                this.objCryptoService.IV = this._IV;
            }
        }

        public string Key
        {
            get
            {
                return Encoding.Default.GetString(this._Key);
            }
            set
            {
                string s = value;
                if ((s.Length * 8) > this.objCryptoService.LegalKeySizes[0].MaxSize)
                {
                    s = s.Substring(0, this.objCryptoService.LegalKeySizes[0].MaxSize / 8);
                }
                if ((s.Length * 8) < this.objCryptoService.LegalKeySizes[0].MinSize)
                {
                    s = s.PadRight(this.objCryptoService.LegalKeySizes[0].MinSize / 8);
                }
                if ((this.objCryptoService.LegalKeySizes[0].SkipSize != 0) && (((s.Length * 8) % this.objCryptoService.LegalKeySizes[0].SkipSize) != 0))
                {
                    s = s.PadRight(this.objCryptoService.LegalKeySizes[0].MaxSize / 8);
                }
                this._Key = Encoding.Default.GetBytes(s);
                this.objCryptoService.Key = this._Key;
            }
        }

        public enum SymmProvEnum
        {
            None,
            DES,
            RC2,
            Rijndael,
            TripleDES
        }
    }
}

