﻿namespace ESpace.DALibrary.SqlServer
{
    using ESpace.DALibrary;
   using Microsoft.Data.SqlXml;
    using System;
    using System.Configuration;
    using System.Data;
    using System.Data.SqlClient;
    using System.IO;
    using System.Reflection;
    using System.Xml;

    public class DataAccessBase : IDisposable
    {
        private Alogrim.SymmProvEnum _EncryptMethod;
        private string _IV;
        private string _Key;
        private string _strConn;
        private bool disposed;
        protected SqlParameter paramReturnValue;
        protected SqlCommand sqlComm;

        private string Decrypt(string strSource)
        {
            if (this._EncryptMethod == Alogrim.SymmProvEnum.None)
            {
                return strSource;
            }
            Alogrim alogrim = new Alogrim(this._EncryptMethod);
            alogrim.Key = this._Key;
            alogrim.IV = this._IV;
            return alogrim.Decrypting(strSource);
        }


        public void Dispose()
        {
            if (!this.disposed)
            {
                if (this.sqlComm != null)
                {
                    if (this.sqlComm.Connection != null)
                    {
                        this.sqlComm.Connection.Dispose();
                    }
                    this.sqlComm.Dispose();
                }
                this.disposed = true;
            }
        }

        public DataSet ExecuteDataSet()
        {
            return this.ExecuteDataSet("Root");
        }

        public DataSet ExecuteDataSet(string sTableName)
        {
            DataSet set;
            using (SqlConnection connection = new SqlConnection(this._strConn))
            {
                this.sqlComm.Connection = connection;
                SqlDataAdapter adapter = new SqlDataAdapter(this.sqlComm);
                set = new DataSet(sTableName);
                adapter.Fill(set);
                connection.Close();
            }
            return set;
        }

        public DataTable ExecuteDataTable()
        {
            return this.ExecuteDataTable("");
        }

        public DataTable ExecuteDataTable(string sTableName)
        {
            DataTable table;
            using (SqlConnection connection = new SqlConnection(this._strConn))
            {
                this.sqlComm.Connection = connection;
                SqlDataAdapter adapter = new SqlDataAdapter(this.sqlComm);
                table = new DataTable();
                adapter.Fill(table);
                connection.Close();
                if (sTableName != "")
                {
                    table.TableName = sTableName;
                }
            }
            return table;
        }

        public int ExecuteNonQuery()
        {
            int num = -1;
            using (SqlConnection connection = new SqlConnection(this._strConn))
            {
                connection.Open();
                this.sqlComm.Connection = connection;
                num = this.sqlComm.ExecuteNonQuery();
                connection.Close();
            }
            return num;
        }

        public object ExecuteScalar()
        {
            object obj2 = null;
            using (SqlConnection connection = new SqlConnection(this._strConn))
            {
                this.sqlComm.Connection = connection;
                connection.Open();
                this.sqlComm.Connection = connection;
                obj2 = this.sqlComm.ExecuteScalar();
                connection.Close();
            }
            return obj2;
        }

        public XmlDocument ExecuteXmlDom()
        {
            return this.ExecuteXmlDom("ROOT");
        }

        public XmlDocument ExecuteXmlDom(string sRootName)
        {
            SqlXmlCommand command = new SqlXmlCommand("Provider=SQLOLEDB;" + this._strConn);
            command.CommandType = SqlXmlCommandType.Template;
            command.CommandText="<ROOT xmlns:sql=\"urn:schemas-microsoft-com:xml-sql\">\r\n\t\t\t\t\t\t\t\t\t<sql:header>";
            foreach (SqlParameter parameter in this.sqlComm.Parameters)
            {
                if (parameter.ParameterName != "@ReturnValue")
                {
                    object obj2 = command.CommandText;
                    command.CommandText=string.Concat(new object[] { obj2, "<sql:param name=\"", parameter.ParameterName.Substring(1), "\">", parameter.Value, "</sql:param>" });
                }
            }
            command.CommandText=command.CommandText + "\t</sql:header> \r\n\t\t\t\t\t\t\t\t\t<sql:query>\r\n\t\t\t\t\t\t\t\t\t\tEXEC " + this.sqlComm.CommandText;
            foreach (SqlParameter parameter2 in this.sqlComm.Parameters)
            {
                if (parameter2.ParameterName != "@ReturnValue")
                {
                    command.CommandText=command.CommandText + parameter2.ParameterName + ",";
                }
            }
            if (command.CommandText.EndsWith(","))
            {
                command.CommandText=command.CommandText.Substring(0, command.CommandText.Length - 1);
            }
            command.CommandText=command.CommandText+ "\t</sql:query>\r\n\t\t\t\t\t\t\t\t</ROOT>";
            string xml = new StreamReader(command.ExecuteStream()).ReadToEnd();
            XmlDocument document = new XmlDocument();
            document.LoadXml(xml);
            XmlDocument document2 = new XmlDocument();
            document2.LoadXml("<" + sRootName + ">" + document.DocumentElement.InnerXml + "</" + sRootName + ">");
            return document2;
        }

        protected void InitCommand(string sSPName)
        {
            this.sqlComm = new SqlCommand();
            this.sqlComm.CommandText = sSPName;
            this.sqlComm.CommandType = CommandType.StoredProcedure;
            this.paramReturnValue = new SqlParameter();
            this.paramReturnValue.ParameterName = "@ReturnValue";
            this.paramReturnValue.SqlDbType = SqlDbType.Int;
            this.paramReturnValue.Size = 4;
            this.paramReturnValue.Direction = ParameterDirection.ReturnValue;
            this.sqlComm.Parameters.Add(this.paramReturnValue);
        }

        public void ReceiveParameter(DataTable dtParameter)
        {
            foreach (SqlParameter parameter in this.sqlComm.Parameters)
            {
                string parameterName = parameter.ParameterName;
                string str2 = parameterName.Substring(1, parameterName.Length - 1);
                foreach (DataColumn column in dtParameter.Columns)
                {
                    if (str2 == column.ColumnName)
                    {
                        parameter.Value = dtParameter.Rows[0][str2];
                        break;
                    }
                }
            }
        }
        /// <summary>
        /// 51-a-s+p/x
        /// </summary>
        /// <param name="objEntity"></param>
        public void ReceiveParameter(object objEntity)
        {
            Type type = objEntity.GetType();
            foreach (SqlParameter parameter in this.sqlComm.Parameters)
            {
                string parameterName = parameter.ParameterName;
                string name = parameterName.Substring(1, parameterName.Length - 1);
                PropertyInfo property = type.GetProperty(name);
                if (property != null)
                {
                    parameter.Value = property.GetValue(objEntity, null);
                }
            }
        }

        public string ConnectionString
        {
            get
            {
                return this._strConn;
            }
            set
            {
                this._strConn = this.Decrypt(value);
            }
        }

        public string DBSection
        {
            set
            {
                this._strConn = this.Decrypt(ConfigurationManager.AppSettings[value]);
            }
        }

        protected Alogrim.SymmProvEnum EncryptMethod
        {
            set
            {
                this._EncryptMethod = value;
            }
        }

        protected string IV
        {
            set
            {
                this._IV = value;
            }
        }

        protected string Key
        {
            set
            {
                this._Key = value;
            }
        }

        public int ReturnValue
        {
            get
            {
                return (int) this.paramReturnValue.Value;
            }
        }
    }
}

