using System;
using System.Data;
using AVC.Passport.DataEntity;
using AVC.Passport.DataAccess;

namespace AVC.Passport
{
	public class RightsBiz
	{
		public static void AddRights(Rights objRights)
		{
			RightsInsert objRightsDAL = new RightsInsert();
			objRightsDAL.ReceiveParameter(objRights);
			objRightsDAL.ExecuteNonQuery();
			objRights.RightID = objRightsDAL.RightID;
		}

		public static DataTable GetAllRights()
		{
			RightsSelectAll objRightsDAL = new RightsSelectAll();
			return objRightsDAL.ExecuteDataTable();
	    }
		
	    public static DataTable GetRightsSelectAllPaged(int CurrentPage, out int TotalPage, out int TotalRecord, int PageSize, string SortBy)
	    {
	        RightsSelectAllPaged objRightsDAL = new RightsSelectAllPaged();
	        objRightsDAL.CurrentPage = CurrentPage;
	        objRightsDAL.PageSize = PageSize;
	        objRightsDAL.SortBy = SortBy;
	        DataTable RightsTable =  objRightsDAL.ExecuteDataTable();
	        TotalPage = objRightsDAL.TotalPage;
	        TotalRecord = objRightsDAL.TotalRecord;
	        return RightsTable;
	     }

		public static void UpdateRights(Rights objRights)
		{
			RightsUpdate objRightsDAL = new RightsUpdate();
			objRightsDAL.ReceiveParameter(objRights);
			objRightsDAL.ExecuteNonQuery();
		}

		public static void DeleteRights(System.Int32 RightID)
		{
			RightsDelete objRightsDAL = new RightsDelete();
			objRightsDAL.RightID = RightID;
			objRightsDAL.ExecuteNonQuery();
		}

		public static Rights GetRights(System.Int32 RightID)
		{
			RightsSelectByPk objRightsDAL = new RightsSelectByPk();
			Rights objRights = new Rights();
			objRightsDAL.RightID = RightID;
			objRights.SetMetaDataTable(objRightsDAL.ExecuteDataTable());
			return objRights;
		}

		public static DataTable GetRightsByRightTypeID(System.Int32 RightTypeID)
		{
			RightsSelectByRightTypeID objRightsDAL = new RightsSelectByRightTypeID();
			objRightsDAL.RightTypeID = RightTypeID;
			return objRightsDAL.ExecuteDataTable();
		}

		public static DataTable GetRightsBySubSystemID(System.String SubSystemID)
		{
			RightsSelectBySubSystemID objRightsDAL = new RightsSelectBySubSystemID();
			objRightsDAL.SubSystemID = SubSystemID;
			return objRightsDAL.ExecuteDataTable();
		}
	}
}