﻿IF EXISTS (SELECT * FROM sysobjects WHERE type = 'P' AND name = 'GetGroupAllRights')
	BEGIN
		DROP  Procedure  GetGroupAllRights
	END

GO
/***********************************************
***功能描述：根据用户组/角色获取组/角色的所有权限，包括自身权限和从上级组继承的权限
***传入传出参数：
***	@GroupID：类型：int，传入参数
***				   描述：要查询的组编号
***	@SubSystemID： 类型：varchar(6)，传入参数
***				   描述：子系统编号
***作者：
***建立时间:2009-1-6
***更改时间：
***更改人：
***更改原因：
	  ****************************************************/
CREATE PROCEDURE [dbo].[GetGroupAllRights]
	(
	@SubSystemID VARCHAR(6),
	@GroupID INT
	)
AS

DECLARE @ParentGroupID INT
--建立权限临时表

CREATE TABLE #GroupRights(
   RightID              int,
   RightName            varchar(50),
   RightDisplayName     varchar(100),
   RightType			varchar(100),
   RightTypeID			int,
   ParentGroup			varchar(50),
   ParentGroupID		int,
   RightMemo			varchar(1000)
)

--递归取父组的权限
IF EXISTS(SELECT 1 FROM [Group] WHERE GroupID=@GroupID AND SubSystemID=@SubSystemID)
BEGIN
	SET @ParentGroupID=@GroupID
	WHILE @ParentGroupID<>'' AND @ParentGroupID IS NOT NULL
	BEGIN
		INSERT INTO #GroupRights
			SELECT Rights.RightID,Rights.RightName,Rights.RightDisplayName,RightsType.TypeName,RightsType.TypeID,[Group].GroupName,[Group].GroupID,[Rights].RightMemo FROM Rights
				INNER JOIN Group_Right
					ON Group_Right.RightID=Rights.RightID
				INNER JOIN RightsType
					ON RightsType.TypeID = Rights.RightTypeID
				INNER JOIN [Group]
					ON [Group].GroupID = Group_Right.GroupID
				WHERE Group_Right.GroupID=@ParentGroupID AND RightsType.SubSystemID=@SubSystemID
		SELECT @ParentGroupID=ParentGroupID FROM [Group] WHERE GroupID=@ParentGroupID
	END
END

-- 返回权限
SELECT DISTINCT * FROM #GroupRights