﻿IF EXISTS (SELECT * FROM sysobjects WHERE type = 'P' AND name = 'User_RightInsertA')
	BEGIN
		DROP  Procedure  User_RightInsertA
	END

GO
/***********************************************
***功能描述：为用户分配权限
***传入传出参数：
***	@UserID：用户ID
***	@RightID：要分配的权限ID
***	@CreateUser：操作员

***作者：
***建立时间:2009-1-6
***更改时间：
***更改人：
***更改原因：
****************************************************/
CREATE PROCEDURE User_RightInsertA
	(
		@UserID int,
		@RightID int,
		@CreateUser int
	)
AS
IF NOT EXISTS(SELECT 1 FROM [User_Rights] WHERE UserID=@UserID AND RightID=@RightID)
BEGIN
	INSERT INTO [dbo].[User_Rights]
		(
		[UserID],
		[RightID],
		[CreateTime],
		[CreateUser]
		)
	VALUES
		(
		@UserID,
		@RightID,
		GETDATE(),
		@CreateUser
		)
END
GO