using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class GroupBiz
	{
		public static void AddGroup(Group objGroup)
		{
			GroupInsert objGroupDAL = new GroupInsert();
			objGroupDAL.ReceiveParameter(objGroup);
			objGroupDAL.ExecuteNonQuery();
			objGroup.GroupID = objGroupDAL.GroupID;
		}

		public static DataTable GetAllGroup()
		{
			GroupSelectAll objGroupDAL = new GroupSelectAll();
			return objGroupDAL.ExecuteDataTable();
		}

		public static void UpdateGroup(Group objGroup)
		{
			GroupUpdate objGroupDAL = new GroupUpdate();
			objGroupDAL.ReceiveParameter(objGroup);
			objGroupDAL.ExecuteNonQuery();
		}

		public static void DeleteGroup(System.Int32 GroupID)
		{
			GroupDelete objGroupDAL = new GroupDelete();
			objGroupDAL.GroupID = GroupID;
			objGroupDAL.ExecuteNonQuery();
		}

		public static Group GetGroup(System.Int32 GroupID)
		{
			GroupSelectByPk objGroupDAL = new GroupSelectByPk();
			Group objGroup = new Group();
			objGroupDAL.GroupID = GroupID;
			objGroup.SetMetaDataTable(objGroupDAL.ExecuteDataTable());
			return objGroup;
		}

		public static DataTable GetGroupBySubSystemID(System.String SubSystemID)
		{
			GroupSelectBySubSystemID objGroupDAL = new GroupSelectBySubSystemID();
			objGroupDAL.SubSystemID = SubSystemID;
			return objGroupDAL.ExecuteDataTable();
		}
	}
}