using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class RightsTypeBiz
	{
		public static void AddRightsType(RightsType objRightsType)
		{
			RightsTypeInsert objRightsTypeDAL = new RightsTypeInsert();
			objRightsTypeDAL.ReceiveParameter(objRightsType);
			objRightsTypeDAL.ExecuteNonQuery();
			objRightsType.TypeID = objRightsTypeDAL.TypeID;
		}

		public static DataTable GetAllRightsType()
		{
			RightsTypeSelectAll objRightsTypeDAL = new RightsTypeSelectAll();
			return objRightsTypeDAL.ExecuteDataTable();
		}

		public static void UpdateRightsType(RightsType objRightsType)
		{
			RightsTypeUpdate objRightsTypeDAL = new RightsTypeUpdate();
			objRightsTypeDAL.ReceiveParameter(objRightsType);
			objRightsTypeDAL.ExecuteNonQuery();
		}

		public static void DeleteRightsType(System.Int32 TypeID)
		{
			RightsTypeDelete objRightsTypeDAL = new RightsTypeDelete();
			objRightsTypeDAL.TypeID = TypeID;
			objRightsTypeDAL.ExecuteNonQuery();
		}

		public static RightsType GetRightsType(System.Int32 TypeID)
		{
			RightsTypeSelectByPk objRightsTypeDAL = new RightsTypeSelectByPk();
			RightsType objRightsType = new RightsType();
			objRightsTypeDAL.TypeID = TypeID;
			objRightsType.SetMetaDataTable(objRightsTypeDAL.ExecuteDataTable());
			return objRightsType;
		}

		public static DataTable GetRightsTypeBySubSystemID(System.String SubSystemID)
		{
			RightsTypeSelectBySubSystemID objRightsTypeDAL = new RightsTypeSelectBySubSystemID();
			objRightsTypeDAL.SubSystemID = SubSystemID;
			return objRightsTypeDAL.ExecuteDataTable();
		}
	}
}