using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class UserMstBiz
	{
		public static void AddUserMst(UserMst objUserMst)
		{
			UserMstInsert objUserMstDAL = new UserMstInsert();
			objUserMstDAL.ReceiveParameter(objUserMst);
			objUserMstDAL.ExecuteNonQuery();
			objUserMst.UserID = objUserMstDAL.UserID;
		}

		public static DataTable GetAllUserMst()
		{
			UserMstSelectAll objUserMstDAL = new UserMstSelectAll();
			return objUserMstDAL.ExecuteDataTable();
		}

		public static void UpdateUserMst(UserMst objUserMst)
		{
			UserMstUpdate objUserMstDAL = new UserMstUpdate();
			objUserMstDAL.ReceiveParameter(objUserMst);
			objUserMstDAL.ExecuteNonQuery();
		}

		public static void DeleteUserMst(System.Int32 UserID)
		{
			UserMstDelete objUserMstDAL = new UserMstDelete();
			objUserMstDAL.UserID = UserID;
			objUserMstDAL.ExecuteNonQuery();
		}

		public static UserMst GetUserMst(System.Int32 UserID)
		{
			UserMstSelectByPk objUserMstDAL = new UserMstSelectByPk();
			UserMst objUserMst = new UserMst();
			objUserMstDAL.UserID = UserID;
			objUserMst.SetMetaDataTable(objUserMstDAL.ExecuteDataTable());
			return objUserMst;
		}

		public static DataTable GetUserMstBySubSystemID(System.String SubSystemID)
		{
			UserMstSelectBySubSystemID objUserMstDAL = new UserMstSelectBySubSystemID();
			objUserMstDAL.SubSystemID = SubSystemID;
			return objUserMstDAL.ExecuteDataTable();
		}
	}
}