using System;
using System.Data;
using AVC.DataEntity;
using AVC.DataAccess;

namespace AVC.Business
{
	public class User_RightsBiz
	{
		public static void AddUser_Rights(User_Rights objUser_Rights)
		{
			User_RightsInsert objUser_RightsDAL = new User_RightsInsert();
			objUser_RightsDAL.ReceiveParameter(objUser_Rights);
			objUser_RightsDAL.ExecuteNonQuery();
		}

		public static DataTable GetAllUser_Rights()
		{
			User_RightsSelectAll objUser_RightsDAL = new User_RightsSelectAll();
			return objUser_RightsDAL.ExecuteDataTable();
		}

		public static void UpdateUser_Rights(User_Rights objUser_Rights)
		{
			User_RightsUpdate objUser_RightsDAL = new User_RightsUpdate();
			objUser_RightsDAL.ReceiveParameter(objUser_Rights);
			objUser_RightsDAL.ExecuteNonQuery();
		}

		public static void DeleteUser_Rights(System.Int32 UserID,System.Int32 RightID)
		{
			User_RightsDelete objUser_RightsDAL = new User_RightsDelete();
			objUser_RightsDAL.UserID = UserID;
			objUser_RightsDAL.RightID = RightID;
			objUser_RightsDAL.ExecuteNonQuery();
		}

		public static User_Rights GetUser_Rights(System.Int32 UserID,System.Int32 RightID)
		{
			User_RightsSelectByPk objUser_RightsDAL = new User_RightsSelectByPk();
			User_Rights objUser_Rights = new User_Rights();
			objUser_RightsDAL.UserID = UserID;
			objUser_RightsDAL.RightID = RightID;
			objUser_Rights.SetMetaDataTable(objUser_RightsDAL.ExecuteDataTable());
			return objUser_Rights;
		}

		public static DataTable GetUser_RightsByRightID(System.Int32 RightID)
		{
			User_RightsSelectByRightID objUser_RightsDAL = new User_RightsSelectByRightID();
			objUser_RightsDAL.RightID = RightID;
			return objUser_RightsDAL.ExecuteDataTable();
		}

		public static DataTable GetUser_RightsByUserID(System.Int32 UserID)
		{
			User_RightsSelectByUserID objUser_RightsDAL = new User_RightsSelectByUserID();
			objUser_RightsDAL.UserID = UserID;
			return objUser_RightsDAL.ExecuteDataTable();
		}
	}
}