﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using AVC.Business;
using AVC.DataEntity;
public partial class Affiche_AfficheList : LoginPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //判断权限
            //if (!CheckRight("AfficheBrowse"))
            //{
            //    NoRightAlert();
            //}

            ViewState["CurrentPage"] = 1;
            ViewState["Sort"] = "AfficheID";
            BindTodgvAffiche(1, "AfficheID");
        }
        //}
    }
    private void BindTodgvAffiche(int CurrentPage, string Sort)
    {
        int TotalPage = 0;//总页数
        int TotalRecord = 0;//总记录数
        int PageSize = int.Parse(txtPageSize.Text);//每页10条数据
        txtCurrentPage.Text = CurrentPage.ToString();//当前页    
        dgvAffiche.DataSource = AfficheBiz.GetAfficheSelectAllPaged(CurrentPage - 1, out TotalPage, out TotalRecord, PageSize, Sort);
        dgvAffiche.DataBind();
        lblRecordCount.Text = TotalRecord.ToString();
        lblPageCount.Text = TotalPage.ToString();
        ViewState["Page"] = CurrentPage;
        ViewState["Sort"] = Sort;
        if (CurrentPage <= 1)
        {//如果当前页已经是第1页
            lbtnPrevious.Enabled = false;
            lbtnFirst.Enabled = false;
            lbtnNext.Enabled = true;
            lbtnLast.Enabled = true;
            ViewState["Page"] = 1;
        }
        else if (CurrentPage >= TotalPage)
        {//如果当前项已经是最末页
            lbtnFirst.Enabled = true;
            lbtnNext.Enabled = false;
            lbtnLast.Enabled = false;
            lbtnPrevious.Enabled = true;
            ViewState["Page"] = TotalPage;
        }
        else
        {
            lbtnFirst.Enabled = true;
            lbtnNext.Enabled = true;
            lbtnLast.Enabled = true;
            lbtnPrevious.Enabled = true;
        }

        if (TotalPage == 1)
        {
            lbtnFirst.Enabled = false;
            lbtnNext.Enabled = false;
            lbtnLast.Enabled = false;
            lbtnPrevious.Enabled = false;
        }

    }
    protected void btnGo_Click(object sender, EventArgs e)
    {
        if (ViewState["Sort"] == null)
        {
            BindTodgvAffiche(int.Parse(txtCurrentPage.Text), "AfficheID");
        }
        else
        {
            BindTodgvAffiche(int.Parse(txtCurrentPage.Text), (string)ViewState["Sort"]);
        }
    }
    protected void dgvAffiche_RowDataBound(object sender, GridViewRowEventArgs e)
    {

    }
    protected void lbtnFirst_Click(object sender, EventArgs e)
    {
        string Sort = (string)ViewState["Sort"];
        if (Sort != null)
        {
            BindTodgvAffiche(1, Sort);
        }
        else
        {
            BindTodgvAffiche(1, "AfficheID");
        }
    }
    protected void lbtnLast_Click(object sender, EventArgs e)
    {
        string Sort = (string)ViewState["Sort"];
        int Page = int.Parse(lblPageCount.Text);
        if (Sort != null)
        {
            BindTodgvAffiche(Page, Sort);
        }
        else
        {
            BindTodgvAffiche(Page, "AfficheID");
        }
    }
    protected void lbtnNext_Click(object sender, EventArgs e)
    {
        string Sort = (string)ViewState["Sort"];
        int Page = int.Parse(ViewState["Page"].ToString());
        Page++;
        if (Sort != null)
        {
            BindTodgvAffiche(Page, Sort);
        }
        else
        {
            BindTodgvAffiche(Page, "AfficheID");
        }
    }
    protected void lbtnPrevious_Click(object sender, EventArgs e)
    {
        string Sort = (string)ViewState["Sort"];
        int Page = int.Parse(ViewState["Page"].ToString());
        Page--;
        if (Sort != null)
        {
            BindTodgvAffiche(Page, Sort);
        }
        else
        {
            BindTodgvAffiche(1, "AfficheID");
        }
    }

    protected void dgvAffiche_Sorting(object sender, GridViewSortEventArgs e)
    {
        if (e.SortExpression == (string)ViewState["Sort"])
            ViewState["Sort"] = e.SortExpression + " DESC";
        else
            ViewState["Sort"] = e.SortExpression;
        int CurrentPage = int.Parse(txtCurrentPage.Text);
        BindTodgvAffiche(CurrentPage, (string)ViewState["Sort"]);
    }

    protected void dgvAffiche_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Delete")
        {
            if (!string.IsNullOrEmpty((string)e.CommandArgument))
            {
              
                AfficheBiz.DeleteAffiche(int.Parse(e.CommandArgument.ToString()));
                Alert("添加成功！");
            }
        }
    }
    protected void dgvAffiche_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {

    }
}
