﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using AVC.Passport.DataEntity;
/// <summary>
/// UserTicket 的摘要描述
/// </summary>
public sealed  class UserTicket
{

    
    private static string USERNAME = "UserName";
    private static string USERID = "UserID";
 
    public  static  string UserName
     {
        get 
        {
            return GetCookie(USERNAME);
        }
        set
        {
            SetCookie(USERNAME,(string)value);
        }
    }

    public static int  UserID
    {
        get
        {
            int intUserID;
            int.TryParse(GetCookie(USERID), out intUserID);
            return intUserID;
        }
        set
        {
            SetCookie(USERID, value.ToString());
        }
    }

    private static string GetCookie(string key)
    {
        HttpCookie cookie = HttpContext.Current.Request.Cookies[key];
        if (cookie != null)
        {
            return cookie.Value;
        }
        else
            return string.Empty;
    }





    private static void  SetCookie(string key,string value)
    {
        HttpCookie cookie = new HttpCookie(key,value);
        HttpContext.Current.Response.Cookies.Add(cookie); 
    }
}
