
using System;
using System.Data;
using System.Web.UI.WebControls;
using System.Web.SessionState;
using AVC.Business;
using AVC.DataEntity;

	/// <summary>
	/// Bus编辑
	/// </summary>
public partial class BusEdit : LoginPageBase
	{

		private void Page_Load(object sender, System.EventArgs e)
		{
			if(!IsPostBack)
			{
				string strAction = Request.QueryString["action"];
				// 自动编号
                BindDropDownList();
				txtID.ReadOnly = true;
				txtID.Text = "自动增长";
				
				ViewState["Action"] = strAction;
				if(strAction == "edit")
				{
					System.Int32 ID = System.Int32.Parse(Request.QueryString["ID"]);Bus objBus = BusBiz.GetBus(ID);
					
					txtID.Text = objBus.ID.ToString();
					ddlOwners.SelectedItem.Value  = objBus.OwnersID.ToString();
					txtBusLicense.Text = objBus.BusLicense;
					txtTransportCard.Text = objBus.TransportCard;
                    txtTransportCardIssueDate.Text = objBus.TransportCardIssueDate.ToString("yyyy-MM-dd");
                    txtTransportCardFromDate.Text = objBus.TransportCardFromDate.ToString("yyyy-MM-dd");
                    txtTransportCardToDate.Text = objBus.TransportCardToDate.ToString("yyyy-MM-dd");
					ddlBusColor.SelectedItem.Value  = objBus.BusColor;
					txtSeatNumber.Text = objBus.SeatNumber.ToString();
					txtEngine.Text = objBus.Engine;
					txtChassis.Text = objBus.Chassis;
					txtBusModel.Text = objBus.BusModel;
					ddlFuel.SelectedItem.Value = objBus.Fuel;
					txtAnnualDate.Text = objBus.AnnualDate;
					txtBusinessRightCard.Text = objBus.BusinessRightCard;
                    txtBusinessRightCardIssueDate.Text = objBus.BusinessRightCardIssueDate.ToString("yyyy-MM-dd");
                    txtBusinessRightCardFromDate.Text = objBus.BusinessRightCardFromDate.ToString("yyyy-MM-dd");
                    txtBusinessRightCardToDate.Text = objBus.BusinessRightCardToDate.ToString("yyyy-MM-dd");
					txtOperateCard.Text = objBus.OperateCard;
                    txtOperateCardFromDate.Text = objBus.OperateCardFromDate.ToString("yyyy-MM-dd");
                    txtOperateCardToDate.Text = objBus.OperateCardToDate.ToString("yyyy-MM-dd");
                    txtOperateIssueDate.Text = objBus.OperateIssueDate.ToString("yyyy-MM-dd");
                    ddlLineName.SelectedItem.Value = objBus.LineID.ToString();
				
					txtID.ReadOnly = true;
					
				}
			}
		}

    private void BindDropDownList()
    {
        ddlOwners.DataSource = BusOwnersBiz.GetAllBusOwners();
        ddlOwners.DataBind();
        ddlBusColor.DataSource = OptionalValueBiz.GetOptionValueByDescription("color");
        ddlBusColor.DataBind();
        ddlFuel.DataSource = OptionalValueBiz.GetOptionValueByDescription("fuel");
        ddlFuel.DataBind();
        ddlLineName.DataSource = BusLineBiz.GetAllBusLine();
        ddlLineName.DataBind();
    }

		public  void btnOK_Click(object sender, System.EventArgs e)
		{
			try
			{
				if((string)ViewState["Action"] == "add")
				{
					Bus objBus = new Bus();
					
					objBus.OwnersID = System.Int32.Parse(ddlOwners.SelectedItem.Value);
					objBus.BusLicense = txtBusLicense.Text;
					objBus.TransportCard = txtTransportCard.Text;
					objBus.TransportCardIssueDate = System.DateTime.Parse(txtTransportCardIssueDate.Text);
					objBus.TransportCardFromDate = System.DateTime.Parse(txtTransportCardFromDate.Text);
					objBus.TransportCardToDate = System.DateTime.Parse(txtTransportCardToDate.Text);
					objBus.BusColor =ddlBusColor.SelectedItem.Value;
					objBus.SeatNumber = System.Int32.Parse(txtSeatNumber.Text);
					objBus.Engine = txtEngine.Text;
					objBus.Chassis = txtChassis.Text;
					objBus.BusModel = txtBusModel.Text;
					objBus.Fuel = ddlFuel.SelectedItem.Value;
					objBus.AnnualDate = txtAnnualDate.Text;
					objBus.BusinessRightCard = txtBusinessRightCard.Text;
					objBus.BusinessRightCardIssueDate = System.DateTime.Parse(txtBusinessRightCardIssueDate.Text);
					objBus.BusinessRightCardFromDate = System.DateTime.Parse(txtBusinessRightCardFromDate.Text);
					objBus.BusinessRightCardToDate = System.DateTime.Parse(txtBusinessRightCardToDate.Text);
					objBus.OperateCard = txtOperateCard.Text;
					objBus.OperateCardFromDate = System.DateTime.Parse(txtOperateCardFromDate.Text);
					objBus.OperateCardToDate = System.DateTime.Parse(txtOperateCardToDate.Text);
					objBus.OperateIssueDate = System.DateTime.Parse(txtOperateIssueDate.Text);
                    objBus.LineID = System.Int32.Parse(ddlLineName.SelectedItem.Value);
                    objBus.LineName = ddlLineName.SelectedItem.Text;
					objBus.CreateUser =  UserName ;
                    objBus.UpdateUser = UserName;
					objBus.UpdateDateTime = System.DateTime.Now;
					objBus.Flag = 1;
                    objBus.FlagDateTime = System.DateTime.Now;
					ViewState["Action"] = "edit";
					
					txtID.ReadOnly = true;
					
					txtID.ReadOnly = true;
					txtID.Text = objBus.ID.ToString();
					
				}
				else if((string)ViewState["Action"] == "edit")
				{
					Bus objBus = BusBiz.GetBus(System.Int32.Parse(txtID.Text));
					
					objBus.ID = System.Int32.Parse(txtID.Text);
					
					objBus.OwnersID = System.Int32.Parse(ddlOwners.SelectedItem.Value);
					
					objBus.BusLicense = txtBusLicense.Text;
					
					objBus.TransportCard = txtTransportCard.Text;
					
					objBus.TransportCardIssueDate = System.DateTime.Parse(txtTransportCardIssueDate.Text);
					
					objBus.TransportCardFromDate = System.DateTime.Parse(txtTransportCardFromDate.Text);
					
					objBus.TransportCardToDate = System.DateTime.Parse(txtTransportCardToDate.Text);
					
					objBus.BusColor = ddlBusColor.SelectedItem.Value;
					
					objBus.SeatNumber = System.Int32.Parse(txtSeatNumber.Text);
					
					objBus.Engine = txtEngine.Text;
					
					objBus.Chassis = txtChassis.Text;
					
					objBus.BusModel = txtBusModel.Text;
					
					objBus.Fuel = ddlFuel.SelectedItem.Value;
					
					objBus.AnnualDate = txtAnnualDate.Text;
					
					objBus.BusinessRightCard = txtBusinessRightCard.Text;
					
					objBus.BusinessRightCardIssueDate = System.DateTime.Parse(txtBusinessRightCardIssueDate.Text);
					
					objBus.BusinessRightCardFromDate = System.DateTime.Parse(txtBusinessRightCardFromDate.Text);
					
					objBus.BusinessRightCardToDate = System.DateTime.Parse(txtBusinessRightCardToDate.Text);
					
					objBus.OperateCard = txtOperateCard.Text;
					
					objBus.OperateCardFromDate = System.DateTime.Parse(txtOperateCardFromDate.Text);
					
					objBus.OperateCardToDate = System.DateTime.Parse(txtOperateCardToDate.Text);
					
					objBus.OperateIssueDate = System.DateTime.Parse(txtOperateIssueDate.Text);

                    objBus.LineID = System.Int32.Parse(ddlLineName.SelectedItem.Value);

                    objBus.LineName = ddlLineName.SelectedItem.Text;
					
					objBus.UpdateUser = UserName ;

                    objBus.UpdateDateTime = System.DateTime.Now;
					
					BusBiz.UpdateBus(objBus);
				}
				lblMessage.Text = "保存成功！";
			}
			catch(Exception ex)
			{
				lblMessage.Text = ex.Message;
			}
		}
	}

//5/1/A/S/P/X