using System;
using System.Data;
using System.Web.UI.WebControls;
using System.Web.SessionState;
using AVC.Business;
using AVC.DataEntity;

	/// <summary>
	/// BusEmployee编辑
	/// </summary>
public partial class BusEmployeeEdit : LoginPageBase
	{

		private void Page_Load(object sender, System.EventArgs e)
		{
			if(!IsPostBack)
			{
				string strAction = Request.QueryString["action"];
				// 自动编号
                BindDropDownList();
				txtID.ReadOnly = true;
				txtID.Text = "自动增长";
				
				ViewState["Action"] = strAction;
				if(strAction == "edit")
				{
					System.Int32 ID = System.Int32.Parse(Request.QueryString["ID"]);BusEmployee objBusEmployee = BusEmployeeBiz.GetBusEmployee(ID);
					
					txtID.Text = objBusEmployee.ID.ToString();
					txtIDCard.Text = objBusEmployee.IDCard;
					txtName.Text = objBusEmployee.Name;
					ddlSex.Text = objBusEmployee.Sex.ToString();
					txtPhone.Text = objBusEmployee.Phone;
					ddlLandscape.Text = objBusEmployee.Landscape;
					txtAddress.Text = objBusEmployee.Address;
					txtDriverLicenseNO.Text = objBusEmployee.DriverLicenseNO;
                    ddlDriverLicenseNoVehicleType.SelectedItem.Value  = objBusEmployee.DriverLicenseNoVehicleType;
                    txtDriverLicenseNoIssueDate.Text = objBusEmployee.DriverLicenseNoIssueDate.ToString("yyyy-MM-dd");
                    txtBirthDay.Text = objBusEmployee.BirthDay.ToString("yyyy-MM-dd");
			
					txtServiceUnit.Text = objBusEmployee.ServiceUnit;
                    ddlEducation.Text = objBusEmployee.Education;
					txtServiceCardNO.Text = objBusEmployee.ServiceCardNO;
                    txtServiceCardNOFromDate.Text = objBusEmployee.ServiceCardNOFromDate.ToString("yyyy-MM-dd");
                    txtServiceCardNOToDate.Text = objBusEmployee.ServiceCardNOToDate.ToString("yyyy-MM-dd");
					ddlBusID.SelectedItem.Value  = objBusEmployee.BusID.ToString();
				
					txtID.ReadOnly = true;
					
				}
			}
		}

    private void BindDropDownList()
    {
        ddlBusID.DataSource = BusBiz.GetAllBus();
        ddlBusID.DataBind();
        ddlDriverLicenseNoVehicleType.DataSource = OptionalValueBiz.GetOptionValueByDescription("DriverLicenseNoVehicleType");
        ddlDriverLicenseNoVehicleType.DataBind();
        ddlEducation.DataSource = OptionalValueBiz.GetOptionValueByDescription("Education");
        ddlEducation.DataBind();
        ddlLandscape.DataSource = OptionalValueBiz.GetOptionValueByDescription("Landscape");
        ddlLandscape.DataBind();
    }

		public void btnOK_Click(object sender, System.EventArgs e)
		{
			try
			{
				if((string)ViewState["Action"] == "add")
				{
					BusEmployee objBusEmployee = new BusEmployee();
					
					objBusEmployee.IDCard = txtIDCard.Text;
					objBusEmployee.Name = txtName.Text;
                    objBusEmployee.Sex = System.Boolean.Parse(ddlSex.Text);
					objBusEmployee.Phone = txtPhone.Text;
					objBusEmployee.Landscape = ddlLandscape.Text;
					objBusEmployee.Address = txtAddress.Text;
					objBusEmployee.DriverLicenseNO = txtDriverLicenseNO.Text;
                    objBusEmployee.DriverLicenseNoVehicleType = ddlDriverLicenseNoVehicleType.SelectedItem.Value;
					objBusEmployee.DriverLicenseNoIssueDate = System.DateTime.Parse(txtDriverLicenseNoIssueDate.Text);
					objBusEmployee.BirthDay = System.DateTime.Parse(txtBirthDay.Text);
					objBusEmployee.ServiceUnit = txtServiceUnit.Text;
                    objBusEmployee.Education = ddlEducation.Text;
					objBusEmployee.ServiceCardNO = txtServiceCardNO.Text;
					objBusEmployee.ServiceCardNOFromDate = System.DateTime.Parse(txtServiceCardNOFromDate.Text);
					objBusEmployee.ServiceCardNOToDate = System.DateTime.Parse(txtServiceCardNOToDate.Text);
					objBusEmployee.BusID = System.Int32.Parse(ddlBusID.SelectedItem.Value);
					objBusEmployee.CreateUser = UserName ;
					objBusEmployee.UpdateUser = UserName ;
                    objBusEmployee.UpdateDateTime = System.DateTime.Now;
					objBusEmployee.Flag = 1;
					objBusEmployee.FlagDateTime = System.DateTime.Now;
                    BusEmployeeBiz.AddBusEmployee(objBusEmployee);
					ViewState["Action"] = "edit";
					
					txtID.ReadOnly = true;
					
					txtID.ReadOnly = true;
					txtID.Text = objBusEmployee.ID.ToString();
					
				}
				else if((string)ViewState["Action"] == "edit")
				{
					BusEmployee objBusEmployee = BusEmployeeBiz.GetBusEmployee(System.Int32.Parse(txtID.Text));
					
					objBusEmployee.ID = System.Int32.Parse(txtID.Text);
					
					objBusEmployee.IDCard = txtIDCard.Text;
					
					objBusEmployee.Name = txtName.Text;
					
					objBusEmployee.Sex = System.Boolean.Parse(ddlSex.SelectedItem.Value);
					
					objBusEmployee.Phone = txtPhone.Text;
					
					objBusEmployee.Landscape = ddlLandscape.Text;
					
					objBusEmployee.Address = txtAddress.Text;
					
					objBusEmployee.DriverLicenseNO = txtDriverLicenseNO.Text;
					
					objBusEmployee.DriverLicenseNoVehicleType = ddlDriverLicenseNoVehicleType.SelectedItem.Value ;
					
					objBusEmployee.DriverLicenseNoIssueDate = System.DateTime.Parse(txtDriverLicenseNoIssueDate.Text);
					
					objBusEmployee.BirthDay = System.DateTime.Parse(txtBirthDay.Text);
					
					objBusEmployee.ServiceUnit = txtServiceUnit.Text;
					
					objBusEmployee.Education = ddlEducation.Text;
					
					objBusEmployee.ServiceCardNO = txtServiceCardNO.Text;
					
					objBusEmployee.ServiceCardNOFromDate = System.DateTime.Parse(txtServiceCardNOFromDate.Text);
					
					objBusEmployee.ServiceCardNOToDate = System.DateTime.Parse(txtServiceCardNOToDate.Text);
					
					objBusEmployee.BusID = System.Int32.Parse(ddlBusID.SelectedItem.Value);

                    objBusEmployee.UpdateUser = UserName;

                    objBusEmployee.UpdateDateTime = System.DateTime.Now;
					
					BusEmployeeBiz.UpdateBusEmployee(objBusEmployee);
				}
				lblMessage.Text = "保存成功！";
			}
			catch(Exception ex)
			{
				lblMessage.Text = ex.Message;
			}
		}
	}
