
using System;
using System.Data;
using System.Web.UI.WebControls;
using System.Web.SessionState;
using AVC.Business;
using AVC.DataEntity;

	/// <summary>
	/// ConductorEmployee编辑
	/// </summary>
public partial class ConductorEmployeeEdit : LoginPageBase
	{

		private void Page_Load(object sender, System.EventArgs e)
		{
			if(!IsPostBack)
			{
				string strAction = Request.QueryString["action"];
				// 自动编号
                BindDropDownList();
				txtID.ReadOnly = true;
				txtID.Text = "自动增长";
				
				ViewState["Action"] = strAction;
				if(strAction == "edit")
				{
					System.Int32 ID = System.Int32.Parse(Request.QueryString["ID"]);ConductorEmployee objConductorEmployee = ConductorEmployeeBiz.GetConductorEmployee(ID);
					
					txtID.Text = objConductorEmployee.ID.ToString();
					txtIDCard.Text = objConductorEmployee.IDCard;
					txtName.Text = objConductorEmployee.Name;
					ddlSex.Text = objConductorEmployee.Sex.ToString();
					txtPhone.Text = objConductorEmployee.Phone;
					ddlLandscape.Text = objConductorEmployee.Landscape;
					txtAddress.Text = objConductorEmployee.Address;
                    txtBirthDay.Text = objConductorEmployee.BirthDay.ToString("yyyy-MM-dd");
                    //txtPhoto.Text = objConductorEmployee.Photo.ToString();
					txtServiceUnit.Text = objConductorEmployee.ServiceUnit;
					ddlEducation.Text = objConductorEmployee.Education;
					txtServiceCardNO.Text = objConductorEmployee.ServiceCardNO;
                    txtServiceCardNOFromDate.Text = objConductorEmployee.ServiceCardNOFromDate.ToString("yyyy-MM-dd");
                    txtServiceCardNOToDate.Text = objConductorEmployee.ServiceCardNOToDate.ToString("yyyy-MM-dd");
					ddlBusID.Text = objConductorEmployee.BusID.ToString();
					txtID.ReadOnly = true;
					
				}
			}
		}

    private void BindDropDownList()
    {
        ddlBusID.DataSource = BusBiz.GetAllBus();
        ddlBusID.DataBind();
        ddlEducation.DataSource = OptionalValueBiz.GetOptionValueByDescription("Education");
        ddlEducation.DataBind();
        ddlLandscape.DataSource = OptionalValueBiz.GetOptionValueByDescription("Landscape");
        ddlLandscape.DataBind();
    }

		public void btnOK_Click(object sender, System.EventArgs e)
		{
			try
			{
				if((string)ViewState["Action"] == "add")
				{
					ConductorEmployee objConductorEmployee = new ConductorEmployee();
					
					objConductorEmployee.IDCard = txtIDCard.Text;
					objConductorEmployee.Name = txtName.Text;
					objConductorEmployee.Sex = System.Boolean.Parse(ddlSex.Text);
					objConductorEmployee.Phone = txtPhone.Text;
					objConductorEmployee.Landscape =ddlLandscape.SelectedItem.Value;
					objConductorEmployee.Address = txtAddress.Text;
					objConductorEmployee.BirthDay = System.DateTime.Parse(txtBirthDay.Text);
                    //objConductorEmployee.Photo = System.Byte[].Parse(txtPhoto.Text);
					objConductorEmployee.ServiceUnit = txtServiceUnit.Text;
					objConductorEmployee.Education = ddlEducation.SelectedItem.Value;
					objConductorEmployee.ServiceCardNO = txtServiceCardNO.Text;
					objConductorEmployee.ServiceCardNOFromDate = System.DateTime.Parse(txtServiceCardNOFromDate.Text);
					objConductorEmployee.ServiceCardNOToDate = System.DateTime.Parse(txtServiceCardNOToDate.Text);
					objConductorEmployee.BusID = System.Int32.Parse(ddlBusID.SelectedItem.Value);
					objConductorEmployee.CreateUser = UserName ;
					objConductorEmployee.UpdateUser =  UserName ;
					objConductorEmployee.UpdateDateTime = System.DateTime.Now;
					objConductorEmployee.Flag = 1;
                    objConductorEmployee.FlagDateTime = System.DateTime.Now;
                    ConductorEmployeeBiz.AddConductorEmployee(objConductorEmployee);
					ViewState["Action"] = "edit";
					
					txtID.ReadOnly = true;
					
					txtID.ReadOnly = true;
					txtID.Text = objConductorEmployee.ID.ToString();
					
				}
				else if((string)ViewState["Action"] == "edit")
				{
					ConductorEmployee objConductorEmployee = ConductorEmployeeBiz.GetConductorEmployee(System.Int32.Parse(txtID.Text));
					
					objConductorEmployee.ID = System.Int32.Parse(txtID.Text);
					
					objConductorEmployee.IDCard = txtIDCard.Text;
					
					objConductorEmployee.Name = txtName.Text;
					
					objConductorEmployee.Sex = System.Boolean.Parse(ddlSex.Text);
					
					objConductorEmployee.Phone = txtPhone.Text;
					
					objConductorEmployee.Landscape = ddlLandscape.SelectedItem.Value;
					
					objConductorEmployee.Address = txtAddress.Text;
					
					objConductorEmployee.BirthDay = System.DateTime.Parse(txtBirthDay.Text);
					
                    //objConductorEmployee.Photo = System.Byte[].Parse(txtPhoto.Text);
					
					objConductorEmployee.ServiceUnit = txtServiceUnit.Text;
					
					objConductorEmployee.Education = ddlEducation.SelectedItem.Value;
					
					objConductorEmployee.ServiceCardNO = txtServiceCardNO.Text;
					
					objConductorEmployee.ServiceCardNOFromDate = System.DateTime.Parse(txtServiceCardNOFromDate.Text);
					
					objConductorEmployee.ServiceCardNOToDate = System.DateTime.Parse(txtServiceCardNOToDate.Text);
					
					objConductorEmployee.BusID = System.Int32.Parse(ddlBusID.SelectedItem.Value);

                    objConductorEmployee.UpdateUser = UserName;

                    objConductorEmployee.UpdateDateTime = System.DateTime.Now;
					
					ConductorEmployeeBiz.UpdateConductorEmployee(objConductorEmployee);
				}
				lblMessage.Text = "保存成功！";
			}
			catch(Exception ex)
			{
				lblMessage.Text = ex.Message;
			}
		}
	}
