
using System;
using System.Data;
using System.Web.UI.WebControls;
using System.Web.SessionState;
using AVC.Business;
using AVC.DataEntity;

	/// <summary>
	/// CarOwners编辑
	/// </summary>
public partial class CarOwnersEdit : LoginPageBase
	{

		private void Page_Load(object sender, System.EventArgs e)
		{
			if(!IsPostBack)
			{
				string strAction = Request.QueryString["action"];
				// 自动编号
                BindDropDownList();
				txtID.ReadOnly = true;
				txtID.Text = "自动增长";	
				ViewState["Action"] = strAction;
				if(strAction == "edit")
				{
					System.Int32 ID = System.Int32.Parse(Request.QueryString["ID"]);CarOwners objCarOwners = CarOwnersBiz.GetCarOwners(ID);
					
					txtID.Text = objCarOwners.ID.ToString();
					txtOwnersName.Text = objCarOwners.OwnersName;
					txtOwnersAdress.Text = objCarOwners.OwnersAdress;
					txtOwnersLicenseNo.Text = objCarOwners.OwnersLicenseNo;
                    txtLicenseNoApprovalDate.Text = objCarOwners.LicenseNoApprovalDate.ToString("yyyy-MM-dd");
                    txtLicenseNoFromDate.Text = objCarOwners.LicenseNoFromDate.ToString("yyyy-MM-dd");
                    txtLicenseNoToDate.Text = objCarOwners.LicenseNoToDate.ToString("yyyy-MM-dd");
					txtBusinessNo.Text = objCarOwners.BusinessNo;
                    txtBusinessNoApprovalDate.Text = objCarOwners.BusinessNoApprovalDate.ToString("yyyy-MM-dd");
                    txtBusinessNoFromDate.Text = objCarOwners.BusinessNoFromDate.ToString("yyyy-MM-dd");
                    txtBusinessNoToDate.Text = objCarOwners.BusinessNoToDate.ToString("yyyy-MM-dd");
                    ddlBusinessNature.SelectedItem.Value = objCarOwners.BusinessNature;
					txtCorporate.Text = objCarOwners.Corporate;
					txtPhone.Text = objCarOwners.Phone;
					txtID.ReadOnly = true;
					
				}
			}
		}


    private void BindDropDownList()
    {
        ddlBusinessNature.DataSource = OptionalValueBiz.GetOptionValueByDescription("ownermode");
        ddlBusinessNature.DataBind();
    }
		public void btnOK_Click(object sender, System.EventArgs e)
		{
			try
			{
				if((string)ViewState["Action"] == "add")
				{
					CarOwners objCarOwners = new CarOwners();
					
					objCarOwners.OwnersName = txtOwnersName.Text;
					objCarOwners.OwnersAdress = txtOwnersAdress.Text;
					objCarOwners.OwnersLicenseNo = txtOwnersLicenseNo.Text;
					objCarOwners.LicenseNoApprovalDate = System.DateTime.Parse(txtLicenseNoApprovalDate.Text);
					objCarOwners.LicenseNoFromDate = System.DateTime.Parse(txtLicenseNoFromDate.Text);
					objCarOwners.LicenseNoToDate = System.DateTime.Parse(txtLicenseNoToDate.Text);
					objCarOwners.BusinessNo = txtBusinessNo.Text;
					objCarOwners.BusinessNoApprovalDate = System.DateTime.Parse(txtBusinessNoApprovalDate.Text);
					objCarOwners.BusinessNoFromDate = System.DateTime.Parse(txtBusinessNoFromDate.Text);
					objCarOwners.BusinessNoToDate = System.DateTime.Parse(txtBusinessNoToDate.Text);
                    objCarOwners.BusinessNature = ddlBusinessNature.SelectedItem.Value;
					objCarOwners.Corporate = txtCorporate.Text;
					objCarOwners.Phone = txtPhone.Text;
					objCarOwners.CreateUser = USERNAME;
                    objCarOwners.UpdateUser = USERNAME;
                    objCarOwners.UpdateDateTime = System.DateTime.Now;
                    objCarOwners.Flag = 1;
					objCarOwners.FlagDateTime = System.DateTime.Parse("1900-1-1");
                    CarOwnersBiz.AddCarOwners(objCarOwners);
					ViewState["Action"] = "edit";
					
					txtID.ReadOnly = true;
					
					txtID.ReadOnly = true;
					txtID.Text = objCarOwners.ID.ToString();
					
				}
				else if((string)ViewState["Action"] == "edit")
				{
					CarOwners objCarOwners = CarOwnersBiz.GetCarOwners(System.Int32.Parse(txtID.Text));
					
					objCarOwners.ID = System.Int32.Parse(txtID.Text);
					
					objCarOwners.OwnersName = txtOwnersName.Text;
					
					objCarOwners.OwnersAdress = txtOwnersAdress.Text;
					
					objCarOwners.OwnersLicenseNo = txtOwnersLicenseNo.Text;
					
					objCarOwners.LicenseNoApprovalDate = System.DateTime.Parse(txtLicenseNoApprovalDate.Text);
					
					objCarOwners.LicenseNoFromDate = System.DateTime.Parse(txtLicenseNoFromDate.Text);
					
					objCarOwners.LicenseNoToDate = System.DateTime.Parse(txtLicenseNoToDate.Text);
					
					objCarOwners.BusinessNo = txtBusinessNo.Text;
					
					objCarOwners.BusinessNoApprovalDate = System.DateTime.Parse(txtBusinessNoApprovalDate.Text);
					
					objCarOwners.BusinessNoFromDate = System.DateTime.Parse(txtBusinessNoFromDate.Text);
					
					objCarOwners.BusinessNoToDate = System.DateTime.Parse(txtBusinessNoToDate.Text);

                    objCarOwners.BusinessNature = ddlBusinessNature.SelectedItem.Value;
					
					objCarOwners.Corporate = txtCorporate.Text;
					
					objCarOwners.Phone = txtPhone.Text;
								
					objCarOwners.UpdateUser = USERNAME ;

                    objCarOwners.UpdateDateTime = System.DateTime.Now;

					CarOwnersBiz.UpdateCarOwners(objCarOwners);
				}
				lblMessage.Text = "保存成功！";
			}
			catch(Exception ex)
			{
				lblMessage.Text = ex.Message;
			}
		}
	}
