using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using AVC.Passport;
using AVC.Passport.DataEntity;

public partial class GroupRights : LoginPageBase
{
	protected void Page_Load(object sender, System.EventArgs e)
	{
        btnOK.Attributes.Add("onclick", "return BeforeSubmit('" + btnOK.ClientID + "');");

		if(!IsPostBack)
		{
			//判断权限
			if(!CheckRight("GroupAdmin"))
			{
				NoRightAlert();
			}

			string strSubSystemID = Request.QueryString["subsystemid"] + "";
			ViewState["SubSystemID"] = strSubSystemID;

			labSubSystemName.Text = SubSystemBiz.GetSubSystem(strSubSystemID).SubSystemName;

            string strGroupID = Request["groupid"] + "";
			int intGroupID;
			int.TryParse(strGroupID, out intGroupID);
            string strParentGroupID = Request["parentid"] + "";
			int intParentGroupID;
			int.TryParse(strParentGroupID, out intParentGroupID);

            ViewState["GroupID"] = intGroupID;
            ViewState["ParentGroupID"] = intParentGroupID;
		}
        InitRightsControls();
        if (!IsPostBack)
        {
            InitGroupRights();
        }
    }

    /// <summary>
    /// 绑定所有权限
    /// </summary>
    private void InitRightsControls()
    {
        // 获取当前用户的所有权限，用户不能给别人分配他所没有的权限。
        DataTable dtAllRights = null;
        string strSubSystemID = System.Configuration.ConfigurationManager.AppSettings["SubSystemID"];
        if (strSubSystemID == (string)ViewState["SubSystemID"] && !CheckRight("SuperAdmin"))
        {
			// 如果当前的子系统是所选系统（即管理中心），则判断是否超级管理员，如果不是超级管理员，则他只能分配自己所拥有的权限
            dtAllRights = UserMstBiz.GetAllRights((string)ViewState["SubSystemID"], UserID);
        }
        else
        {
            dtAllRights = RightsBiz.GetRightsBySubSystemID((string)ViewState["SubSystemID"]);
        }

        // 获取该组所属父组所有的权限(包含继承的权限)
		DataTable dtParentGroupRights = GroupBiz.GetAllRights((string)ViewState["SubSystemID"], GroupBiz.GetGroup((string)ViewState["SubSystemID"], (int)ViewState["GroupID"]).ParentGroupID);

        string strTypeName = "";
        HtmlTableRow row = null;
        HtmlTableCell cell = null;
        for (int i = 0; i < dtAllRights.Rows.Count; i++)
        {
            if (strTypeName != (string)dtAllRights.Rows[i]["RightType"])
            {
                // 先把上面的权限写入表格，然后建立新权限行
                if (cell != null)
                {
                    row.Cells.Add(cell);
                    tblRights.Rows.Insert(tblRights.Rows.Count, row);
                }

                // 写入权限类别行
                strTypeName = (string)dtAllRights.Rows[i]["RightType"];
                Label labTypeName = new Label();
                labTypeName.Text = strTypeName;
                row = new HtmlTableRow();
                cell = new HtmlTableCell();
                cell.Attributes.Add("class", "EditTitle");
                cell.Controls.Add(labTypeName);
                row.Cells.Add(cell);
                tblRights.Rows.Add(row);

                // 新建权限行
                row = new HtmlTableRow();
                cell = new HtmlTableCell();
                cell.Attributes.Add("class", "EditInput");
            }

            // 添加控件
            HtmlInputCheckBox chkRight = new HtmlInputCheckBox();
            chkRight.Value = ((int)dtAllRights.Rows[i]["RightID"]).ToString();
            chkRight.ID = "chkRight_" + i.ToString();

            HtmlGenericControl labRightName = new HtmlGenericControl("label");
            labRightName.InnerText = (string)dtAllRights.Rows[i]["RightDisplayName"] + HttpUtility.HtmlDecode("&nbsp; ");
            labRightName.Attributes.Add("title", (string)dtAllRights.Rows[i]["RightMemo"]);
            labRightName.Attributes.Add("for", "chkRight_" + i.ToString());

            // 判断是否继承父权限
            if (dtParentGroupRights.Select("RightName='" + (string)dtAllRights.Rows[i]["RightName"] + "'").Length != 0)
            {
                chkRight.Disabled = true;
                chkRight.Checked = true;
                labRightName.Attributes.Add("style", "COLOR: green");
            }

            cell.Controls.Add(chkRight);
            cell.Controls.Add(labRightName);
        }
        if (cell != null)
        {
            row.Cells.Add(cell);
            tblRights.Rows.Insert(tblRights.Rows.Count, row);
        }
    }

    private void InitGroupRights()
    {
        // 获取该组已有的权限(不包含继承的权限)
		DataTable dtGroupRights = GroupBiz.GroupRights((string)ViewState["SubSystemID"], (int)ViewState["GroupID"]);
        HtmlInputCheckBox chkRight;
        for (int i = 0; i < tblRights.Rows.Count; i++)
        {
            for (int j = 0; j < tblRights.Rows[i].Cells[0].Controls.Count; j++)
            {
                System.Web.UI.Control c = tblRights.Rows[i].Cells[0].Controls[j];
                if (c is HtmlInputCheckBox)
                {
                    chkRight = (HtmlInputCheckBox)c;
                    if (dtGroupRights.Select("RightID='" + chkRight.Value + "'").Length != 0 && !chkRight.Disabled)
                    {
                        chkRight.Checked = true;
                    }
                }
            }
        }

        ViewState["GroupRights"] = dtGroupRights;
    }

    protected void btnOK_Click(object sender, System.EventArgs e)
    {
        DataTable dtGroupRights = (DataTable)ViewState["GroupRights"];
        int intGroupID = (int)ViewState["GroupID"];
        HtmlInputCheckBox chkRight;
        // 循环判断权限是否打勾了
        for (int i = 0; i < tblRights.Rows.Count; i++)
        {
            for (int j = 0; j < tblRights.Rows[i].Cells[0].Controls.Count; j++)
            {
                System.Web.UI.Control c = tblRights.Rows[i].Cells[0].Controls[j];
                if (c is HtmlInputCheckBox)
                {
                    chkRight = (HtmlInputCheckBox)c;
                    if (chkRight.Checked && !chkRight.Disabled)
                    {
                        if (dtGroupRights.Select("RightID='" + chkRight.Value + "'").Length == 0)
                        {
                            // 如果选中权限，而且权限还没有被加入时，加入权限。
                            GroupBiz.AddGroupRights(intGroupID, int.Parse(chkRight.Value), UserID);
                        }
                    }
                    if (!chkRight.Checked)
                    {
                        if (dtGroupRights.Select("RightID='" + chkRight.Value + "'").Length != 0)
                        {
                            // 如果选中权限，而且权限还没有被加入时，加入权限。
                            GroupBiz.RemoveGroupRights(intGroupID, int.Parse(chkRight.Value));
                        }
                    }
                }
            }
        }
		ShowServerMessage("保存成功", "操作员组权限保存成功！", "Passport/GroupList.aspx?subsystemid=" + (string)ViewState["SubSystemID"] + "parentid=" + ((int)ViewState["ParentGroupID"]).ToString());
    }
}