﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_AdminDetail : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!IsPostBack)
        {
            if (_AdminBeanLogin != null)
            {
                GetAdmin(_AdminBeanLogin.ID.Value);
            }
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 载入管理员资料
    /// </summary>
    /// <param name="AdminBaseID">管理员ID</param>
    private void GetAdmin(Guid AdminBaseID)
    {
        AdminBaseBean _AdminBaseBean = (AdminBaseBean)SnSee.Factory.Factory.AdminBase.Select(AdminBaseID);
        if (_AdminBaseBean != null)
        {
            txtAdminName.Text = _AdminBaseBean.AdminName;
        }
    }

    /// <summary>
    /// 保存
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnOk_Click(object sender, EventArgs e)
    {
        //SnSee.Tool.MessageTool.MessageBox(this.Page, "为了演示时，其它查看演示网友能进入后台，这里不允许修改用户及密码，请大家理解一下！", Request.RawUrl);
        //return;
        string AdminPwd = txtAdminPwd.Text;
        string NewAdminPwd = txtNewAdminPwd.Text;
        string NewAdminPwd2 = txtNewAdminPwd2.Text;

        AdminBaseBean _AdminBaseBean = new AdminBaseBean();
        if (chkIsPassword.Checked)
        {
            if (string.IsNullOrEmpty(AdminPwd) || string.IsNullOrEmpty(NewAdminPwd) || string.IsNullOrEmpty(NewAdminPwd2))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入原始密码或新密码！");
                return;
            }

            if (NewAdminPwd != NewAdminPwd2)
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "新密码与确认密码不符合，请重新输入！");
                return;
            }

            if (!SnSee.Module.Admin.Admin.CheckAdmin(_AdminBeanLogin.AdminName, AdminPwd))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "您输入的原密码与现在的密码不符合，请重新输入！");
                return;
            }

            _AdminBaseBean.AdminPwd = SnSee.Module.Admin.Admin.SetAdminPassword(NewAdminPwd);
        }
        _AdminBaseBean.State = 1;
        if (SnSee.Factory.Factory.AdminBase.Update(_AdminBaseBean, _AdminBeanLogin.ID.Value))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，资料编辑成功！", Request.RawUrl);
        }
    }
}
